/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pushtocloud;

import java.nio.file.Path;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.dbms.DumpCommandProvider;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.pushtocloud.PushToCloudCommand;

class RealDumpCreator
implements PushToCloudCommand.DumpCreator {
    private final Path homeDir;
    private final Path configDir;
    private final OutsideWorld outsideWorld;

    RealDumpCreator(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    @Override
    public void dumpDatabase(String database, Path targetDumpFile) throws CommandFailed, IncorrectUsage {
        String[] args = (String[])Iterators.array((Object[])new String[]{"--database", database, "--to", targetDumpFile.toString()});
        new DumpCommandProvider().create(this.homeDir, this.configDir, this.outsideWorld).execute(args);
        this.outsideWorld.outStream().printf("Dumped contents of database '%s' into '%s'%n", database, targetDumpFile);
    }
}

