/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.time.Clock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.CommandResponseHandler;
import org.neo4j.export.aura.AuraClient;
import org.neo4j.export.aura.AuraConsole;
import org.neo4j.export.aura.AuraJsonMapper;
import org.neo4j.export.util.ExportTestUtilities;
import org.neo4j.export.util.IOCommon;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.time.Clocks;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.org.hamcrest.CoreMatchers;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.MatcherAssert;
import wiremock.org.hamcrest.Matchers;

@TestDirectoryExtension
public class AuraClientTest {
    private static final int TEST_PORT = 8080;
    private static final String TEST_CONSOLE_URL = "http://localhost:8080";
    private static final String STATUS_POLLING_PASSED_SECOND_CALL = "Passed second";
    private static final AuraClient.ProgressListenerFactory NO_OP_PROGRESS = (name, length) -> ProgressListener.NONE;
    private static final int HTTP_UNPROCESSABLE_ENTITY = 422;
    static final String ERROR_REASON_EXCEEDS_MAX_SIZE = "ImportExceedsMaxSize";
    private final DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    WireMockServer wireMock;
    ExecutionContext ctx;
    @Inject
    TestDirectory directory;

    private static void assertThrows(Class<? extends Exception> exceptionClass, Matcher<String> message, ThrowingRunnable action) {
        try {
            action.run();
            Assertions.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)exceptionClass.isInstance(e));
            MatcherAssert.assertThat((Object)e.getMessage(), message);
        }
    }

    @BeforeEach
    public void setup() {
        this.wireMock = new WireMockServer(8080);
        WireMock.configureFor((String)"localhost", (int)8080);
        this.wireMock.start();
        Path dir = this.directory.homePath();
        PrintStream out = new PrintStream(OutputStream.nullOutputStream());
        this.ctx = new ExecutionContext(dir, dir, out, out, (FileSystemAbstraction)this.fs);
    }

    @AfterEach
    public void teardown() {
        this.wireMock.stop();
    }

    public AuraClient buildTestAuraClient(boolean consentConfirmed) {
        AuraClient.AuraClientBuilder builder = new AuraClient.AuraClientBuilder(this.ctx);
        AuraConsole testConsole = new AuraConsole(TEST_CONSOLE_URL, "deadbeef");
        return builder.withAuraConsole(testConsole).withConsent(consentConfirmed).withUserName("username").withPassword("password".toCharArray()).withBoltURI("bolt://hello.com").withClock((Clock)Clocks.nanoClock()).withCommandResponseHandler(new CommandResponseHandler(this.ctx)).withProgressListenerFactory((name, length) -> new ExportTestUtilities.ControlledProgressListener()).withSleeper(millis -> {}).build();
    }

    public AuraClient buildTestAuraClientWithMockSleeper(boolean consentConfirmed) {
        IOCommon.Sleeper sleeper = (IOCommon.Sleeper)Mockito.mock(IOCommon.Sleeper.class);
        AuraClient.AuraClientBuilder builder = new AuraClient.AuraClientBuilder(this.ctx);
        AuraConsole testConsole = new AuraConsole(TEST_CONSOLE_URL, "deadbeef");
        return builder.withAuraConsole(testConsole).withConsent(consentConfirmed).withUserName("username").withPassword("password".toCharArray()).withBoltURI("bolt://hello.com").withClock((Clock)Clocks.nanoClock()).withCommandResponseHandler(new CommandResponseHandler(this.ctx)).withProgressListenerFactory(NO_OP_PROGRESS).withSleeper(sleeper).build();
    }

    public AuraClient buildTestAuraClientWithProgressListenerFactory(boolean consentConfirmed, AuraClient.ProgressListenerFactory progressListenerFactory) {
        AuraClient.AuraClientBuilder builder = new AuraClient.AuraClientBuilder(this.ctx);
        AuraConsole testConsole = new AuraConsole(TEST_CONSOLE_URL, "deadbeef");
        return builder.withAuraConsole(testConsole).withConsent(consentConfirmed).withUserName("username").withPassword("password".toCharArray()).withBoltURI("bolt://hello.com").withClock((Clock)Clocks.nanoClock()).withCommandResponseHandler(new CommandResponseHandler(this.ctx)).withProgressListenerFactory(progressListenerFactory).withSleeper(millis -> {}).build();
    }

    @Test
    public void runHappyPathTest() throws CommandFailedException, IOException, InterruptedException {
        Path source = this.createDump();
        ExportTestUtilities.ControlledProgressListener progressListener = new ExportTestUtilities.ControlledProgressListener();
        AuraClient.ProgressListenerFactory progressListenerFactory = (name, length) -> progressListener;
        AuraClient auraClient = this.buildTestAuraClientWithProgressListenerFactory(true, progressListenerFactory);
        long sourceLength = this.fs.getFileSize(source);
        long dbSize = sourceLength * 4L;
        long crc32Sum = 12345L;
        String authorizationTokenResponse = "abc";
        String signedURIPath = "/signed";
        this.wireMock.stubFor(this.authenticationRequest(true).willReturn(this.successfulAuthorizationResponse(authorizationTokenResponse)));
        this.wireMock.stubFor(this.initiateUploadTargetRequest(authorizationTokenResponse).willReturn(this.successfulInitiateUploadTargetResponse(signedURIPath)));
        this.wireMock.stubFor(this.sizeCheckTargetRequest(authorizationTokenResponse, dbSize).willReturn(this.successfulSizeCheckTargetResponse()));
        this.wireMock.stubFor(this.triggerImportRequest(authorizationTokenResponse).willReturn(this.successfulTriggerImportResponse()));
        this.wireMock.stubFor(this.completeUploadTargetRequest(authorizationTokenResponse, crc32Sum).willReturn(this.successfulCompleteUploadTargetResponse()));
        this.wireMock.stubFor(this.firstStatusPollingRequest(authorizationTokenResponse));
        this.wireMock.stubFor(this.secondStatusPollingRequest(authorizationTokenResponse));
        auraClient.authenticate(true);
        auraClient.checkSize(true, dbSize, authorizationTokenResponse);
        auraClient.initatePresignedUpload(crc32Sum, dbSize, dbSize, authorizationTokenResponse);
        auraClient.doStatusPolling(true, authorizationTokenResponse, dbSize);
        auraClient.triggerGCPImportProtocol(true, source, crc32Sum, authorizationTokenResponse);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/size$")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"FullSize", (StringValuePattern)WireMock.equalTo((String)String.valueOf(dbSize)))));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import$")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"FullSize", (StringValuePattern)WireMock.equalTo((String)String.valueOf(dbSize)))));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/upload-complete$")));
        Assertions.assertTrue((boolean)progressListener.closeCalled);
        Assertions.assertEquals((long)100L, (long)progressListener.progress);
        Assertions.assertTrue((boolean)this.fs.fileExists(source));
        progressListener.close();
    }

    @Test
    void shouldHandleBadCredentialsInAuthorizationRequest() {
        AuraClient auraClient = this.buildTestAuraClient(true);
        this.wireMock.stubFor(this.authenticationRequest(true).willReturn(WireMock.aResponse().withStatus(401)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.equalTo((Object)"Invalid username/password credentials"), () -> auraClient.authenticate(true));
    }

    @Test
    void shouldHandleUnknownDbid() {
        AuraClient auraClient = this.buildTestAuraClient(true);
        this.wireMock.stubFor(this.authenticationRequest(true).willReturn(WireMock.aResponse().withStatus(404)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"please check your Bolt URI"), () -> auraClient.authenticate(true));
    }

    @Test
    void shouldHandleMoveUploadTargetRoute() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(true);
        Path source = this.createDump();
        long crc32Sum = 12345L;
        String authorizationTokenResponse = "abc";
        this.wireMock.stubFor(this.authenticationRequest(false).willReturn(this.successfulAuthorizationResponse(authorizationTokenResponse)));
        this.wireMock.stubFor(this.initiateUploadTargetRequest("abc").willReturn(WireMock.aResponse().withStatus(404)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"please contact support"), () -> auraClient.triggerGCPImportProtocol(true, source, crc32Sum, authorizationTokenResponse));
    }

    @Test
    void shouldGiveResumableErrorWhenIncorrectInitiateResponse() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(true);
        Path source = this.createDump();
        long crc32Sum = 12345L;
        String authorizationTokenResponse = "abc";
        this.wireMock.stubFor(this.authenticationRequest(false).willReturn(this.successfulAuthorizationResponse(authorizationTokenResponse)));
        this.wireMock.stubFor(this.completeUploadTargetRequest("abc", crc32Sum).willReturn(WireMock.aResponse().withStatus(429)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"You can re-try using the existing dump by running this command"), () -> auraClient.triggerGCPImportProtocol(true, source, crc32Sum, authorizationTokenResponse));
    }

    @Test
    void shouldHandleImportRequestMovedRoute() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(true);
        Path source = this.createDump();
        long crc32Sum = 12345L;
        String authorizationTokenResponse = "abc";
        this.wireMock.stubFor(this.authenticationRequest(false).willReturn(this.successfulAuthorizationResponse(authorizationTokenResponse)));
        this.wireMock.stubFor(this.completeUploadTargetRequest("abc", crc32Sum).willReturn(WireMock.aResponse().withStatus(404)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"please contact support"), () -> auraClient.triggerGCPImportProtocol(true, source, crc32Sum, authorizationTokenResponse));
    }

    @Test
    void shouldHandleInsufficientSpaceInSizeRequest() {
        AuraClient auraClient = this.buildTestAuraClient(true);
        String errorBody = "{\"Message\":\"Store is too big for this neo4j aura instance.\",\"Reason\":\"ImportExceedsMaxSize\"}";
        ResponseDefinitionBuilder response = WireMock.aResponse().withStatus(422).withBody(errorBody);
        this.wireMock.stubFor(this.initiateSizeRequest("fakeToken", 100000000L).willReturn(response));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"too big"), () -> auraClient.checkSize(false, 100000000L, "fakeToken"));
    }

    @Test
    void shouldHandleSufficientSpaceInSizeRequest() {
        AuraClient auraClient = this.buildTestAuraClient(true);
        ResponseDefinitionBuilder response = WireMock.aResponse().withStatus(200);
        this.wireMock.stubFor(this.initiateSizeRequest("fakeToken", 100000000L).willReturn(response));
        auraClient.checkSize(false, 100000000L, "fakeToken");
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/size$")));
    }

    @Test
    void shouldHandleInsufficientCredentialsInAuthorizationRequest() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(true);
        this.wireMock.stubFor(this.authenticationRequest(true).willReturn(WireMock.aResponse().withStatus(403)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"administrative access"), () -> auraClient.authenticate(false));
    }

    @Test
    void shouldHandleUnexpectedResponseFromAuthorizationRequest() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(true);
        this.wireMock.stubFor(this.authenticationRequest(true).willReturn(WireMock.aResponse().withStatus(500)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"Unexpected response"), CoreMatchers.containsString((String)"Authorization")}), () -> auraClient.authenticate(false));
    }

    @Test
    void shouldHandleUnauthorizedResponseFromInitiateUploadTarget() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(true);
        Path source = this.createDump();
        long sourceLength = this.fs.getFileSize(source);
        long dbSize = sourceLength * 4L;
        long crc32Sum = 12345L;
        String token = "abc";
        this.wireMock.stubFor(this.authenticationRequest(true).willReturn(this.successfulAuthorizationResponse(token)));
        this.wireMock.stubFor(this.initiateUploadTargetRequest(token).willReturn(WireMock.aResponse().withStatus(401)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"authorization token is invalid"), () -> auraClient.initatePresignedUpload(crc32Sum, dbSize, sourceLength, token));
    }

    @Test
    void shouldHandleValidationFailureResponseFromInitiateUploadTarget() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(true);
        ObjectMapper mapper = new ObjectMapper();
        Path source = this.createDump();
        long sourceLength = this.fs.getFileSize(source);
        long dbSize = sourceLength * 4L;
        long crc32Sum = 12345L;
        String token = "abc";
        String errorMessage = "Dump file rejected for some reason.";
        String errorReason = "some-kind-of-error-reason-code-goes-here";
        String errorUrl = "https://example.com/heres-how-to-fix-this-error";
        AuraJsonMapper.ErrorBody errorBody = new AuraJsonMapper.ErrorBody(errorMessage, errorReason, errorUrl);
        this.wireMock.stubFor(this.authenticationRequest(false).willReturn(this.successfulAuthorizationResponse(token)));
        this.wireMock.stubFor(this.initiateUploadTargetRequest(token).willReturn(WireMock.aResponse().withBody(mapper.writeValueAsString((Object)errorBody)).withHeader("Content-Type", new String[]{"application/json"}).withStatus(422)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)errorMessage), CoreMatchers.containsString((String)errorUrl), Matchers.not((Matcher)CoreMatchers.containsString((String)errorReason)), Matchers.not((Matcher)CoreMatchers.containsString((String)".."))}), () -> auraClient.initatePresignedUpload(crc32Sum, dbSize, sourceLength, token));
    }

    @Test
    void shouldHandleValidationFailureResponseWithoutUrlFromInitiateUploadTarget() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(false);
        ObjectMapper mapper = new ObjectMapper();
        Path source = this.createDump();
        long sourceLength = this.fs.getFileSize(source);
        long dbSize = sourceLength * 4L;
        long crc32Sum = 12345L;
        String token = "abc";
        String errorMessage = "Something bad happened, but we don't have a URL to share with more information.";
        String errorReason = "the-bad-thing-happened";
        AuraJsonMapper.ErrorBody errorBody = new AuraJsonMapper.ErrorBody(errorMessage, errorReason, null);
        this.wireMock.stubFor(this.authenticationRequest(false).willReturn(this.successfulAuthorizationResponse(token)));
        this.wireMock.stubFor(this.initiateUploadTargetRequest(token).willReturn(WireMock.aResponse().withBody(mapper.writeValueAsString((Object)errorBody)).withHeader("Content-Type", new String[]{"application/json"}).withStatus(422)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)Matchers.not((Matcher)CoreMatchers.containsString((String)"null")), () -> auraClient.initatePresignedUpload(crc32Sum, dbSize, sourceLength, token));
    }

    @Test
    void shouldHandleEmptyValidationFailureResponseFromInitiateUploadTarget() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(false);
        Path source = this.createDump();
        long sourceLength = this.fs.getFileSize(source);
        long dbSize = sourceLength * 4L;
        long crc32Sum = 12345L;
        String token = "abc";
        this.wireMock.stubFor(this.initiateUploadTargetRequest(token).willReturn(WireMock.aResponse().withStatus(422)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"No content to map due to end-of-input"), Matchers.not((Matcher)CoreMatchers.containsString((String)"null")), Matchers.not((Matcher)CoreMatchers.containsString((String)".."))}), () -> auraClient.initatePresignedUpload(crc32Sum, dbSize, sourceLength, token));
    }

    @Test
    void shouldHandleValidationFailureResponseWithShortMessageFromInitiateUploadTarget() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(false);
        ObjectMapper mapper = new ObjectMapper();
        Path source = this.createDump();
        long sourceLength = this.fs.getFileSize(source);
        long dbSize = sourceLength * 4L;
        long crc32Sum = 12345L;
        String token = "abc";
        String errorMessage = "something bad happened";
        String errorUrl = "https://example.com/";
        AuraJsonMapper.ErrorBody errorBody = new AuraJsonMapper.ErrorBody(errorMessage, null, errorUrl);
        this.wireMock.stubFor(this.initiateUploadTargetRequest(token).willReturn(WireMock.aResponse().withBody(mapper.writeValueAsString((Object)errorBody)).withHeader("Content-Type", new String[]{"application/json"}).withStatus(422)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"Error: something bad happened. See: https://example.com/"), () -> auraClient.initatePresignedUpload(crc32Sum, dbSize, sourceLength, token));
    }

    @Test
    void shouldHandleSizeValidationFailureResponseFromInitiateUploadTarget() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(false);
        ObjectMapper mapper = new ObjectMapper();
        Path source = this.createDump();
        long sourceLength = this.fs.getFileSize(source);
        long dbSize = sourceLength * 4L;
        long crc32Sum = 12345L;
        String token = "abc";
        String errorMessage = "There is insufficient space in your Neo4j Aura instance to upload your data. Please use the Console to increase the size of your database.";
        String errorUrl = "https://console.neo4j.io/";
        AuraJsonMapper.ErrorBody errorBody = new AuraJsonMapper.ErrorBody(errorMessage, ERROR_REASON_EXCEEDS_MAX_SIZE, errorUrl);
        this.wireMock.stubFor(this.authenticationRequest(false).willReturn(this.successfulAuthorizationResponse(token)));
        this.wireMock.stubFor(this.initiateUploadTargetRequest(token).willReturn(WireMock.aResponse().withBody(mapper.writeValueAsString((Object)errorBody)).withHeader("Content-Type", new String[]{"application/json"}).withStatus(422)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)errorMessage), CoreMatchers.containsString((String)"Minimum storage space required: 0"), CoreMatchers.containsString((String)"See: https://console.neo4j.io"), Matchers.not((Matcher)CoreMatchers.containsString((String)".."))}), () -> auraClient.initatePresignedUpload(crc32Sum, dbSize, sourceLength, token));
    }

    @Test
    void shouldHandleConflictResponseFromAuthenticationWithoutUserConsent() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(false);
        String authorizationTokenResponse = "abc";
        String signedURIPath = "/signed";
        this.wireMock.stubFor(this.authenticationRequest(false).willReturn(WireMock.aResponse().withStatus(409)));
        this.wireMock.stubFor(this.authenticationRequest(true).willReturn(this.successfulAuthorizationResponse(authorizationTokenResponse)));
        this.wireMock.stubFor(this.initiateUploadTargetRequest(authorizationTokenResponse).willReturn(this.successfulInitiateUploadTargetResponse(signedURIPath)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"No consent to overwrite"), () -> auraClient.authenticate(true));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withHeader("Confirmed", WireMock.equalTo((String)"false")));
        WireMock.verify((int)0, (RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withHeader("Confirmed", WireMock.equalTo((String)"true")));
    }

    @Test
    void shouldHandleUnexpectedResponseFromInitiateUploadTargetRequest() throws IOException {
        AuraClient auraClient = this.buildTestAuraClient(false);
        Path source = this.createDump();
        long sourceLength = this.fs.getFileSize(source);
        long dbSize = sourceLength * 4L;
        long crc32Sum = 12345L;
        String authorizationTokenResponse = "abc";
        this.wireMock.stubFor(this.initiateUploadTargetRequest(authorizationTokenResponse).willReturn(WireMock.aResponse().withStatus(502)));
        AuraClientTest.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)"Unexpected response"), CoreMatchers.containsString((String)"Initiating upload target")}), () -> auraClient.initatePresignedUpload(crc32Sum, dbSize, sourceLength, authorizationTokenResponse));
        this.wireMock.verify(51, new RequestPatternBuilder(RequestMethod.ANY, UrlPattern.fromOneOf((String)"/v2/databases/deadbeef/import", null, null, null)));
    }

    @Test
    void shouldEstimateImportProgressBased() throws CommandFailedException {
        AuraClient auraClient = this.buildTestAuraClientWithMockSleeper(false);
        Assertions.assertEquals((int)0, (int)auraClient.importStatusProgressEstimate("running", 1234500000L, 6789000000L));
        Assertions.assertEquals((int)1, (int)auraClient.importStatusProgressEstimate("loading", 0L, 1234567890L));
        Assertions.assertEquals((int)2, (int)auraClient.importStatusProgressEstimate("loading", 1L, 98L));
        Assertions.assertEquals((int)50, (int)auraClient.importStatusProgressEstimate("loading", 49L, 98L));
        Assertions.assertEquals((int)98, (int)auraClient.importStatusProgressEstimate("loading", 97L, 98L));
        Assertions.assertEquals((int)99, (int)auraClient.importStatusProgressEstimate("loading", 98L, 98L));
        Assertions.assertEquals((int)99, (int)auraClient.importStatusProgressEstimate("loading", 99L, 98L));
        Assertions.assertEquals((int)99, (int)auraClient.importStatusProgressEstimate("loading", 100L, 98L));
        Assertions.assertEquals((int)1, (int)auraClient.importStatusProgressEstimate("loading", 1L, 196L));
        Assertions.assertEquals((int)2, (int)auraClient.importStatusProgressEstimate("loading", 2L, 196L));
        Assertions.assertEquals((int)50, (int)auraClient.importStatusProgressEstimate("loading", 98L, 196L));
    }

    private MappingBuilder initiateUploadTargetRequest(String authorizationTokenResponse) {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import$")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).withHeader("Accept", WireMock.equalTo((String)"application/json")).withHeader("Neo4j-Version", WireMock.matching((String)".*"));
    }

    private MappingBuilder sizeCheckTargetRequest(String authorizationTokenResponse, long dbSize) {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import/size$")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).withRequestBody((ContentPattern)WireMock.equalToJson((String)("{\"FullSize\": " + dbSize + "}")));
    }

    private MappingBuilder completeUploadTargetRequest(String authorizationTokenResponse, long crc32) {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import/upload-complete$")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).withRequestBody((ContentPattern)WireMock.equalToJson((String)("{\"Crc32\":" + crc32 + "}")));
    }

    private ResponseDefinitionBuilder successfulInitiateUploadTargetResponse(String signedURIPath) {
        return WireMock.aResponse().withStatus(202).withBody(String.format("{\"SignedURI\":\"%s\", \"expiration_date\":\"Fri, 04 Oct 2019 08:21:59 GMT\"}", TEST_CONSOLE_URL + signedURIPath));
    }

    private ResponseDefinitionBuilder successfulSizeCheckTargetResponse() {
        return WireMock.aResponse().withStatus(200);
    }

    private MappingBuilder initiateSizeRequest(String authorizationTokenResponse, long size) {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import/size$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).withHeader("Content-Type", WireMock.equalTo((String)"application/json"));
    }

    private Path createDump() throws IOException {
        Path file = this.directory.file("something");
        try (OutputStream outputStream = this.fs.openAsOutputStream(file, false);
             PrintStream out = new PrintStream(outputStream);){
            out.println("this is simply some weird dump data, but may do the trick for this test of uploading it");
        }
        return file;
    }

    private MappingBuilder authenticationRequest(boolean userConsent) {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withHeader("Authorization", WireMock.matching((String)"^Basic .*")).withHeader("Accept", WireMock.equalTo((String)"application/json")).withHeader("Confirmed", WireMock.equalTo((String)(userConsent ? "true" : "false")));
    }

    private ResponseDefinitionBuilder successfulAuthorizationResponse(String authorizationTokenResponse) {
        return WireMock.aResponse().withStatus(200).withBody(String.format("{\"Token\":\"%s\"}", authorizationTokenResponse));
    }

    private MappingBuilder triggerImportRequest(String authorizationTokenResponse) {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import/upload-complete$")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).withRequestBody((ContentPattern)WireMock.containing((String)"Crc32"));
    }

    private ResponseDefinitionBuilder successfulTriggerImportResponse() {
        return WireMock.aResponse().withStatus(200);
    }

    private ResponseDefinitionBuilder successfulCompleteUploadTargetResponse() {
        return WireMock.aResponse().withStatus(200);
    }

    private MappingBuilder firstStatusPollingRequest(String authorizationTokenResponse) {
        return WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).willReturn(this.firstSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs("Started").willSetStateTo(STATUS_POLLING_PASSED_SECOND_CALL);
    }

    private MappingBuilder secondStatusPollingRequest(String authorizationTokenResponse) {
        return WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).willReturn(this.secondSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs(STATUS_POLLING_PASSED_SECOND_CALL);
    }

    private ResponseDefinitionBuilder firstSuccessfulDatabaseRunningResponse() {
        return WireMock.aResponse().withBody("{\"Status\":\"loading\"}").withStatus(200);
    }

    private ResponseDefinitionBuilder secondSuccessfulDatabaseRunningResponse() {
        return WireMock.aResponse().withBody("{\"Status\":\"running\"}").withStatus(200);
    }

    private static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

