/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.export.aura.AuraConsole;
import org.neo4j.export.aura.AuraURLFactory;

public class AuraURLFactoryTest {
    private static AuraURLFactory auraURLFactory;

    @BeforeEach
    public void setUp() {
        auraURLFactory = new AuraURLFactory();
    }

    @Test
    public void testBuildConsoleURLWithInvalidURI() {
        boolean devMode = false;
        CommandFailedException exception = (CommandFailedException)Assertions.assertThrows(CommandFailedException.class, () -> auraURLFactory.buildConsoleURI("hello.local", devMode));
        Assertions.assertEquals((Object)"Invalid Bolt URI 'hello.local'", (Object)exception.getMessage());
    }

    @Test
    public void testBuildConsoleURInNonDevMode() {
        boolean devMode = false;
        CommandFailedException exception = (CommandFailedException)Assertions.assertThrows(CommandFailedException.class, () -> auraURLFactory.buildConsoleURI("neo4j+s://rogue-env.databases.neo4j-abc.io", devMode));
        Assertions.assertEquals((Object)"Invalid Bolt URI 'neo4j+s://rogue-env.databases.neo4j-abc.io'", (Object)exception.getMessage());
    }

    @Test
    public void testBuildConsoleURLWithValidProdURI() {
        boolean devMode = false;
        AuraConsole consoleUrl = auraURLFactory.buildConsoleURI("neo4j+s://rogue.databases.neo4j.io", devMode);
        Assertions.assertEquals((Object)"https://console.neo4j.io/v2/databases/rogue/import", (Object)consoleUrl.getImportUrl().toString());
    }

    @Test
    public void testBuildValidConsoleURInDevMode() {
        boolean devMode = true;
        AuraConsole consoleUrl = auraURLFactory.buildConsoleURI("neo4j+s://rogue-env.databases.neo4j-abc.io", devMode);
        Assertions.assertEquals((Object)"https://console-env.neo4j-abc.io/v2/databases/rogue/import", (Object)consoleUrl.getImportUrl().toString());
    }

    @Test
    public void testBuildValidConsoleURInPrivMode() {
        boolean devMode = false;
        AuraConsole consoleUrl = auraURLFactory.buildConsoleURI("neo4j+s://rogue.production-orch-0001.neo4j.io", devMode);
        Assertions.assertEquals((Object)"https://console.neo4j.io/v2/databases/rogue/import", (Object)consoleUrl.getImportUrl().toString());
    }

    @Test
    public void testBuildValidConsoleURInPrivModeInNonProd() {
        boolean devMode = false;
        AuraConsole consoleUrl = auraURLFactory.buildConsoleURI("neo4j+s://rogue.env-orch-0001.neo4j-abc.io", devMode);
        Assertions.assertEquals((Object)"https://console-env.neo4j-abc.io/v2/databases/rogue/import", (Object)consoleUrl.getImportUrl().toString());
        consoleUrl = auraURLFactory.buildConsoleURI("neo4j+s://rogue.staging-orch-0001.neo4j.io", devMode);
        Assertions.assertEquals((Object)"https://console-staging.neo4j.io/v2/databases/rogue/import", (Object)consoleUrl.getImportUrl().toString());
        CommandFailedException exception = (CommandFailedException)Assertions.assertThrows(CommandFailedException.class, () -> auraURLFactory.buildConsoleURI("neo4j+s://rogue.env-orch-0001.neo4j.io", devMode));
        Assertions.assertEquals((Object)"Invalid Bolt URI 'neo4j+s://rogue.env-orch-0001.neo4j.io'", (Object)exception.getMessage());
    }

    @Test
    public void testExceptionWithDevModeOnRealURI() {
        boolean devMode = true;
        CommandFailedException exception = (CommandFailedException)Assertions.assertThrows(CommandFailedException.class, () -> auraURLFactory.buildConsoleURI("neo4j+s://rogue.databases.neo4j.io", devMode));
        Assertions.assertEquals((Object)"Expected to find an environment running in dev mode in bolt URI: neo4j+s://rogue.databases.neo4j.io", (Object)exception.getMessage());
    }

    @Test
    public void shouldRecognizeBothEnvironmentAndDatabaseIdFromBoltURI() throws CommandFailedException {
        boolean devMode = false;
        AuraConsole consoleURL = auraURLFactory.buildConsoleURI("bolt+routing://mydbid-testenvironment.databases.neo4j.io", devMode);
        Assertions.assertEquals((Object)"https://console-testenvironment.neo4j.io/v2/databases/mydbid/import", (Object)consoleURL.getImportUrl().toString());
    }
}

