/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.aura.AuraJsonMapper;
import org.neo4j.export.providers.SignedUpload;
import org.neo4j.export.providers.SignedUploadAWS;
import org.neo4j.export.providers.SignedUploadGCP;
import org.neo4j.export.providers.SignedUploadURLFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class SignedUploadURLFactoryTest {
    @Inject
    TestDirectory directory;

    @Test
    public void fromAuraResponseTest() {
        AuraJsonMapper.SignedURIBodyResponse signedURIbodyResponse = new AuraJsonMapper.SignedURIBodyResponse();
        signedURIbodyResponse.Provider = "AWS";
        Path dir = this.directory.homePath();
        PrintStream out = new PrintStream(OutputStream.nullOutputStream());
        ExecutionContext ctx = new ExecutionContext(dir, dir, out, out, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
        SignedUpload expectedAWSSignedUpload = new SignedUploadURLFactory().fromAuraResponse(signedURIbodyResponse, ctx, "sausage");
        Assertions.assertThat((Object)expectedAWSSignedUpload).isInstanceOf(SignedUploadAWS.class);
    }

    @Test
    public void fromAuraGCPResponseTest() {
        AuraJsonMapper.SignedURIBodyResponse signedURIbodyResponse = new AuraJsonMapper.SignedURIBodyResponse();
        signedURIbodyResponse.Provider = "GCP";
        Path dir = this.directory.homePath();
        PrintStream out = new PrintStream(OutputStream.nullOutputStream());
        ExecutionContext ctx = new ExecutionContext(dir, dir, out, out, (FileSystemAbstraction)new DefaultFileSystemAbstraction());
        SignedUpload expectedGCPSignedUpload = new SignedUploadURLFactory().fromAuraResponse(signedURIbodyResponse, ctx, "sausage");
        Assertions.assertThat((Object)expectedGCPSignedUpload).isInstanceOf(SignedUploadGCP.class);
    }
}

