/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.BasicCredentials;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.apache.commons.io.output.NullOutputStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.CommandResponseHandler;
import org.neo4j.export.PushToCloudCLI;
import org.neo4j.export.UploadCommand;
import org.neo4j.export.UploadURLFactory;
import org.neo4j.export.aura.AuraClient;
import org.neo4j.export.aura.AuraConsole;
import org.neo4j.export.aura.AuraJsonMapper;
import org.neo4j.export.aura.AuraURLFactory;
import org.neo4j.export.providers.SignedUpload;
import org.neo4j.export.providers.SignedUploadAWS;
import org.neo4j.export.providers.SignedUploadGCP;
import org.neo4j.export.util.ExportTestUtilities;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.time.SystemNanoClock;
import picocli.CommandLine;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={TestDirectorySupportExtension.class})
@Neo4jLayoutExtension
public class UploadCommandTest {
    static final String ERROR_REASON_UNSUPPORTED_INDEXES = "LegacyIndexes";
    private static final int MOCK_SERVER_PORT = 8080;
    private static final String DBNAME = "neo4j";
    private static final String MOCK_BASE_URL = "http://localhost:8080";
    private static final String SOME_EXAMPLE_BOLT_URI = "bolt+routing://database_id.databases.neo4j.io";
    private static final String STATUS_POLLING_PASSED_FIRST_CALL = "Passed first";
    private static final String STATUS_POLLING_PASSED_SECOND_CALL = "Passed second";
    private static final String INITATE_PRESIGNED_UPLOAD_LOCATION = "/initiate-presigned";
    private static final String UPLOAD_PRESIGNED_LOCATION = "/upload-presigned";
    private static final String[] signedLinks = new String[]{"http://localhost:8080/signed1", "http://localhost:8080/signed2", "http://localhost:8080/signed3"};
    private final DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    WireMockServer wireMockServer;
    ExecutionContext ctx;
    @Inject
    TestDirectory directory;
    private Path dumpDir;
    private Path homeDir;
    private Path dump;
    private Path confPath;
    private long dbFullSize;
    @Inject
    private Neo4jLayout neo4jLayout;

    @BeforeEach
    public void setupEach() {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().port(8080).notifier((Notifier)new ConsoleNotifier(false)));
        WireMock.configureFor((String)"localhost", (int)8080);
        this.wireMockServer.start();
    }

    @BeforeAll
    public void setup() throws IOException {
        this.homeDir = this.directory.homePath();
        this.confPath = this.directory.directory("conf");
        Path configDir = this.directory.directory("config-dir");
        Path configFile = configDir.resolve("neo4j.conf");
        this.dumpDir = this.directory.directory("dumps");
        ExportTestUtilities.prepareDatabase(this.neo4jLayout.databaseLayout(DBNAME));
        Files.createFile(configFile, new FileAttribute[0]);
        PrintStream nullOutputStream = new PrintStream(NullOutputStream.nullOutputStream());
        this.ctx = new ExecutionContext(this.homeDir, this.confPath, nullOutputStream, nullOutputStream, this.directory.getFileSystem());
        this.dump = this.dumpDir.resolve("neo4j.dump");
        ExportTestUtilities.createDump(this.homeDir, this.confPath, this.dumpDir, (FileSystemAbstraction)this.fs, DBNAME);
        this.dbFullSize = UploadCommand.readSizeFromArchiveMetaData((ExecutionContext)this.ctx, (Path)this.dump);
    }

    @AfterEach
    public void teardown() {
        this.wireMockServer.stop();
    }

    @Test
    public void happyPathGCPUploadCommandTest() {
        String authResponse = "token";
        this.createAuraHappyPathStubs(authResponse);
        this.createGCPHappyPathWireMockStubs(authResponse);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        this.wireMockServer.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authResponse))).willReturn(this.firstSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs("Started").willSetStateTo(STATUS_POLLING_PASSED_FIRST_CALL));
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        UploadCommand command = this.buildUploadCommand(auraURLFactory);
        String[] args = this.getNormalRuntimeArgs();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> new CommandLine((Object)command).execute(args));
        UploadCommandTest.verifyCommonConsoleUrls();
        UploadCommandTest.verifyGCPPresignedEndpoints();
    }

    private String[] getNormalRuntimeArgs() {
        String[] args = new String[]{DBNAME, "--from-path", this.dumpDir.toAbsolutePath().toString(), "--to-uri", SOME_EXAMPLE_BOLT_URI, "--to-password", "password"};
        return args;
    }

    private UploadCommand buildUploadCommand(AuraURLFactory auraURLFactory) {
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)"username", (String)"password", (boolean)false));
        return command;
    }

    private static void verifyGCPPresignedEndpoints() {
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)INITATE_PRESIGNED_UPLOAD_LOCATION)));
        WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)UPLOAD_PRESIGNED_LOCATION)));
    }

    private static void verifyCommonConsoleUrls() {
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/size$")));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import$")));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/upload-complete$")));
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")));
    }

    @Test
    public void happyPathAWSUploadCommandTest() {
        String authResponse = "token";
        this.createAuraHappyPathStubs(authResponse);
        this.wireMockServer.stubFor(this.initiateUploadTargetRequest(authResponse).willReturn(this.successfulInitiateUploadTargetAWSResponse()));
        this.wireMockServer.stubFor(this.uploadRequest().willReturn(WireMock.aResponse().withStatus(200)));
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        this.wireMockServer.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authResponse))).willReturn(this.firstSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs("Started").willSetStateTo(STATUS_POLLING_PASSED_FIRST_CALL));
        this.wireMockServer.stubFor(this.getMultiPartStatusRequest().willReturn(this.successfulMultiPartStatusResponse()));
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeAWSUploadURLFactory(), PushToCloudCLI.fakeCLI((String)"username", (String)"password", (boolean)false));
        String[] args = this.getNormalRuntimeArgs();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> new CommandLine((Object)command).execute(args));
        UploadCommandTest.verifyCommonConsoleUrls();
        WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/signed1")));
        WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/signed2")));
        WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/signed3")));
    }

    @Test
    public void shouldHandleUploadStartTimeoutFailure() {
        String authResponse = "token";
        this.createAuraHappyPathStubs(authResponse);
        this.createGCPHappyPathWireMockStubs(authResponse);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        this.wireMockServer.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authResponse))).willReturn(this.secondSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs("Started").willSetStateTo(STATUS_POLLING_PASSED_FIRST_CALL));
        this.wireMockServer.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authResponse))).willReturn(this.secondSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs(STATUS_POLLING_PASSED_FIRST_CALL).willSetStateTo(STATUS_POLLING_PASSED_FIRST_CALL));
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        SystemNanoClock clockMock = (SystemNanoClock)Mockito.mock(SystemNanoClock.class);
        auraClientBuilder.withClock((Clock)clockMock);
        Mockito.when((Object)clockMock.millis()).thenReturn((Object)0L).thenReturn((Object)120000L);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)"username", (String)"password", (boolean)false));
        String[] args = this.getNormalRuntimeArgs();
        CommandLine.populateCommand((Object)command, (String[])args);
        CommandFailedException exception = (CommandFailedException)org.junit.jupiter.api.Assertions.assertThrows(CommandFailedException.class, () -> command.execute());
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Timed out waiting for database load to start"});
        UploadCommandTest.verifyCommonConsoleUrls();
        UploadCommandTest.verifyGCPPresignedEndpoints();
    }

    @Test
    void shouldHandleConflictOnTriggerImportAfterUpload() {
        String authResponse = "token";
        this.createAuraHappyPathStubs(authResponse);
        this.createGCPHappyPathWireMockStubs(authResponse);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        this.wireMockServer.stubFor(this.triggerImportRequest(authResponse).willReturn(WireMock.aResponse().withStatus(409)));
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        UploadCommand command = this.buildUploadCommand(auraURLFactory);
        String[] args = this.getNormalRuntimeArgs();
        CommandLine.populateCommand((Object)command, (String[])args);
        CommandFailedException exception = (CommandFailedException)org.junit.jupiter.api.Assertions.assertThrows(CommandFailedException.class, () -> command.execute());
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"The target database contained data and consent to overwrite the data was not given. Aborting"});
    }

    @Test
    public void shouldHandleFailedImport() throws JsonProcessingException {
        String authResponse = "token";
        this.createAuraHappyPathStubs(authResponse);
        this.createGCPHappyPathWireMockStubs(authResponse);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        UploadCommand command = this.buildUploadCommand(auraURLFactory);
        AuraJsonMapper.StatusBody statusBody = new AuraJsonMapper.StatusBody();
        statusBody.Status = "loading failed";
        String errorMessage = "The uploaded dump file contains deprecated indexes, which we are unable to import in the current version of Neo4j Aura. Please upgrade to the recommended index provider.";
        String errorUrl = "https://aura.support.neo4j.com/";
        statusBody.Error = new AuraJsonMapper.ErrorBody(errorMessage, ERROR_REASON_UNSUPPORTED_INDEXES, errorUrl);
        ObjectMapper mapper = new ObjectMapper();
        this.wireMockServer.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authResponse))).willReturn(WireMock.aResponse().withBody(mapper.writeValueAsString((Object)statusBody)).withHeader("Content-Type", new String[]{"application/json"}).withStatus(200)).inScenario("test").whenScenarioStateIs(STATUS_POLLING_PASSED_FIRST_CALL));
        String[] args = this.getNormalRuntimeArgs();
        CommandLine.populateCommand((Object)command, (String[])args);
        CommandFailedException exception = (CommandFailedException)org.junit.jupiter.api.Assertions.assertThrows(CommandFailedException.class, () -> command.execute());
        String message = exception.getMessage();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)message.contains(errorMessage));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)message.contains(ERROR_REASON_UNSUPPORTED_INDEXES));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)message.contains(".."));
        UploadCommandTest.verifyCommonConsoleUrls();
        UploadCommandTest.verifyGCPPresignedEndpoints();
    }

    @Test
    void shouldHandleFailedImportStatusFromPreviousLoad() throws IOException, CommandFailedException {
        String authResponse = "token";
        this.createAuraHappyPathStubs(authResponse);
        this.createGCPHappyPathWireMockStubs(authResponse);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        UploadCommand command = this.buildUploadCommand(auraURLFactory);
        AuraJsonMapper.StatusBody statusBody = new AuraJsonMapper.StatusBody();
        statusBody.Status = "loading failed";
        String errorMessage = "The uploaded dump file contains deprecated indexes, which we are unable to import in the current version of Neo4j Aura. Please upgrade to the recommended index provider.";
        String errorUrl = "https://support.neo4j.com";
        statusBody.Error = new AuraJsonMapper.ErrorBody(errorMessage, ERROR_REASON_UNSUPPORTED_INDEXES, errorUrl);
        ObjectMapper mapper = new ObjectMapper();
        this.wireMockServer.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authResponse))).willReturn(WireMock.aResponse().withBody(mapper.writeValueAsString((Object)statusBody)).withHeader("Content-Type", new String[]{"application/json"}).withStatus(200)).inScenario("test").whenScenarioStateIs("Started").willSetStateTo(STATUS_POLLING_PASSED_FIRST_CALL));
        this.wireMockServer.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authResponse))).willReturn(this.firstSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs(STATUS_POLLING_PASSED_FIRST_CALL).willSetStateTo(STATUS_POLLING_PASSED_SECOND_CALL));
        this.wireMockServer.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authResponse))).willReturn(this.secondSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs(STATUS_POLLING_PASSED_SECOND_CALL));
        String[] args = this.getNormalRuntimeArgs();
        int exitCode = new CommandLine((Object)command).execute(args);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)exitCode);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import$")).withRequestBody((ContentPattern)WireMock.matchingJsonPath((String)"$.FullSize", (StringValuePattern)WireMock.equalTo((String)String.valueOf(this.dbFullSize)))));
        UploadCommandTest.verifyGCPPresignedEndpoints();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/upload-complete$")));
    }

    public void createAuraHappyPathStubs(String authResponse) {
        this.wireMockServer.stubFor(this.authenticationRequest().willReturn(this.successfulAuthorizationResponse("token")));
        this.wireMockServer.stubFor(this.sizeCheckTargetRequest("token").willReturn(this.successfulSizeCheckTargetResponse()));
        this.wireMockServer.stubFor(this.triggerImportRequest(authResponse).willReturn(this.successfulTriggerImportResponse()));
        this.wireMockServer.stubFor(this.firstStatusPollingRequest(authResponse));
        this.wireMockServer.stubFor(this.secondStatusPollingRequest(authResponse));
    }

    private void createGCPHappyPathWireMockStubs(String authResponse) {
        this.wireMockServer.stubFor(this.initiateUploadTargetRequest(authResponse).willReturn(this.successfulInitiateUploadTargetResponse(INITATE_PRESIGNED_UPLOAD_LOCATION)));
        this.wireMockServer.stubFor(this.initatePreSignedUpload().willReturn(this.successfulInitatePresignedResponse()));
        this.wireMockServer.stubFor(this.uploadToPreSignedUrl().willReturn(this.successfulUploadPresignedResponse()));
    }

    @Test
    public void shouldReadUsernameAndPasswordFromUserInput() {
        String username = DBNAME;
        String password = "abc";
        this.createGCPHappyPathWireMockStubs("token");
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)username, (String)password, (boolean)false));
        String[] args = new String[]{DBNAME, "--from-path", this.dumpDir.toString(), "--to-uri", SOME_EXAMPLE_BOLT_URI};
        new CommandLine((Object)command).execute(args);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withBasicAuth(new BasicCredentials(username, password)));
    }

    @Test
    public void shouldUseNeo4jAsDefaultUsernameIfUserHitsEnter() {
        this.createGCPHappyPathWireMockStubs("token");
        PushToCloudCLI pushToCloudCLI = (PushToCloudCLI)Mockito.mock(PushToCloudCLI.class);
        Mockito.when((Object)pushToCloudCLI.readLine(ArgumentMatchers.anyString(), new Object[]{ArgumentMatchers.anyString()})).thenReturn((Object)"");
        String defaultUsername = DBNAME;
        String password = "super-secret-password";
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), pushToCloudCLI);
        String[] args = new String[]{DBNAME, "--from-path", this.dumpDir.toString(), "--to-uri", SOME_EXAMPLE_BOLT_URI, "--to-password", password};
        new CommandLine((Object)command).execute(args);
        ((PushToCloudCLI)Mockito.verify((Object)pushToCloudCLI)).readLine("%s", new Object[]{String.format("Neo4j aura username (default: %s):", defaultUsername)});
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withBasicAuth(new BasicCredentials(DBNAME, password)));
    }

    @Test
    public void shouldAcceptPasswordViaArgAndPromptForUsername() throws CommandFailedException {
        String username = "neo4juserviacli";
        this.createGCPHappyPathWireMockStubs("token");
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)username, (String)"tomte", (boolean)false));
        String[] args = new String[]{DBNAME, "--from-path", this.dumpDir.toString(), "--to-password", "pass", "--to-uri", SOME_EXAMPLE_BOLT_URI};
        new CommandLine((Object)command).execute(args);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withBasicAuth(new BasicCredentials(username, "pass")));
    }

    @Test
    public void shouldAcceptPasswordViaEnvAndPromptForUsername() {
        String username = "neo4juserviacli";
        this.createGCPHappyPathWireMockStubs("token");
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        String[] args = new String[]{DBNAME, "--from-path", this.dumpDir.toString(), "--to-uri", SOME_EXAMPLE_BOLT_URI};
        Map<String, String> environment = Map.of("NEO4J_USERNAME", "", "NEO4J_PASSWORD", "pass");
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)username, (String)"tomte", (boolean)false));
        new CommandLine((Object)command).setResourceBundle((ResourceBundle)new MapResourceBundle(environment)).execute(args);
        this.wireMockServer.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withBasicAuth(new BasicCredentials(username, "pass")));
    }

    @Test
    public void shouldAcceptUsernameViaArgAndPromptForPassword() throws CommandFailedException {
        String username = DBNAME;
        String password = "abc";
        this.createGCPHappyPathWireMockStubs("token");
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)username, (String)password, (boolean)false));
        String[] args = new String[]{DBNAME, "--from-path", this.dumpDir.toString(), "--to-user", "user", "--to-uri", SOME_EXAMPLE_BOLT_URI};
        new CommandLine((Object)command).execute(args);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(this.dump, new LinkOption[0]));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withBasicAuth(new BasicCredentials("user", password)));
    }

    @Test
    public void shouldAcceptUsernameViaEnvAndPromptForPassword() {
        String username = "neo4jcliuser";
        String password = "abc";
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        this.createGCPHappyPathWireMockStubs("token");
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)username, (String)password, (boolean)false));
        String[] args = new String[]{DBNAME, "--from-path", this.dumpDir.toString(), "--to-uri", SOME_EXAMPLE_BOLT_URI};
        Map<String, String> environment = Map.of("NEO4J_USERNAME", "user", "NEO4J_PASSWORD", "");
        new CommandLine((Object)command).setResourceBundle((ResourceBundle)new MapResourceBundle(environment)).execute(args);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Files.exists(this.dump, new LinkOption[0]));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withBasicAuth(new BasicCredentials("user", password)));
    }

    @Test
    public void shouldAcceptOnlyUsernameAndPasswordFromCli() throws CommandFailedException {
        String username = "neo4jcliuser";
        String password = "abc";
        this.createGCPHappyPathWireMockStubs("token");
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)username, (String)password, (boolean)false));
        String[] args = new String[]{DBNAME, "--from-path", this.dumpDir.toString(), "--to-user", "neo4jarg", "--to-password", "passcli", "--to-uri", SOME_EXAMPLE_BOLT_URI};
        new CommandLine((Object)command).execute(args);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withBasicAuth(new BasicCredentials("neo4jarg", "passcli")));
    }

    @Test
    public void shouldAcceptOnlyUsernameAndPasswordFromEnv() {
        String username = "neo4jcliuser";
        String password = "abc";
        this.createGCPHappyPathWireMockStubs("token");
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)username, (String)password, (boolean)false));
        String[] args = new String[]{DBNAME, "--from-path", this.dumpDir.toString(), "--to-uri", SOME_EXAMPLE_BOLT_URI};
        Map<String, String> environment = Map.of("NEO4J_USERNAME", "neo4jenv", "NEO4J_PASSWORD", "passenv");
        new CommandLine((Object)command).setResourceBundle((ResourceBundle)new MapResourceBundle(environment)).execute(args);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withBasicAuth(new BasicCredentials("neo4jenv", "passenv")));
    }

    @Test
    public void shouldFailOnDumpPointingToMissingFile() throws CommandFailedException {
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        String[] args = new String[]{"otherdbname", "--from-path", this.dumpDir.toString(), "--to-uri", SOME_EXAMPLE_BOLT_URI};
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)DBNAME, (String)"abc", (boolean)false));
        CommandLine.populateCommand((Object)command, (String[])args);
        AbstractThrowableAssert assertFailure = (AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((UploadCommand)command).execute()).isInstanceOf(CommandFailedException.class);
        assertFailure.hasMessageContaining("Could not find any archive files");
    }

    @Test
    public void shouldFailOnWrongDumpPath() throws CommandFailedException {
        AuraURLFactory auraURLFactory = (AuraURLFactory)Mockito.mock(AuraURLFactory.class);
        AuraConsole testConsole = new AuraConsole(MOCK_BASE_URL, "sausage");
        Mockito.when((Object)auraURLFactory.buildConsoleURI((String)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)testConsole);
        AuraClient.AuraClientBuilder auraClientBuilder = new AuraClient.AuraClientBuilder(this.ctx);
        String[] args = new String[]{DBNAME, "--from-path", this.dump.toAbsolutePath().toString(), "--to-uri", SOME_EXAMPLE_BOLT_URI};
        UploadCommand command = new UploadCommand(this.ctx, auraClientBuilder, auraURLFactory, (UploadURLFactory)new FakeGCPUploadURLFactory(), PushToCloudCLI.fakeCLI((String)DBNAME, (String)"abc", (boolean)false));
        CommandLine.populateCommand((Object)command, (String[])args);
        AbstractThrowableAssert assertFailure = (AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((UploadCommand)command).execute()).isInstanceOf(CommandFailedException.class);
        assertFailure.hasMessageContaining("The provided source directory");
    }

    private ResponseDefinitionBuilder successfulAuthorizationResponse(String authorizationTokenResponse) {
        return WireMock.aResponse().withStatus(200).withBody(String.format("{\"Token\":\"%s\"}", authorizationTokenResponse));
    }

    private MappingBuilder authenticationRequest() {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import/auth$")).withHeader("Authorization", WireMock.matching((String)"^Basic .*")).withHeader("Accept", WireMock.equalTo((String)"application/json")).withHeader("Confirmed", WireMock.equalTo((String)"false"));
    }

    private MappingBuilder sizeCheckTargetRequest(String authorizationTokenResponse) {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import/size$")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).withRequestBody((ContentPattern)WireMock.equalToJson((String)("{\"FullSize\": " + this.dbFullSize + "}")));
    }

    private ResponseDefinitionBuilder successfulSizeCheckTargetResponse() {
        return WireMock.aResponse().withStatus(200);
    }

    private MappingBuilder initiateUploadTargetRequest(String authorizationTokenResponse) {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import$")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).withHeader("Accept", WireMock.equalTo((String)"application/json")).withHeader("Neo4j-Version", WireMock.matching((String)".*"));
    }

    private MappingBuilder initatePreSignedUpload() {
        return WireMock.post((UrlPattern)WireMock.urlEqualTo((String)INITATE_PRESIGNED_UPLOAD_LOCATION)).withHeader("Content-Length", WireMock.equalTo((String)"0")).withHeader("x-goog-resumable", WireMock.equalTo((String)"start")).withHeader("Content-Type", WireMock.equalTo((String)""));
    }

    private MappingBuilder uploadToPreSignedUrl() {
        return WireMock.put((UrlPattern)WireMock.urlEqualTo((String)UPLOAD_PRESIGNED_LOCATION));
    }

    private ResponseDefinitionBuilder successfulInitiateUploadTargetResponse(String signedURIPath) {
        return WireMock.aResponse().withStatus(202).withBody(String.format("{\"SignedURI\":\"%s\", \"expiration_date\":\"Fri, 04 Oct 2019 08:21:59 GMT\", \"Provider\": \"GCP\"}", MOCK_BASE_URL + signedURIPath));
    }

    private ResponseDefinitionBuilder successfulInitiateUploadTargetAWSResponse() {
        String json;
        AuraJsonMapper.SignedURIBodyResponse signedURIBodyResponse = new AuraJsonMapper.SignedURIBodyResponse();
        signedURIBodyResponse.SignedLinks = signedLinks;
        signedURIBodyResponse.UploadID = "uploadID";
        signedURIBodyResponse.Provider = "AWS";
        signedURIBodyResponse.TotalParts = 3;
        try {
            json = new ObjectMapper().writeValueAsString((Object)signedURIBodyResponse);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return WireMock.aResponse().withStatus(202).withBody(json);
    }

    private MappingBuilder getMultiPartStatusRequest() {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import/multipart-upload-status"));
    }

    private ResponseDefinitionBuilder successfulMultiPartStatusResponse() {
        String json;
        ArrayList<AuraJsonMapper.PartEtag> etags = new ArrayList<AuraJsonMapper.PartEtag>();
        etags.add(this.getEtagFor(1));
        etags.add(this.getEtagFor(2));
        etags.add(this.getEtagFor(3));
        AuraJsonMapper.UploadStatusResponse uploadStatusBodyResponse = new AuraJsonMapper.UploadStatusResponse();
        uploadStatusBodyResponse.UploadID = "uploadID";
        uploadStatusBodyResponse.Provider = "AWS";
        uploadStatusBodyResponse.Parts = etags;
        try {
            json = new ObjectMapper().writeValueAsString((Object)uploadStatusBodyResponse);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return WireMock.aResponse().withStatus(202).withBody(json);
    }

    private AuraJsonMapper.PartEtag getEtagFor(int partNumber) {
        AuraJsonMapper.PartEtag etag = new AuraJsonMapper.PartEtag();
        etag.PartNumber = partNumber;
        etag.ETag = String.format("etag%d", partNumber);
        return etag;
    }

    private MappingBuilder triggerImportRequest(String authorizationTokenResponse) {
        return WireMock.post((UrlPattern)WireMock.urlMatching((String)".*?/import/upload-complete$")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).withRequestBody((ContentPattern)WireMock.containing((String)"Crc32"));
    }

    private ResponseDefinitionBuilder successfulTriggerImportResponse() {
        return WireMock.aResponse().withStatus(200);
    }

    private MappingBuilder firstStatusPollingRequest(String authorizationTokenResponse) {
        return WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).willReturn(this.firstSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs("Started").willSetStateTo(STATUS_POLLING_PASSED_FIRST_CALL);
    }

    private MappingBuilder secondStatusPollingRequest(String authorizationTokenResponse) {
        return WireMock.get((UrlPattern)WireMock.urlMatching((String)".*?/import/status$")).withHeader("Authorization", WireMock.equalTo((String)("Bearer " + authorizationTokenResponse))).willReturn(this.secondSuccessfulDatabaseRunningResponse()).inScenario("test").whenScenarioStateIs(STATUS_POLLING_PASSED_FIRST_CALL);
    }

    private ResponseDefinitionBuilder firstSuccessfulDatabaseRunningResponse() {
        return WireMock.aResponse().withBody("{\"Status\":\"loading\"}").withStatus(200);
    }

    private ResponseDefinitionBuilder secondSuccessfulDatabaseRunningResponse() {
        return WireMock.aResponse().withBody("{\"Status\":\"running\"}").withStatus(200);
    }

    private ResponseDefinitionBuilder successfulInitatePresignedResponse() {
        return WireMock.aResponse().withStatus(201).withHeader("Location", new String[]{"http://localhost:8080/upload-presigned"});
    }

    private ResponseDefinitionBuilder successfulUploadPresignedResponse() {
        return WireMock.aResponse().withStatus(200);
    }

    private MappingBuilder uploadRequest() {
        return WireMock.put((UrlPattern)WireMock.urlMatching((String)"/signed([0-9]*)"));
    }

    private static class FakeGCPUploadURLFactory
    implements UploadURLFactory {
        private final String signedURIPath = "http://localhost:8080/initiate-presigned";

        private FakeGCPUploadURLFactory() {
        }

        public SignedUpload fromAuraResponse(AuraJsonMapper.SignedURIBodyResponse signedURIBodyResponse, ExecutionContext ctx, String boltURI) {
            return new SignedUploadGCP(null, "http://localhost:8080/initiate-presigned", ctx, "bolt://uri", (name, length) -> new ExportTestUtilities.ControlledProgressListener(), millis -> {}, new CommandResponseHandler(ctx));
        }
    }

    private static class FakeAWSUploadURLFactory
    implements UploadURLFactory {
        private FakeAWSUploadURLFactory() {
        }

        public SignedUpload fromAuraResponse(AuraJsonMapper.SignedURIBodyResponse signedURIBodyResponse, ExecutionContext ctx, String boltURI) {
            return new SignedUploadAWS(signedLinks, "MyUploadID", 3, ctx, "bolt-uri", millis -> {});
        }
    }

    private static class MapResourceBundle
    extends ResourceBundle {
        private final Map<String, String> entries;

        MapResourceBundle(Map<String, String> entries) {
            Objects.requireNonNull(entries);
            this.entries = entries;
        }

        @Override
        protected Object handleGetObject(String key) {
            Objects.requireNonNull(key);
            return this.entries.get(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.entries.keySet());
        }
    }
}

