/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.providers;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.UploadCommand;
import org.neo4j.export.providers.SignedUploadAWS;
import org.neo4j.export.util.ExportTestUtilities;
import org.neo4j.export.util.IOCommon;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.utils.TestDirectory;
import wiremock.org.hamcrest.CoreMatchers;
import wiremock.org.hamcrest.Matcher;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={TestDirectorySupportExtension.class})
@Neo4jLayoutExtension
public class SignedUploadAWSTest {
    private int wiremockServerPort;
    private String wireMockServerAddress;
    private static final String DBNAME = "neo4j";
    @Inject
    TestDirectory directory;
    private WireMockServer wireMockServer;
    private Path dump;
    private long storeSize;
    private ExecutionContext ctx;
    private long dumpFileSize;
    private String[] signedLinks;
    @Inject
    private Neo4jLayout neo4jLayout;

    @BeforeAll
    public void setup() {
        Path homeDir = this.directory.homePath();
        Path confPath = this.directory.directory("conf");
        Path dumpDir = this.directory.directory("dumps");
        this.dump = dumpDir.resolve("neo4j.dump");
        ExportTestUtilities.prepareDatabase(this.neo4jLayout.databaseLayout(DBNAME));
        PrintStream nullOutputStream = new PrintStream(NullOutputStream.nullOutputStream());
        this.ctx = new ExecutionContext(homeDir, confPath, nullOutputStream, nullOutputStream, this.directory.getFileSystem());
        ExportTestUtilities.createDump(homeDir, confPath, dumpDir, this.ctx.fs(), DBNAME);
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)new ConsoleNotifier(false)));
    }

    @BeforeEach
    public void setupEach() throws IOException {
        this.wireMockServer.start();
        this.storeSize = UploadCommand.readSizeFromArchiveMetaData((ExecutionContext)this.ctx, (Path)this.dump);
        this.dumpFileSize = this.ctx.fs().getFileSize(this.dump);
        this.wiremockServerPort = this.wireMockServer.port();
        this.wireMockServerAddress = "http://localhost:" + this.wiremockServerPort;
        this.signedLinks = new String[]{String.format("%s/signed1", this.wireMockServerAddress), String.format("%s/signed2", this.wireMockServerAddress), String.format("%s/signed3", this.wireMockServerAddress)};
        WireMock.configureFor((String)"localhost", (int)this.wiremockServerPort);
    }

    @AfterEach
    public void tearDownEach() {
        this.wireMockServer.resetAll();
        this.wireMockServer.stop();
    }

    @Test
    public void testAWSUploadHappyPathMultiPart() throws IOException {
        SignedUploadAWS signedUploadAWS = new SignedUploadAWS(this.signedLinks, "uploadID", this.signedLinks.length, this.ctx, "bolt://localhost");
        long chunkSize = signedUploadAWS.getChunkSize(this.dumpFileSize);
        UploadCommand.Source source = new UploadCommand.Source(this.ctx.fs(), this.dump, this.storeSize);
        byte[][] chunks = new byte[this.signedLinks.length][];
        this.setUpRequestChunks(chunkSize, chunks);
        this.wireMockServer.stubFor(this.uploadRequest().willReturn(this.successfulInitiateResponse()));
        signedUploadAWS.copy(false, source);
        this.verifyChunks(chunks);
    }

    @Test
    public void testAWSUploadWithRetryReUploadsCorrectChunk() throws IOException {
        SignedUploadAWS signedUploadAWS = new SignedUploadAWS(this.signedLinks, "uploadID", this.signedLinks.length, this.ctx, "bolt://localhost", millis -> {});
        long chunkSize = signedUploadAWS.getChunkSize(this.dumpFileSize);
        UploadCommand.Source source = new UploadCommand.Source(this.ctx.fs(), this.dump, this.storeSize);
        byte[][] chunks = new byte[this.signedLinks.length][];
        this.setUpRequestChunks(chunkSize, chunks);
        this.wireMockServer.stubFor((MappingBuilder)this.uploadRequest().inScenario("Failed Upload").whenScenarioStateIs("Started").willReturn(this.failedInitiateResponse()).willSetStateTo("Retry Upload"));
        this.wireMockServer.stubFor((MappingBuilder)this.uploadRequest().inScenario("Failed Upload").whenScenarioStateIs("Retry Upload").willReturn(this.successfulInitiateResponse()));
        signedUploadAWS.copy(false, source);
        this.wireMockServer.verify(WireMock.exactly((int)2), WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/signed1")).withRequestBody((ContentPattern)WireMock.binaryEqualTo((byte[])chunks[0])));
    }

    @Test
    public void testAWSUploadWithRetryReUploadsCorrectChunkInMiddle() throws IOException {
        SignedUploadAWS signedUploadAWS = new SignedUploadAWS(this.signedLinks, "uploadID", this.signedLinks.length, this.ctx, "bolt://localhost", millis -> {});
        long chunkSize = signedUploadAWS.getChunkSize(this.dumpFileSize);
        UploadCommand.Source source = new UploadCommand.Source(this.ctx.fs(), this.dump, this.storeSize);
        byte[][] chunks = new byte[this.signedLinks.length][];
        this.setUpRequestChunks(chunkSize, chunks);
        this.wireMockServer.stubFor(this.uploadRequest().willReturn(this.successfulInitiateResponse()));
        this.wireMockServer.stubFor((MappingBuilder)this.uploadRequest2().inScenario("Failed Upload").whenScenarioStateIs("Started").willReturn(this.failedInitiateResponse()).willSetStateTo("Retry Upload"));
        this.wireMockServer.stubFor((MappingBuilder)this.uploadRequest2().inScenario("Failed Upload").whenScenarioStateIs("Retry Upload").willReturn(this.successfulInitiateResponse()));
        signedUploadAWS.copy(false, source);
        this.wireMockServer.verify(WireMock.exactly((int)2), WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/signed2")).withRequestBody((ContentPattern)WireMock.binaryEqualTo((byte[])chunks[1])));
        this.wireMockServer.verify(WireMock.exactly((int)1), WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/signed1")).withRequestBody((ContentPattern)WireMock.binaryEqualTo((byte[])chunks[0])));
        this.wireMockServer.verify(WireMock.exactly((int)1), WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/signed3")).withRequestBody((ContentPattern)WireMock.binaryEqualTo((byte[])chunks[2])));
    }

    @Test
    public void testCorrectlyErrorsAfterFiveAttempts() throws IOException {
        SignedUploadAWS signedUploadAWS = new SignedUploadAWS(this.signedLinks, "uploadID", this.signedLinks.length, this.ctx, "bolt://localhost", millis -> {});
        UploadCommand.Source source = new UploadCommand.Source(this.ctx.fs(), this.dump, this.storeSize);
        byte[][] chunks = new byte[this.signedLinks.length][];
        long chunkSize = signedUploadAWS.getChunkSize(this.dumpFileSize);
        this.setUpRequestChunks(chunkSize, chunks);
        this.wireMockServer.stubFor(this.uploadRequest().willReturn(this.failedInitiateResponse()));
        ExportTestUtilities.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"Failed to upload part to multipart url after 5 retries. Please check your Internet connection and try again."), () -> signedUploadAWS.copy(false, source));
        this.wireMockServer.verify(WireMock.exactly((int)5), WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/signed1")).withRequestBody((ContentPattern)WireMock.binaryEqualTo((byte[])chunks[0])));
    }

    private void setUpRequestChunks(long chunkSize, byte[][] chunks) throws IOException {
        for (int i = 0; i < this.signedLinks.length - 1; ++i) {
            chunks[i] = this.getNBytesFromFile((int)chunkSize, (long)i * chunkSize);
        }
        chunks[this.signedLinks.length - 1] = this.getLastBytesFromFile((long)(this.signedLinks.length - 1) * chunkSize);
    }

    private void verifyChunks(byte[][] chunks) {
        for (int i = 0; i < this.signedLinks.length; ++i) {
            this.wireMockServer.verify(WireMock.exactly((int)1), WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)("/signed" + (i + 1)))).withRequestBody((ContentPattern)WireMock.binaryEqualTo((byte[])chunks[i])));
        }
    }

    private byte[] getNBytesFromFile(int n, long position) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.dump.toFile()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOCommon.safeSkip((InputStream)is, (long)position);
        IOUtils.copyRange((InputStream)is, (long)n, (OutputStream)baos);
        is.close();
        return baos.toByteArray();
    }

    private byte[] getLastBytesFromFile(long position) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.dump.toFile()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOCommon.safeSkip((InputStream)is, (long)position);
        IOUtils.copy((InputStream)is, (OutputStream)baos);
        is.close();
        return baos.toByteArray();
    }

    private MappingBuilder uploadRequest() {
        return WireMock.put((UrlPattern)WireMock.urlMatching((String)"/signed([0-9]*)"));
    }

    private MappingBuilder uploadRequest2() {
        return WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/signed2"));
    }

    private ResponseDefinitionBuilder successfulInitiateResponse() {
        return WireMock.aResponse().withStatus(200);
    }

    private ResponseDefinitionBuilder failedInitiateResponse() {
        return WireMock.aResponse().withStatus(502);
    }
}

