/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.providers;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.file.Path;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.CommandResponseHandler;
import org.neo4j.export.UploadCommand;
import org.neo4j.export.providers.SignedUploadGCP;
import org.neo4j.export.util.ExportTestUtilities;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.testdirectory.TestDirectorySupportExtension;
import org.neo4j.test.utils.TestDirectory;
import wiremock.org.hamcrest.CoreMatchers;
import wiremock.org.hamcrest.Matcher;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={TestDirectorySupportExtension.class})
@Neo4jLayoutExtension
public class SignedUploadGCPTest {
    private int wiremockServerPort;
    private String wireMockServerAddress;
    private String wiremockInitiateUrl;
    private String wiremockUploadUrl;
    private static final String DBNAME = "neo4j";
    private static final int HTTP_TOO_MANY_REQUESTS = 429;
    @Inject
    TestDirectory directory;
    private WireMockServer wireMockServer;
    private Path dump;
    private long storeSize;
    private ExecutionContext ctx;
    private long dumpFileSize;
    @Inject
    private Neo4jLayout neo4jLayout;

    @BeforeAll
    public void setup() {
        Path homeDir = this.directory.homePath();
        Path confPath = this.directory.directory("conf");
        Path dumpDir = this.directory.directory("dumps");
        this.dump = dumpDir.resolve("neo4j.dump");
        ExportTestUtilities.prepareDatabase(this.neo4jLayout.databaseLayout(DBNAME));
        PrintStream nullOutputStream = new PrintStream(NullOutputStream.nullOutputStream());
        this.ctx = new ExecutionContext(homeDir, confPath, nullOutputStream, nullOutputStream, this.directory.getFileSystem());
        ExportTestUtilities.createDump(homeDir, confPath, dumpDir, this.ctx.fs(), DBNAME);
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort().notifier((Notifier)new ConsoleNotifier(false)));
    }

    @BeforeEach
    public void setupEach() throws IOException {
        this.wireMockServer.start();
        this.storeSize = UploadCommand.readSizeFromArchiveMetaData((ExecutionContext)this.ctx, (Path)this.dump);
        this.dumpFileSize = this.ctx.fs().getFileSize(this.dump);
        this.wiremockServerPort = this.wireMockServer.port();
        this.wireMockServerAddress = "http://localhost:" + this.wiremockServerPort;
        this.wiremockInitiateUrl = this.wireMockServerAddress + "/initiate";
        this.wiremockUploadUrl = this.wireMockServerAddress + "/upload";
        WireMock.configureFor((String)"localhost", (int)this.wiremockServerPort);
    }

    @AfterEach
    public void tearDownEach() {
        this.wireMockServer.stop();
    }

    @Test
    public void testGCPUploadHappyPath() {
        ControlledProgressListener progressListener = new ControlledProgressListener();
        SignedUploadGCP.ProgressListenerFactory progressListenerFactory = (name, length) -> progressListener;
        this.wireMockServer.stubFor(this.initiateRequest().willReturn(this.successfulInitiateResponse("/upload")));
        this.wireMockServer.stubFor(this.resumeUpload().willReturn(WireMock.aResponse().withStatus(200)));
        SignedUploadGCP gcpSignedUpload = this.getGcpSignedUpload(progressListenerFactory);
        UploadCommand.Source source = new UploadCommand.Source(this.ctx.fs(), this.dump, this.storeSize);
        gcpSignedUpload.copy(true, source);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/initiate")));
        WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/upload")));
        Assertions.assertTrue((boolean)progressListener.closeCalled);
        Assertions.assertEquals((long)this.dumpFileSize, (long)progressListener.progress);
    }

    @Test
    public void shouldHandleResumableFailureWhileUploading() {
        ControlledProgressListener progressListener = new ControlledProgressListener();
        SignedUploadGCP.ProgressListenerFactory progressListenerFactory = (name, length) -> progressListener;
        this.wireMockServer.stubFor(this.initiateRequest().willReturn(this.successfulInitiateResponse("/upload")));
        this.wireMockServer.stubFor(this.resumeUpload().willReturn(WireMock.aResponse().withStatus(429)));
        SignedUploadGCP gcpSignedUpload = this.getGcpSignedUpload(progressListenerFactory);
        UploadCommand.Source source = new UploadCommand.Source(this.ctx.fs(), this.dump, this.storeSize);
        ExportTestUtilities.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"You can re-try using the existing dump by running this command"), () -> gcpSignedUpload.copy(true, source));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/initiate")));
        WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/upload")));
    }

    @Test
    public void shouldHandleServerErrorWhileUploading() {
        ControlledProgressListener progressListener = new ControlledProgressListener();
        SignedUploadGCP.ProgressListenerFactory progressListenerFactory = (name, length) -> progressListener;
        this.wireMockServer.stubFor(this.initiateRequest().willReturn(this.successfulInitiateResponse("/upload")));
        this.wireMockServer.stubFor((MappingBuilder)this.resumeUpload().willReturn(WireMock.aResponse().withStatus(500)).inScenario("test").whenScenarioStateIs("Started").willSetStateTo("keepResuming"));
        this.wireMockServer.stubFor((MappingBuilder)this.keepResuming().willReturn(WireMock.aResponse().withStatus(500)).inScenario("test").whenScenarioStateIs("keepResuming"));
        SignedUploadGCP gcpSignedUpload = this.getGcpSignedUpload(progressListenerFactory);
        UploadCommand.Source source = new UploadCommand.Source(this.ctx.fs(), this.dump, this.storeSize);
        ExportTestUtilities.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"Unexpected response code"), () -> gcpSignedUpload.copy(true, source));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/initiate")));
        WireMock.verify((RequestPatternBuilder)WireMock.putRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/upload")));
    }

    @Test
    public void shouldHandleInitiateUploadFailure() {
        ControlledProgressListener progressListener = new ControlledProgressListener();
        SignedUploadGCP.ProgressListenerFactory progressListenerFactory = (name, length) -> progressListener;
        this.wireMockServer.stubFor(this.initiateRequest().willReturn(WireMock.aResponse().withStatus(500)));
        SignedUploadGCP gcpSignedUpload = this.getGcpSignedUpload(progressListenerFactory);
        UploadCommand.Source source = new UploadCommand.Source(this.ctx.fs(), this.dump, this.storeSize);
        ExportTestUtilities.assertThrows(CommandFailedException.class, (Matcher<String>)CoreMatchers.containsString((String)"Unexpected response"), () -> gcpSignedUpload.copy(true, source));
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/initiate")));
    }

    @Test
    public void shouldGetCorrectVersionedEndpoint() {
        SignedUploadGCP signedUploadGCP = new SignedUploadGCP(null, "https://my_signed_url", this.ctx, "bolt://uri", null, null, null);
        URL endpoint = signedUploadGCP.getCorrectVersionedEndpoint();
        Assertions.assertEquals((Object)"https://my_signed_url", (Object)endpoint.toString());
    }

    @Test
    public void shouldDefaultToList() {
        SignedUploadGCP signedUploadGCP = new SignedUploadGCP(new String[]{"https://my_list_signed_url"}, "https://my_signed_url", this.ctx, "bolt://uri", null, null, null);
        URL endpoint = signedUploadGCP.getCorrectVersionedEndpoint();
        Assertions.assertEquals((Object)"https://my_list_signed_url", (Object)endpoint.toString());
    }

    @Test
    void shouldReturnTrueWhenFileExists() throws IOException {
        SignedUploadGCP signedUploadGCP = this.getGcpSignedUpload(null);
        String error = "<?xml version='1.0' encoding='UTF-8'?><Error><Code>AccessDenied</Code><Message>Access denied.</Message><Details>hello@hello.iam.gserviceaccount.com does not have storage.objects.delete access to the Google Cloud Storage object.</Details></Error>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(error.getBytes());
        Assertions.assertTrue((boolean)signedUploadGCP.canSkipToImport((InputStream)byteArrayInputStream));
    }

    @Test
    void shouldProduceErrorWhenNotPermissionDenied() throws IOException {
        SignedUploadGCP signedUploadGCP = this.getGcpSignedUpload(null);
        String error = "<?xml version='1.0' encoding='UTF-8'?><Error><Code>AccessDenied</Code><Message>Access denied.</Message><Details>Unexpected stuff</Details></Error>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(error.getBytes());
        Assertions.assertFalse((boolean)signedUploadGCP.canSkipToImport((InputStream)byteArrayInputStream));
    }

    @Test
    void shouldThrowErrorParsingXEEVulnerableContent() throws IOException {
        SignedUploadGCP signedUploadGCP = this.getGcpSignedUpload(null);
        String error = "<?xml version='1.0' encoding='UTF-8'?><!DOCTYPE foo [ <!ENTITY xxe SYSTEM \"file:///etc/ntp.conf\"> ]><Error><Code>&xxe;</Code><Message>Access denied.</Message><Details>hello@hello.iam.gserviceaccount.com does not have storage.objects.delete access to the Google Cloud Storage object.</Details></Error>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(error.getBytes());
        ExportTestUtilities.assertThrows(IOException.class, (Matcher<String>)CoreMatchers.containsString((String)"Encountered invalid response from cloud import location"), () -> signedUploadGCP.canSkipToImport((InputStream)byteArrayInputStream));
    }

    private MappingBuilder initiateRequest() {
        return WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/initiate")).withHeader("x-goog-resumable", WireMock.equalTo((String)"start")).withHeader("Content-Type", WireMock.equalTo((String)"")).withHeader("Content-Length", WireMock.equalTo((String)"0"));
    }

    private MappingBuilder resumeRequest() {
        return WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/upload")).withHeader("Content-Length", WireMock.equalTo((String)"0")).withHeader("Content-Length", WireMock.containing((String)"bytes */"));
    }

    private ResponseDefinitionBuilder successfulInitiateResponse(String uploadPath) {
        return WireMock.aResponse().withStatus(201).withHeader("Location", new String[]{this.wireMockServerAddress + uploadPath});
    }

    private MappingBuilder resumeUpload() {
        return WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/upload")).withHeader("Content-Length", WireMock.equalTo((String)String.valueOf(this.dumpFileSize)));
    }

    private MappingBuilder keepResuming() {
        return WireMock.put((UrlPattern)WireMock.urlEqualTo((String)"/upload")).withHeader("Content-Length", WireMock.equalTo((String)"0"));
    }

    private SignedUploadGCP getGcpSignedUpload(SignedUploadGCP.ProgressListenerFactory progressListenerFactory) {
        return new SignedUploadGCP(null, this.wiremockInitiateUrl, this.ctx, "bolt://uri", progressListenerFactory, Thread::sleep, new CommandResponseHandler(this.ctx));
    }

    private static class ControlledProgressListener
    extends ProgressListener.Adapter {
        long progress;
        boolean closeCalled;

        private ControlledProgressListener() {
        }

        public void add(long progress) {
            this.progress += progress;
        }

        public void close() {
            this.closeCalled = true;
        }

        public void failed(Throwable e) {
            throw new UnsupportedOperationException("Should not be called");
        }
    }
}

