/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.util;

import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.neo4j.cli.CommandTestUtils;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.dbms.DumpCommand;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import picocli.CommandLine;
import wiremock.org.hamcrest.Matcher;
import wiremock.org.hamcrest.MatcherAssert;

public class ExportTestUtilities {
    public static void createDump(Path homeDir, Path confDir, Path dump, FileSystemAbstraction fs, String dbName) {
        CommandTestUtils.withSuppressedOutput((Path)homeDir, (Path)confDir, (FileSystemAbstraction)fs, ctx -> {
            DumpCommand dumpCommand = new DumpCommand((ExecutionContext)ctx);
            CommandLine.populateCommand((Object)dumpCommand, (String[])new String[]{"--to-path=" + dump, dbName});
            Assertions.assertThatCode(() -> ((DumpCommand)dumpCommand).execute()).doesNotThrowAnyException();
        });
    }

    public static void prepareDatabase(DatabaseLayout databaseLayout) {
        new TestDatabaseManagementServiceBuilder(databaseLayout).build().shutdown();
    }

    public static void assertThrows(Class<? extends Exception> exceptionClass, Matcher<String> message, ThrowingRunnable action) {
        try {
            action.run();
            org.junit.jupiter.api.Assertions.fail((String)"Should have failed");
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)exceptionClass.isInstance(e));
            MatcherAssert.assertThat((Object)e.getMessage(), message);
        }
    }

    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }

    public static class ControlledProgressListener
    extends ProgressListener.Adapter {
        public long progress;
        public boolean closeCalled;

        public void add(long progress) {
            this.progress += progress;
        }

        public void close() {
            this.closeCalled = true;
        }

        public void failed(Throwable e) {
            throw new UnsupportedOperationException("Should not be called");
        }
    }
}

