/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.util;

import java.io.IOException;
import java.io.OutputStream;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.export.util.ProgressTrackingOutputStream;
import org.neo4j.internal.helpers.progress.ProgressListener;

class ProgressTrackingOutputStreamTest {
    ProgressTrackingOutputStreamTest() {
    }

    @Test
    void shouldTrackSingleByteWrites() throws IOException {
        OutputStream actual = (OutputStream)Mockito.mock(OutputStream.class);
        ProgressListener progressListener = (ProgressListener)Mockito.mock(ProgressListener.class);
        ProgressTrackingOutputStream.Progress progress = new ProgressTrackingOutputStream.Progress(progressListener, 0L);
        try (ProgressTrackingOutputStream out = new ProgressTrackingOutputStream(actual, progress);){
            out.write(10);
        }
        progress.done();
        ((ProgressListener)Mockito.verify((Object)progressListener)).add(1L);
        ((ProgressListener)Mockito.verify((Object)progressListener)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{progressListener});
    }

    @Test
    void shouldTrackByteArrayWrites() throws IOException {
        OutputStream actual = (OutputStream)Mockito.mock(OutputStream.class);
        ProgressListener progressListener = (ProgressListener)Mockito.mock(ProgressListener.class);
        ProgressTrackingOutputStream.Progress progress = new ProgressTrackingOutputStream.Progress(progressListener, 0L);
        int length = 14;
        try (ProgressTrackingOutputStream out = new ProgressTrackingOutputStream(actual, progress);){
            out.write(new byte[length]);
        }
        progress.done();
        ((ProgressListener)Mockito.verify((Object)progressListener)).add((long)length);
        ((ProgressListener)Mockito.verify((Object)progressListener)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{progressListener});
    }

    @Test
    void shouldTrackOffsetByteArrayWrites() throws IOException {
        OutputStream actual = (OutputStream)Mockito.mock(OutputStream.class);
        ProgressListener progressListener = (ProgressListener)Mockito.mock(ProgressListener.class);
        ProgressTrackingOutputStream.Progress progress = new ProgressTrackingOutputStream.Progress(progressListener, 0L);
        int length = 5;
        try (ProgressTrackingOutputStream out = new ProgressTrackingOutputStream(actual, progress);){
            out.write(new byte[length * 2], 2, length);
        }
        progress.done();
        ((ProgressListener)Mockito.verify((Object)progressListener)).add((long)length);
        ((ProgressListener)Mockito.verify((Object)progressListener)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{progressListener});
    }

    @Test
    void shouldTrackOffsetAfterRewind() throws IOException {
        OutputStream actual = (OutputStream)Mockito.mock(OutputStream.class);
        ProgressListener progressListener = (ProgressListener)Mockito.mock(ProgressListener.class);
        ProgressTrackingOutputStream.Progress progress = new ProgressTrackingOutputStream.Progress(progressListener, 0L);
        try (ProgressTrackingOutputStream out = new ProgressTrackingOutputStream(actual, progress);){
            out.write(new byte[20]);
            progress.rewindTo(15L);
            out.write(new byte[3]);
            out.write(new byte[9]);
        }
        progress.done();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{progressListener});
        ((ProgressListener)inOrder.verify((Object)progressListener)).add(20L);
        ((ProgressListener)inOrder.verify((Object)progressListener)).add(7L);
        ((ProgressListener)inOrder.verify((Object)progressListener)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{progressListener});
    }

    @Test
    void shouldNoteInitialPosition() {
        ProgressListener progressListener = (ProgressListener)Mockito.mock(ProgressListener.class);
        new ProgressTrackingOutputStream.Progress(progressListener, 10L);
        ((ProgressListener)Mockito.verify((Object)progressListener)).add(10L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{progressListener});
    }
}

