/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.Strings;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;

public class QueryLoggerKernelExtension
extends KernelExtensionFactory<Dependencies> {
    public QueryLoggerKernelExtension() {
        super("query-logging");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        final Config config = dependencies.config();
        boolean queryLogEnabled = (Boolean)config.get(GraphDatabaseSettings.log_queries);
        final File queryLogFile = (File)config.get(GraphDatabaseSettings.log_queries_filename);
        final FileSystemAbstraction fileSystem = dependencies.fileSystem();
        final JobScheduler jobScheduler = dependencies.jobScheduler();
        final Monitors monitoring = dependencies.monitoring();
        if (!queryLogEnabled) {
            return this.createEmptyAdapter();
        }
        if (queryLogFile == null) {
            dependencies.logger().getInternalLog(((Object)((Object)this)).getClass()).warn(GraphDatabaseSettings.log_queries.name() + " is enabled but no " + GraphDatabaseSettings.log_queries_filename.name() + " has not been provided in configuration, hence query logging is suppressed");
            return this.createEmptyAdapter();
        }
        return new LifecycleAdapter(){
            Closeable closable;

            public void init() throws Throwable {
                FormattedLog log;
                Long thresholdMillis = (Long)config.get(GraphDatabaseSettings.log_queries_threshold);
                Long rotationThreshold = (Long)config.get(GraphDatabaseSettings.log_queries_rotation_threshold);
                int maxArchives = (Integer)config.get(GraphDatabaseSettings.log_queries_max_archives);
                FormattedLog.Builder logBuilder = FormattedLog.withUTCTimeZone();
                if (rotationThreshold == 0L) {
                    OutputStream logOutputStream = Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)queryLogFile, (boolean)true);
                    log = logBuilder.toOutputStream(logOutputStream);
                    this.closable = logOutputStream;
                } else {
                    RotatingFileOutputStreamSupplier rotatingSupplier = new RotatingFileOutputStreamSupplier(fileSystem, queryLogFile, rotationThreshold.longValue(), 0L, maxArchives, jobScheduler.executor(JobScheduler.Groups.queryLogRotation));
                    log = logBuilder.toOutputStream((Supplier)rotatingSupplier);
                    this.closable = rotatingSupplier;
                }
                QueryLogger logger = new QueryLogger(Clock.SYSTEM_CLOCK, (Log)log, thresholdMillis);
                monitoring.addMonitorListener((Object)logger, new String[0]);
            }

            public void shutdown() throws Throwable {
                this.closable.close();
            }
        };
    }

    private Lifecycle createEmptyAdapter() {
        return new LifecycleAdapter();
    }

    public static class QueryLogger
    implements QueryExecutionMonitor {
        private static final QuerySession.MetadataKey<Long> START_TIME = new QuerySession.MetadataKey(Long.class, "start time");
        private static final QuerySession.MetadataKey<String> QUERY_STRING = new QuerySession.MetadataKey(String.class, "query string");
        private static final QuerySession.MetadataKey<Map<String, Object>> PARAMS = new QuerySession.MetadataKey(Map.class, "parameters");
        private final Clock clock;
        private final Log log;
        private final long thresholdMillis;

        public QueryLogger(Clock clock, Log log, long thresholdMillis) {
            this.clock = clock;
            this.log = log;
            this.thresholdMillis = thresholdMillis;
        }

        public void startQueryExecution(QuerySession session, String query, Map<String, Object> parameters) {
            long startTime = this.clock.currentTimeMillis();
            Object oldTime = session.put(START_TIME, (Object)startTime);
            Object oldQuery = session.put(QUERY_STRING, (Object)query);
            session.put(PARAMS, parameters);
            if (oldTime != null || oldQuery != null) {
                this.log.error("Concurrent queries for session %s: \"%s\" @ %s and \"%s\" @ %s", new Object[]{session.toString(), oldQuery, oldTime, query, startTime});
            }
        }

        public void endFailure(QuerySession session, Throwable failure) {
            String query = (String)session.remove(QUERY_STRING);
            Long startTime = (Long)session.remove(START_TIME);
            Map params = (Map)session.remove(PARAMS);
            if (startTime != null) {
                long time = this.clock.currentTimeMillis() - startTime;
                this.log.error(String.format("%d ms: %s - %s - %s", time, session.toString(), query == null ? "<unknown query>" : query, this.mapToString(params)), failure);
            }
        }

        public void endSuccess(QuerySession session) {
            String query = (String)session.remove(QUERY_STRING);
            Long startTime = (Long)session.remove(START_TIME);
            if (startTime != null) {
                long time = this.clock.currentTimeMillis() - startTime;
                Map params = (Map)session.remove(PARAMS);
                if (time >= this.thresholdMillis) {
                    this.log.info("%d ms: %s - %s - %s", new Object[]{time, session.toString(), query == null ? "<unknown query>" : query, this.mapToString(params)});
                }
            }
        }

        private String mapToString(Map<String, Object> params) {
            if (params == null) {
                return "{}";
            }
            StringBuilder builder = new StringBuilder("{");
            String sep = "";
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                builder.append(sep).append(entry.getKey()).append(": ");
                Object value = entry.getValue();
                if (value instanceof Map) {
                    builder.append(this.mapToString((Map)value));
                } else {
                    builder.append(Strings.prettyPrint((Object)value));
                }
                sep = ", ";
            }
            builder.append("}");
            return builder.toString();
        }
    }

    public static interface Dependencies {
        public FileSystemAbstraction fileSystem();

        public Config config();

        public Monitors monitoring();

        public LogService logger();

        public JobScheduler jobScheduler();
    }
}

