/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class QueryLoggerIT {
    @Rule
    public final EphemeralFileSystemRule fileSystem = new EphemeralFileSystemRule();
    @Rule
    public final TargetDirectory.TestDirectory testDirectory = TargetDirectory.testDirForTest(this.getClass());
    private AssertableLogProvider inMemoryLog;
    private GraphDatabaseBuilder databaseBuilder;
    public static final String QUERY = "CREATE (n:Foo{bar:\"baz\"})";

    @Before
    public void setUp() {
        this.inMemoryLog = new AssertableLogProvider();
        this.databaseBuilder = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fileSystem.get()).setInternalLogProvider((LogProvider)this.inMemoryLog).newImpermanentDatabaseBuilder(this.testDirectory.graphDbDir());
    }

    @Test
    public void shouldLogQuerySlowerThanThreshold() throws Exception {
        File logsDirectory = new File(this.testDirectory.graphDbDir(), "logs");
        File logFilename = new File(logsDirectory, "query.log");
        GraphDatabaseService database = this.databaseBuilder.setConfig(GraphDatabaseSettings.log_queries, "true").setConfig(GraphDatabaseSettings.logs_directory, logsDirectory.getPath()).setConfig(GraphDatabaseSettings.log_queries_parameter_logging_enabled, "false").newGraphDatabase();
        this.executeQueryAndShutdown(database);
        List<String> logLines = this.readAllLines(logFilename);
        Assert.assertEquals((long)1L, (long)logLines.size());
        Assert.assertThat((Object)logLines.get(0), (Matcher)Matchers.endsWith((String)String.format(" ms: %s - %s", QueryEngineProvider.embeddedSession(null), QUERY)));
    }

    @Test
    public void shouldLogParametersWhenNestedMap() throws Exception {
        File logsDirectory = new File(this.testDirectory.graphDbDir(), "logs");
        File logFilename = new File(logsDirectory, "query.log");
        GraphDatabaseService database = this.databaseBuilder.setConfig(GraphDatabaseSettings.log_queries, "true").setConfig(GraphDatabaseSettings.logs_directory, logsDirectory.getPath()).setConfig(GraphDatabaseSettings.log_queries_parameter_logging_enabled, "true").newGraphDatabase();
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("name", "Roland");
        props.put("position", "Gunslinger");
        props.put("followers", Arrays.asList("Jake", "Eddie", "Susannah"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("props", props);
        String query = "CREATE ({props})";
        this.executeQueryAndShutdown(database, query, params);
        List<String> logLines = this.readAllLines(logFilename);
        Assert.assertEquals((long)1L, (long)logLines.size());
        Assert.assertThat((Object)logLines.get(0), (Matcher)Matchers.endsWith((String)String.format(" ms: %s - %s - {props: {name: Roland, position: Gunslinger, followers: [Jake, Eddie, Susannah]}}", QueryEngineProvider.embeddedSession(null), query)));
    }

    @Test
    public void shouldLogParametersWhenList() throws Exception {
        File logsDirectory = new File(this.testDirectory.graphDbDir(), "logs");
        File logFilename = new File(logsDirectory, "query.log");
        GraphDatabaseService database = this.databaseBuilder.setConfig(GraphDatabaseSettings.log_queries, "true").setConfig(GraphDatabaseSettings.logs_directory, logsDirectory.getPath()).newGraphDatabase();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", Arrays.asList(0, 1, 2));
        String query = "MATCH (n) WHERE id(n) in {ids} RETURN n.name";
        this.executeQueryAndShutdown(database, query, params);
        List<String> logLines = this.readAllLines(logFilename);
        Assert.assertEquals((long)1L, (long)logLines.size());
        Assert.assertThat((Object)logLines.get(0), (Matcher)Matchers.endsWith((String)String.format(" ms: %s - %s - {ids: [0, 1, 2]}", QueryEngineProvider.embeddedSession(null), query)));
    }

    @Test
    public void disabledQueryLogging() throws IOException {
        File logFilename = new File(this.testDirectory.graphDbDir(), "query.log");
        GraphDatabaseService database = this.databaseBuilder.setConfig(GraphDatabaseSettings.log_queries, "false").setConfig(GraphDatabaseSettings.log_queries_filename, logFilename.getPath()).newGraphDatabase();
        this.executeQueryAndShutdown(database);
        List<String> lines = this.readAllLines(logFilename);
        Assert.assertTrue((String)"Should not have any queries logged since query log is disabled", (boolean)lines.isEmpty());
    }

    @Test
    public void queryLogRotation() throws Exception {
        File logsDirectory = new File(this.testDirectory.graphDbDir(), "logs");
        File logFilename = new File(logsDirectory, "query.log");
        File shiftedLogFilename = new File(logsDirectory, "query.log.1");
        GraphDatabaseService database = this.databaseBuilder.setConfig(GraphDatabaseSettings.log_queries, "true").setConfig(GraphDatabaseSettings.logs_directory, logsDirectory.getPath()).setConfig(GraphDatabaseSettings.log_queries_rotation_threshold, "1").newGraphDatabase();
        database.execute(QUERY);
        database.execute(QUERY);
        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        database.execute(QUERY);
        database.shutdown();
        List<String> lines = this.readAllLines(logFilename);
        Assert.assertEquals((long)1L, (long)lines.size());
        List<String> shiftedLines = this.readAllLines(shiftedLogFilename);
        Assert.assertEquals((long)2L, (long)shiftedLines.size());
    }

    private void executeQueryAndShutdown(GraphDatabaseService database) {
        this.executeQueryAndShutdown(database, QUERY, Collections.emptyMap());
    }

    private void executeQueryAndShutdown(GraphDatabaseService database, String query, Map<String, Object> params) {
        Result execute = database.execute(query, params);
        execute.close();
        database.shutdown();
    }

    private List<String> readAllLines(File logFilename) throws IOException {
        ArrayList<String> logLines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(this.fileSystem.get().openAsReader(logFilename, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                logLines.add(line);
            }
        }
        return logLines;
    }
}

