/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.impl.query.QueryLoggerKernelExtension;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;

public class QueryLoggerTest {
    public static final String SESSION_1_NAME = "{session one}";
    public static final String SESSION_2_NAME = "{session two}";
    public static final String SESSION_3_NAME = "{session three}";
    public static final String QUERY_1 = "MATCH (n) RETURN n";
    public static final String QUERY_2 = "MATCH (a)--(b) RETURN b.name";
    public static final String QUERY_3 = "MATCH (c)-[:FOO]->(d) RETURN d.size";
    public static final String QUERY_4 = "MATCH (n) WHERE n.age IN {ages} RETURN n";

    @Test
    public void shouldLogQuerySlowerThanThreshold() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        QuerySession session = QueryLoggerTest.session(SESSION_1_NAME);
        FakeClock clock = new FakeClock();
        QueryLoggerKernelExtension.QueryLogger queryLogger = this.queryLoggerWithoutParams((LogProvider)logProvider, (Clock)clock);
        queryLogger.startQueryExecution(session, QUERY_1, Collections.emptyMap());
        clock.forward(11L, TimeUnit.MILLISECONDS);
        queryLogger.endSuccess(session);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).info("%d ms: %s - %s", new Object[]{11L, SESSION_1_NAME, QUERY_1})});
    }

    @Test
    public void shouldNotLogQueryFasterThanThreshold() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        QuerySession session = QueryLoggerTest.session(SESSION_1_NAME);
        FakeClock clock = new FakeClock();
        QueryLoggerKernelExtension.QueryLogger queryLogger = this.queryLoggerWithoutParams((LogProvider)logProvider, (Clock)clock);
        queryLogger.startQueryExecution(session, QUERY_1, Collections.emptyMap());
        clock.forward(9L, TimeUnit.MILLISECONDS);
        queryLogger.endSuccess(session);
        logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void shouldKeepTrackOfDifferentSessions() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        QuerySession session1 = QueryLoggerTest.session(SESSION_1_NAME);
        QuerySession session2 = QueryLoggerTest.session(SESSION_2_NAME);
        QuerySession session3 = QueryLoggerTest.session(SESSION_3_NAME);
        FakeClock clock = new FakeClock();
        QueryLoggerKernelExtension.QueryLogger queryLogger = this.queryLoggerWithoutParams((LogProvider)logProvider, (Clock)clock);
        queryLogger.startQueryExecution(session1, QUERY_1, Collections.emptyMap());
        clock.forward(1L, TimeUnit.MILLISECONDS);
        queryLogger.startQueryExecution(session2, QUERY_2, Collections.emptyMap());
        clock.forward(1L, TimeUnit.MILLISECONDS);
        queryLogger.startQueryExecution(session3, QUERY_3, Collections.emptyMap());
        clock.forward(7L, TimeUnit.MILLISECONDS);
        queryLogger.endSuccess(session3);
        clock.forward(7L, TimeUnit.MILLISECONDS);
        queryLogger.endSuccess(session2);
        clock.forward(7L, TimeUnit.MILLISECONDS);
        queryLogger.endSuccess(session1);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).info("%d ms: %s - %s", new Object[]{15L, SESSION_2_NAME, QUERY_2}), AssertableLogProvider.inLog(this.getClass()).info("%d ms: %s - %s", new Object[]{23L, SESSION_1_NAME, QUERY_1})});
    }

    @Test
    public void shouldLogQueryOnFailureEvenIfFasterThanThreshold() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        QuerySession session = QueryLoggerTest.session(SESSION_1_NAME);
        FakeClock clock = new FakeClock();
        QueryLoggerKernelExtension.QueryLogger queryLogger = this.queryLoggerWithoutParams((LogProvider)logProvider, (Clock)clock);
        RuntimeException failure = new RuntimeException();
        queryLogger.startQueryExecution(session, QUERY_1, Collections.emptyMap());
        clock.forward(1L, TimeUnit.MILLISECONDS);
        queryLogger.endFailure(session, (Throwable)failure);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).error(Is.is((Object)"1 ms: {session one} - MATCH (n) RETURN n"), Matchers.sameInstance((Object)failure))});
    }

    @Test
    public void shouldLogQueryParameters() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        QuerySession session = QueryLoggerTest.session(SESSION_1_NAME);
        FakeClock clock = new FakeClock();
        QueryLoggerKernelExtension.QueryLogger queryLogger = this.queryLoggerWithParams((LogProvider)logProvider, (Clock)clock);
        HashMap<String, List<Integer>> params = new HashMap<String, List<Integer>>();
        params.put("ages", Arrays.asList(41, 42, 43));
        queryLogger.startQueryExecution(session, QUERY_4, params);
        clock.forward(11L, TimeUnit.MILLISECONDS);
        queryLogger.endSuccess(session);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).info("%d ms: %s - %s - %s", new Object[]{11L, SESSION_1_NAME, QUERY_4, "{ages: [41, 42, 43]}"})});
    }

    @Test
    public void shouldLogQueryParametersOnFailure() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        QuerySession session = QueryLoggerTest.session(SESSION_1_NAME);
        FakeClock clock = new FakeClock();
        QueryLoggerKernelExtension.QueryLogger queryLogger = this.queryLoggerWithParams((LogProvider)logProvider, (Clock)clock);
        RuntimeException failure = new RuntimeException();
        HashMap<String, List<Integer>> params = new HashMap<String, List<Integer>>();
        params.put("ages", Arrays.asList(41, 42, 43));
        queryLogger.startQueryExecution(session, QUERY_4, params);
        clock.forward(1L, TimeUnit.MILLISECONDS);
        queryLogger.endFailure(session, (Throwable)failure);
        logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).error(Is.is((Object)"1 ms: {session one} - MATCH (n) WHERE n.age IN {ages} RETURN n - {ages: [41, 42, 43]}"), Matchers.sameInstance((Object)failure))});
    }

    private QueryLoggerKernelExtension.QueryLogger queryLoggerWithoutParams(LogProvider logProvider, Clock clock) {
        return new QueryLoggerKernelExtension.QueryLogger(clock, logProvider.getLog(this.getClass()), 10L, false);
    }

    private QueryLoggerKernelExtension.QueryLogger queryLoggerWithParams(LogProvider logProvider, Clock clock) {
        return new QueryLoggerKernelExtension.QueryLogger(clock, logProvider.getLog(this.getClass()), 10L, true);
    }

    private static QuerySession session(final String data) {
        return new QuerySession(null){

            public String toString() {
                return data;
            }
        };
    }
}

