/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class RandomValuesTest {
    private static final int ITERATIONS = 500;
    @Parameterized.Parameter
    public RandomValues randomValues;
    @Parameterized.Parameter(value=1)
    public String name;
    private static final byte BOUND = 100;
    private static final LongValue UPPER = Values.longValue((long)100L);
    private static final Set<Class<? extends NumberValue>> NUMBER_TYPES = new HashSet<Class>(Arrays.asList(LongValue.class, IntValue.class, ShortValue.class, ByteValue.class, FloatValue.class, DoubleValue.class));
    private static final Set<Class<? extends AnyValue>> TYPES = new HashSet<Class>(Arrays.asList(LongValue.class, IntValue.class, ShortValue.class, ByteValue.class, FloatValue.class, DoubleValue.class, TextValue.class, BooleanValue.class, PointValue.class, DateTimeValue.class, LocalDateTimeValue.class, DateValue.class, TimeValue.class, LocalTimeValue.class, DurationValue.class));

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> generators() {
        return Arrays.asList({RandomValues.create((Random)ThreadLocalRandom.current()), Random.class.getName()}, {RandomValues.create((SplittableRandom)new SplittableRandom()), SplittableRandom.class.getName()});
    }

    @Test
    public void nextLongValueUnbounded() {
        this.checkDistribution(() -> ((RandomValues)this.randomValues).nextLongValue());
    }

    @Test
    public void nextLongValueBounded() {
        this.checkDistribution(() -> this.randomValues.nextLongValue(100L));
        this.checkBounded(() -> this.randomValues.nextLongValue(100L));
    }

    @Test
    public void nextLongValueBoundedAndShifted() {
        HashSet<LongValue> values = new HashSet<LongValue>();
        for (int i = 0; i < 500; ++i) {
            LongValue value = this.randomValues.nextLongValue(1337L, 1437L);
            Assert.assertThat((Object)value, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)value.compareTo((IntegralValue)Values.longValue((long)1337L)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
            Assert.assertThat((String)value.toString(), (Object)value.compareTo((IntegralValue)Values.longValue((long)1437L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(0)));
            values.add(value);
        }
        Assert.assertThat((Object)values.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
    }

    @Test
    public void nextBooleanValue() {
        this.checkDistribution(() -> ((RandomValues)this.randomValues).nextBooleanValue());
    }

    @Test
    public void nextIntValueUnbounded() {
        this.checkDistribution(() -> ((RandomValues)this.randomValues).nextIntValue());
    }

    @Test
    public void nextIntValueBounded() {
        this.checkDistribution(() -> this.randomValues.nextIntValue(100));
        this.checkBounded(() -> this.randomValues.nextIntValue(100));
    }

    @Test
    public void nextShortValueUnbounded() {
        this.checkDistribution(() -> ((RandomValues)this.randomValues).nextShortValue());
    }

    @Test
    public void nextShortValueBounded() {
        this.checkDistribution(() -> this.randomValues.nextShortValue((short)100));
        this.checkBounded(() -> this.randomValues.nextShortValue((short)100));
    }

    @Test
    public void nextByteValueUnbounded() {
        this.checkDistribution(() -> ((RandomValues)this.randomValues).nextByteValue());
    }

    @Test
    public void nextByteValueBounded() {
        this.checkDistribution(() -> this.randomValues.nextByteValue((byte)100));
        this.checkBounded(() -> this.randomValues.nextByteValue((byte)100));
    }

    @Test
    public void nextFloatValue() {
        this.checkDistribution(() -> ((RandomValues)this.randomValues).nextFloatValue());
    }

    @Test
    public void nextDoubleValue() {
        this.checkDistribution(() -> ((RandomValues)this.randomValues).nextDoubleValue());
    }

    @Test
    public void nextNumberValue() {
        HashSet<Class<? extends NumberValue>> seen = new HashSet<Class<? extends NumberValue>>(NUMBER_TYPES);
        for (int i = 0; i < 500; ++i) {
            NumberValue numberValue = this.randomValues.nextNumberValue();
            Assert.assertThat(NUMBER_TYPES, (Matcher)Matchers.hasItem(numberValue.getClass()));
            seen.remove(numberValue.getClass());
        }
        Assert.assertThat(seen, (Matcher)Matchers.empty());
    }

    @Test
    public void nextAlphaNumericString() {
        Set seenDigits = "ABCDEFGHIJKLMNOPQRSTUVXYZabcdefghijklmnopqrstuvxyz0123456789".chars().boxed().collect(Collectors.toSet());
        for (int i = 0; i < 500; ++i) {
            TextValue textValue = this.randomValues.nextAlphaNumericTextValue(10, 20);
            String asString = textValue.stringValue();
            for (int j = 0; j < asString.length(); ++j) {
                char ch = asString.charAt(j);
                Assert.assertTrue((String)("Not a character nor letter: " + ch), (Character.isAlphabetic(ch) || Character.isDigit((int)ch) ? 1 : 0) != 0);
                seenDigits.remove(ch);
            }
        }
        Assert.assertThat(seenDigits, (Matcher)Matchers.empty());
    }

    @Test
    public void nextAsciiString() {
        for (int i = 0; i < 500; ++i) {
            TextValue textValue = this.randomValues.nextAsciiTextValue(10, 20);
            String asString = textValue.stringValue();
            int length = asString.length();
            Assert.assertThat((Object)length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(10)));
            Assert.assertThat((Object)length, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(20)));
        }
    }

    @Test
    public void nextString() {
        for (int i = 0; i < 500; ++i) {
            TextValue textValue = this.randomValues.nextTextValue(10, 20);
            String asString = textValue.stringValue();
            int length = asString.codePointCount(0, asString.length());
            Assert.assertThat((Object)length, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(10)));
            Assert.assertThat((Object)length, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(20)));
        }
    }

    @Test
    public void nextArray() {
        HashSet<Class<? extends AnyValue>> seen = new HashSet<Class<? extends AnyValue>>(TYPES);
        for (int i = 0; i < 500; ++i) {
            ArrayValue arrayValue = this.randomValues.nextArray();
            Assert.assertThat((Object)arrayValue.length(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            AnyValue value = arrayValue.value(0);
            this.assertKnownType(value.getClass(), TYPES);
            this.markSeen(value.getClass(), seen);
        }
        Assert.assertThat(seen, (Matcher)Matchers.empty());
    }

    @Test
    public void nextValue() {
        HashSet<Class<? extends AnyValue>> all = new HashSet<Class<? extends AnyValue>>(TYPES);
        all.add(ArrayValue.class);
        HashSet<Class<? extends AnyValue>> seen = new HashSet<Class<? extends AnyValue>>(all);
        for (int i = 0; i < 500; ++i) {
            Value value = this.randomValues.nextValue();
            this.assertKnownType(value.getClass(), all);
            this.markSeen(value.getClass(), seen);
        }
        Assert.assertThat(seen, (Matcher)Matchers.empty());
    }

    @Test
    public void nextValueOfTypes() {
        Object[] allTypes = ValueType.values();
        ValueType[] including = (ValueType[])this.randomValues.selection(allTypes, 1, allTypes.length, false);
        HashSet<Class<? extends AnyValue>> seen = new HashSet<Class<? extends AnyValue>>();
        for (ValueType type : including) {
            seen.add(type.valueClass);
        }
        for (int i = 0; i < 500; ++i) {
            Value value = this.randomValues.nextValueOfTypes(including);
            this.assertValueAmongTypes(including, value);
            this.markSeen(value.getClass(), seen);
        }
        Assert.assertThat(seen, (Matcher)Matchers.empty());
    }

    @Test
    public void excluding() {
        Object[] allTypes = ValueType.values();
        ValueType[] excluding = (ValueType[])this.randomValues.selection(allTypes, 1, allTypes.length, false);
        Object[] including = RandomValues.excluding((ValueType[])excluding);
        for (ValueType excludedType : excluding) {
            if (!ArrayUtils.contains((Object[])including, (Object)excludedType)) continue;
            Assert.fail((String)("Including array " + Arrays.toString(including) + " contains excluded type " + excludedType));
        }
    }

    @Test
    public void nextBasicMultilingualPlaneTextValue() {
        for (int i = 0; i < 500; ++i) {
            TextValue value = this.randomValues.nextBasicMultilingualPlaneTextValue();
            Assert.assertThat((Object)value.length(), (Matcher)Matchers.equalTo((Object)value.stringValue().length()));
        }
    }

    private void assertValueAmongTypes(ValueType[] types, Value value) {
        for (ValueType type : types) {
            if (!type.valueClass.isAssignableFrom(value.getClass())) continue;
            return;
        }
        Assert.fail((String)("Value " + value + " was not among types " + Arrays.toString(types)));
    }

    private void assertKnownType(Class<? extends AnyValue> typeToCheck, Set<Class<? extends AnyValue>> types) {
        for (Class<? extends AnyValue> type : types) {
            if (!type.isAssignableFrom(typeToCheck)) continue;
            return;
        }
        Assert.fail((String)(typeToCheck + " is not an expected type "));
    }

    private void markSeen(Class<? extends AnyValue> typeToCheck, Set<Class<? extends AnyValue>> seen) {
        seen.removeIf(t -> t.isAssignableFrom(typeToCheck));
    }

    private void checkDistribution(Supplier<Value> supplier) {
        HashSet<Value> values = new HashSet<Value>();
        for (int i = 0; i < 500; ++i) {
            Value value = supplier.get();
            Assert.assertThat((Object)value, (Matcher)Matchers.notNullValue());
            values.add(value);
        }
        Assert.assertThat((Object)values.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
    }

    private void checkBounded(Supplier<NumberValue> supplier) {
        for (int i = 0; i < 500; ++i) {
            NumberValue value = supplier.get();
            Assert.assertThat((Object)value, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)value.compareTo(Values.ZERO_INT), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
            Assert.assertThat((Object)value.compareTo((IntegralValue)UPPER), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        }
    }
}

