/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.StringHelpers;
import org.neo4j.values.storable.TextValue;

@ExtendWith(value={RandomExtension.class})
class TextValueFuzzTest {
    @Inject
    private RandomRule random;
    private static final int ITERATIONS = 1000;

    TextValueFuzzTest() {
    }

    @Disabled(value="we have decided to stick with String::compareTo under the hood which doesn't respect code point order whenever the code point doesn't fit 16bits")
    @Test
    void shouldCompareToForAllValidStrings() {
        for (int i = 0; i < 1000; ++i) {
            StringHelpers.assertConsistent(this.random.nextString(), this.random.nextString(), (t1, t2) -> Float.valueOf(Math.signum(t1.compareTo(t2))));
        }
    }

    @Test
    void shouldCompareToForAllStringsInBasicMultilingualPlane() {
        for (int i = 0; i < 1000; ++i) {
            StringHelpers.assertConsistent(this.random.nextBasicMultilingualPlaneString(), this.random.nextBasicMultilingualPlaneString(), (t1, t2) -> Float.valueOf(Math.signum(t1.compareTo(t2))));
        }
    }

    @Test
    void shouldAdd() {
        for (int i = 0; i < 1000; ++i) {
            StringHelpers.assertConsistent(this.random.nextString(), this.random.nextString(), TextValue::plus);
        }
    }

    @Test
    void shouldComputeLength() {
        for (int i = 0; i < 1000; ++i) {
            StringHelpers.assertConsistent(this.random.nextString(), TextValue::length);
        }
    }

    @Test
    void shouldReverse() {
        for (int i = 0; i < 1000; ++i) {
            StringHelpers.assertConsistent(this.random.nextString(), TextValue::reverse);
        }
    }

    @Test
    void shouldTrim() {
        for (int i = 0; i < 1000; ++i) {
            StringHelpers.assertConsistent(this.random.nextString(), TextValue::trim);
        }
    }

    @Test
    void shouldHandleStringPredicates() {
        for (int i = 0; i < 1000; ++i) {
            String value = this.random.nextString();
            String other = this.random.nextBoolean() ? value : this.random.nextString();
            StringHelpers.assertConsistent(value, other, TextValue::startsWith);
            StringHelpers.assertConsistent(value, other, TextValue::endsWith);
            StringHelpers.assertConsistent(value, other, TextValue::contains);
        }
    }
}

