/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.UTF8StringValueBuilder;

class UTF8StringValueBuilderTest {
    UTF8StringValueBuilderTest() {
    }

    @Test
    void shouldHandleSingleByteCodePoints() {
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder();
        int codepoint = "$".codePointAt(0);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        TextValue textValue = builder.build();
        MatcherAssert.assertThat((Object)textValue.stringValue(), (Matcher)CoreMatchers.equalTo((Object)"$$$"));
    }

    @Test
    void shouldHandleTwoByteCodePoints() {
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder();
        int codepoint = "\u00a2".codePointAt(0);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        TextValue textValue = builder.build();
        MatcherAssert.assertThat((Object)textValue.stringValue(), (Matcher)CoreMatchers.equalTo((Object)"\u00a2\u00a2\u00a2"));
    }

    @Test
    void shouldHandleThreeByteCodePoints() {
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder();
        int codepoint = "\u20ac".codePointAt(0);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        TextValue textValue = builder.build();
        MatcherAssert.assertThat((Object)textValue.stringValue(), (Matcher)CoreMatchers.equalTo((Object)"\u20ac\u20ac\u20ac"));
    }

    @Test
    void shouldHandleFourByteCodePoints() {
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder();
        int codepoint = "\ud800\udf48".codePointAt(0);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        TextValue textValue = builder.build();
        MatcherAssert.assertThat((Object)textValue.stringValue(), (Matcher)CoreMatchers.equalTo((Object)"\ud800\udf48\ud800\udf48\ud800\udf48"));
    }
}

