/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.UTF8StringValueTest;

@ExtendWith(value={RandomExtension.class})
class UTF8StringValueRandomTest {
    @Inject
    RandomRule random;

    UTF8StringValueRandomTest() {
    }

    @Test
    void shouldCompareToRandomAlphanumericString() {
        for (int i = 0; i < 100; ++i) {
            String string1 = this.random.nextAlphaNumericString();
            String string2 = this.random.nextAlphaNumericString();
            UTF8StringValueTest.assertCompareTo((String)string1, (String)string2);
        }
    }

    @Test
    void shouldCompareToAsciiString() {
        for (int i = 0; i < 100; ++i) {
            String string1 = this.random.nextAsciiString();
            String string2 = this.random.nextAsciiString();
            UTF8StringValueTest.assertCompareTo((String)string1, (String)string2);
        }
    }

    @Test
    void shouldCompareBasicMultilingualPlaneString() {
        for (int i = 0; i < 100; ++i) {
            String string1 = this.random.nextBasicMultilingualPlaneString();
            String string2 = this.random.nextBasicMultilingualPlaneString();
            UTF8StringValueTest.assertCompareTo((String)string1, (String)string2);
        }
    }

    @Disabled(value="Comparing strings with higher than 16 bits code points is known to be inconsistent between StringValue and UTF8StringValue")
    @Test
    void shouldCompareToRandomString() {
        for (int i = 0; i < 100; ++i) {
            String string1 = this.random.nextString();
            String string2 = this.random.nextString();
            UTF8StringValueTest.assertCompareTo((String)string1, (String)string2);
        }
    }
}

