/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

class MemoryEstimationFuzzTest {
    private final RandomValues random = RandomValues.create();
    private static final int ITERATIONS = 1000;

    MemoryEstimationFuzzTest() {
    }

    @Test
    void shouldEstimateIntegerTypes() {
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat((long)this.random.nextByteValue().estimatedHeapUsage()).isLessThanOrEqualTo(this.random.nextShortValue().estimatedHeapUsage());
            Assertions.assertThat((long)this.random.nextShortValue().estimatedHeapUsage()).isLessThanOrEqualTo(this.random.nextIntValue().estimatedHeapUsage());
            Assertions.assertThat((long)this.random.nextIntValue().estimatedHeapUsage()).isLessThanOrEqualTo(this.random.nextLongValue().estimatedHeapUsage());
        }
    }

    @Test
    void shouldEstimateFloatingTypes() {
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat((long)this.random.nextFloatValue().estimatedHeapUsage()).isLessThanOrEqualTo(this.random.nextDoubleValue().estimatedHeapUsage());
        }
    }

    @Test
    void shouldEstimateTextValue() {
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat((long)this.random.nextTextValue(10, 10).estimatedHeapUsage()).isLessThan(this.random.nextTextValue(100, 100).estimatedHeapUsage());
        }
    }

    @Test
    void shouldEstimateArrayValues() {
        for (ValueType type : MemoryEstimationFuzzTest.arrayTypes()) {
            for (int i = 0; i < 1000; ++i) {
                ArrayValue a = (ArrayValue)this.random.nextValueOfType(type);
                ArrayValue b = (ArrayValue)this.random.nextValueOfType(type);
                if (a.length() < b.length()) {
                    org.junit.jupiter.api.Assertions.assertTrue((a.estimatedHeapUsage() <= b.estimatedHeapUsage() ? 1 : 0) != 0);
                    continue;
                }
                org.junit.jupiter.api.Assertions.assertTrue((a.estimatedHeapUsage() >= b.estimatedHeapUsage() ? 1 : 0) != 0);
            }
        }
    }

    @Test
    void shouldEstimateListValues() {
        for (ValueType type : MemoryEstimationFuzzTest.arrayTypes()) {
            for (int i = 0; i < 1000; ++i) {
                ListValue a = VirtualValues.fromArray((ArrayValue)((ArrayValue)this.random.nextValueOfType(type)));
                ListValue b = VirtualValues.fromArray((ArrayValue)((ArrayValue)this.random.nextValueOfType(type)));
                if (a.length() < b.length()) {
                    org.junit.jupiter.api.Assertions.assertTrue((a.estimatedHeapUsage() <= b.estimatedHeapUsage() ? 1 : 0) != 0);
                    continue;
                }
                org.junit.jupiter.api.Assertions.assertTrue((a.estimatedHeapUsage() >= b.estimatedHeapUsage() ? 1 : 0) != 0);
            }
        }
    }

    private static Iterable<ValueType> arrayTypes() {
        return () -> Arrays.stream(ValueType.arrayTypes()).filter(t -> t != ValueType.STRING_ARRAY && t != ValueType.STRING_ALPHANUMERIC_ARRAY && t != ValueType.STRING_ASCII_ARRAY && t != ValueType.STRING_BMP_ARRAY).iterator();
    }
}

