/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

abstract class RandomValuesTest {
    private static final int ITERATIONS = 500;
    private static final Duration TIMEOUT = Duration.ofMinutes(2L);
    private RandomValues randomValues;
    private static final byte BOUND = 100;
    private static final LongValue UPPER = Values.longValue((long)100L);
    private static final Set<Class<? extends NumberValue>> NUMBER_TYPES = new HashSet<Class>(Arrays.asList(LongValue.class, IntValue.class, ShortValue.class, ByteValue.class, FloatValue.class, DoubleValue.class));
    private static final Set<Class<? extends AnyValue>> TYPES = new HashSet<Class>(Arrays.asList(LongValue.class, IntValue.class, ShortValue.class, ByteValue.class, FloatValue.class, DoubleValue.class, TextValue.class, BooleanValue.class, PointValue.class, DateTimeValue.class, LocalDateTimeValue.class, DateValue.class, TimeValue.class, LocalTimeValue.class, DurationValue.class));

    RandomValuesTest() {
    }

    @BeforeEach
    void setUp() {
        this.randomValues = this.randomValues();
    }

    abstract RandomValues randomValues();

    @Test
    void nextLongValueUnbounded() {
        RandomValuesTest.checkDistribution(() -> ((RandomValues)this.randomValues).nextLongValue());
    }

    @Test
    void nextLongValueBounded() {
        RandomValuesTest.checkDistribution(() -> this.randomValues.nextLongValue(100L));
        RandomValuesTest.checkBounded(() -> this.randomValues.nextLongValue(100L));
    }

    @Test
    void nextLongValueBoundedAndShifted() {
        HashSet<LongValue> values = new HashSet<LongValue>();
        for (int i = 0; i < 500; ++i) {
            LongValue value = this.randomValues.nextLongValue(1337L, 1437L);
            Assertions.assertThat((Object)value).isNotNull();
            Assertions.assertThat((int)value.compareTo((IntegralValue)Values.longValue((long)1337L))).isGreaterThanOrEqualTo(0);
            ((AbstractIntegerAssert)Assertions.assertThat((int)value.compareTo((IntegralValue)Values.longValue((long)1437L))).as(value.toString(), new Object[0])).isLessThanOrEqualTo(0);
            values.add(value);
        }
        Assertions.assertThat((int)values.size()).isGreaterThan(1);
    }

    @Test
    void nextBooleanValue() {
        RandomValuesTest.checkDistribution(() -> ((RandomValues)this.randomValues).nextBooleanValue());
    }

    @Test
    void nextIntValueUnbounded() {
        RandomValuesTest.checkDistribution(() -> ((RandomValues)this.randomValues).nextIntValue());
    }

    @Test
    void nextIntValueBounded() {
        RandomValuesTest.checkDistribution(() -> this.randomValues.nextIntValue(100));
        RandomValuesTest.checkBounded(() -> this.randomValues.nextIntValue(100));
    }

    @Test
    void nextShortValueUnbounded() {
        RandomValuesTest.checkDistribution(() -> ((RandomValues)this.randomValues).nextShortValue());
    }

    @Test
    void nextShortValueBounded() {
        RandomValuesTest.checkDistribution(() -> this.randomValues.nextShortValue((short)100));
        RandomValuesTest.checkBounded(() -> this.randomValues.nextShortValue((short)100));
    }

    @Test
    void nextByteValueUnbounded() {
        RandomValuesTest.checkDistribution(() -> ((RandomValues)this.randomValues).nextByteValue());
    }

    @Test
    void nextByteValueBounded() {
        RandomValuesTest.checkDistribution(() -> this.randomValues.nextByteValue((byte)100));
        RandomValuesTest.checkBounded(() -> this.randomValues.nextByteValue((byte)100));
    }

    @Test
    void nextFloatValue() {
        RandomValuesTest.checkDistribution(() -> ((RandomValues)this.randomValues).nextFloatValue());
    }

    @Test
    void nextDoubleValue() {
        RandomValuesTest.checkDistribution(() -> ((RandomValues)this.randomValues).nextDoubleValue());
    }

    @Test
    void nextNumberValue() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            HashSet<Class<? extends NumberValue>> seen = new HashSet<Class<? extends NumberValue>>(NUMBER_TYPES);
            while (!seen.isEmpty()) {
                NumberValue numberValue = this.randomValues.nextNumberValue();
                Assertions.assertThat(NUMBER_TYPES).contains((Object[])new Class[]{numberValue.getClass()});
                seen.remove(numberValue.getClass());
            }
        });
    }

    @Test
    void nextAlphaNumericString() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            Set seenDigits = "ABCDEFGHIJKLMNOPQRSTUVXYZabcdefghijklmnopqrstuvxyz0123456789".chars().boxed().collect(Collectors.toSet());
            while (!seenDigits.isEmpty()) {
                TextValue textValue = this.randomValues.nextAlphaNumericTextValue(10, 20);
                String asString = textValue.stringValue();
                for (int j = 0; j < asString.length(); ++j) {
                    char ch = asString.charAt(j);
                    org.junit.jupiter.api.Assertions.assertTrue((Character.isAlphabetic(ch) || Character.isDigit((int)ch) ? 1 : 0) != 0, (String)("Not a character nor letter: " + ch));
                    seenDigits.remove(ch);
                }
            }
        });
    }

    @Test
    void nextAsciiString() {
        for (int i = 0; i < 500; ++i) {
            TextValue textValue = this.randomValues.nextAsciiTextValue(10, 20);
            String asString = textValue.stringValue();
            int length = asString.length();
            Assertions.assertThat((int)length).isGreaterThanOrEqualTo(10);
            Assertions.assertThat((int)length).isLessThanOrEqualTo(20);
        }
    }

    @Test
    void nextString() {
        for (int i = 0; i < 500; ++i) {
            TextValue textValue = this.randomValues.nextTextValue(10, 20);
            String asString = textValue.stringValue();
            int length = asString.codePointCount(0, asString.length());
            Assertions.assertThat((int)length).isGreaterThanOrEqualTo(10);
            Assertions.assertThat((int)length).isLessThanOrEqualTo(20);
        }
    }

    @Test
    void nextArray() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            HashSet<Class<? extends AnyValue>> seen = new HashSet<Class<? extends AnyValue>>(TYPES);
            while (!seen.isEmpty()) {
                ArrayValue arrayValue = this.randomValues.nextArray();
                Assertions.assertThat((int)arrayValue.length()).isGreaterThanOrEqualTo(1);
                AnyValue value = arrayValue.value(0);
                RandomValuesTest.assertKnownType(value.getClass(), TYPES);
                RandomValuesTest.markSeen(value.getClass(), seen);
            }
        });
    }

    @Test
    void nextValue() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            HashSet<Class<? extends AnyValue>> all = new HashSet<Class<? extends AnyValue>>(TYPES);
            all.add(ArrayValue.class);
            HashSet<Class<? extends AnyValue>> seen = new HashSet<Class<? extends AnyValue>>(all);
            while (!seen.isEmpty()) {
                Value value = this.randomValues.nextValue();
                RandomValuesTest.assertKnownType(value.getClass(), all);
                RandomValuesTest.markSeen(value.getClass(), seen);
            }
        });
    }

    @Test
    void nextValueOfTypes() {
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            Object[] allTypes = ValueType.values();
            ValueType[] including = (ValueType[])this.randomValues.selection(allTypes, 1, allTypes.length, false);
            HashSet<Class<? extends AnyValue>> seen = new HashSet<Class<? extends AnyValue>>();
            for (ValueType type : including) {
                seen.add(type.valueClass);
            }
            while (!seen.isEmpty()) {
                Value value = this.randomValues.nextValueOfTypes(including);
                RandomValuesTest.assertValueAmongTypes(including, value);
                RandomValuesTest.markSeen(value.getClass(), seen);
            }
        });
    }

    @Test
    void excluding() {
        Object[] allTypes = ValueType.values();
        ValueType[] excluding = (ValueType[])this.randomValues.selection(allTypes, 1, allTypes.length, false);
        Object[] including = RandomValues.excluding((ValueType[])excluding);
        for (ValueType excludedType : excluding) {
            if (!ArrayUtils.contains((Object[])including, (Object)excludedType)) continue;
            org.junit.jupiter.api.Assertions.fail((String)("Including array " + Arrays.toString(including) + " contains excluded type " + excludedType));
        }
    }

    @Test
    void nextBasicMultilingualPlaneTextValue() {
        for (int i = 0; i < 500; ++i) {
            TextValue value = this.randomValues.nextBasicMultilingualPlaneTextValue();
            Assertions.assertThat((int)value.length()).isEqualTo(value.stringValue().length());
        }
    }

    private static void assertValueAmongTypes(ValueType[] types, Value value) {
        for (ValueType type : types) {
            if (!type.valueClass.isAssignableFrom(value.getClass())) continue;
            return;
        }
        org.junit.jupiter.api.Assertions.fail((String)("Value " + value + " was not among types " + Arrays.toString(types)));
    }

    private static void assertKnownType(Class<? extends AnyValue> typeToCheck, Set<Class<? extends AnyValue>> types) {
        for (Class<? extends AnyValue> type : types) {
            if (!type.isAssignableFrom(typeToCheck)) continue;
            return;
        }
        org.junit.jupiter.api.Assertions.fail((String)(typeToCheck + " is not an expected type "));
    }

    private static void markSeen(Class<? extends AnyValue> typeToCheck, Set<Class<? extends AnyValue>> seen) {
        seen.removeIf(t -> t.isAssignableFrom(typeToCheck));
    }

    private static void checkDistribution(Supplier<Value> supplier) {
        HashSet<Value> values = new HashSet<Value>();
        for (int i = 0; i < 500; ++i) {
            Value value = supplier.get();
            Assertions.assertThat((Object)value).isNotNull();
            values.add(value);
        }
        Assertions.assertThat((int)values.size()).isGreaterThan(1);
    }

    private static void checkBounded(Supplier<NumberValue> supplier) {
        for (int i = 0; i < 500; ++i) {
            NumberValue value = supplier.get();
            Assertions.assertThat((Object)value).isNotNull();
            Assertions.assertThat((int)value.compareTo(Values.ZERO_INT)).isGreaterThanOrEqualTo(0);
            Assertions.assertThat((int)value.compareTo((IntegralValue)UPPER)).isLessThan(0);
        }
    }
}

