/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

final class StringHelpers {
    private StringHelpers() {
        throw new UnsupportedOperationException();
    }

    static <T> void assertConsistent(String string, Function<TextValue, T> test) {
        TextValue textValue = Values.stringValue((String)string);
        TextValue utf8Value = Values.utf8Value((byte[])string.getBytes(StandardCharsets.UTF_8));
        T a = test.apply(textValue);
        T b = test.apply(utf8Value);
        String errorMsg = String.format("operation not consistent for %s", string);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(b);
        ((ObjectAssert)Assertions.assertThat(b).as(errorMsg, new Object[0])).isEqualTo(a);
    }

    static <T> void assertConsistent(String string1, String string2, BiFunction<TextValue, TextValue, T> test) {
        TextValue textValue1 = Values.stringValue((String)string1);
        TextValue textValue2 = Values.stringValue((String)string2);
        TextValue utf8Value1 = Values.utf8Value((byte[])string1.getBytes(StandardCharsets.UTF_8));
        TextValue utf8Value2 = Values.utf8Value((byte[])string2.getBytes(StandardCharsets.UTF_8));
        T a = test.apply(textValue1, textValue2);
        T x = test.apply(textValue1, utf8Value2);
        T y = test.apply(utf8Value1, textValue2);
        T z = test.apply(utf8Value1, utf8Value2);
        String errorMsg = String.format("operation not consistent for `%s` and `%s`", string1, string2);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(x);
        ((ObjectAssert)Assertions.assertThat(x).as(errorMsg, new Object[0])).isEqualTo(a);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(y);
        ((ObjectAssert)Assertions.assertThat(y).as(errorMsg, new Object[0])).isEqualTo(a);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(z);
        ((ObjectAssert)Assertions.assertThat(z).as(errorMsg, new Object[0])).isEqualTo(a);
    }
}

