/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.UTF8StringValueBuilder;

class UTF8StringValueBuilderTest {
    UTF8StringValueBuilderTest() {
    }

    @Test
    void shouldHandleSingleByteCodePoints() {
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder();
        int codepoint = "$".codePointAt(0);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        TextValue textValue = builder.build();
        Assertions.assertThat((String)textValue.stringValue()).isEqualTo("$$$");
    }

    @Test
    void shouldHandleTwoByteCodePoints() {
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder();
        int codepoint = "\u00a2".codePointAt(0);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        TextValue textValue = builder.build();
        Assertions.assertThat((String)textValue.stringValue()).isEqualTo("\u00a2\u00a2\u00a2");
    }

    @Test
    void shouldHandleThreeByteCodePoints() {
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder();
        int codepoint = "\u20ac".codePointAt(0);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        TextValue textValue = builder.build();
        Assertions.assertThat((String)textValue.stringValue()).isEqualTo("\u20ac\u20ac\u20ac");
    }

    @Test
    void shouldHandleFourByteCodePoints() {
        UTF8StringValueBuilder builder = new UTF8StringValueBuilder();
        int codepoint = "\ud800\udf48".codePointAt(0);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        builder.addCodePoint(codepoint);
        TextValue textValue = builder.build();
        Assertions.assertThat((String)textValue.stringValue()).isEqualTo("\ud800\udf48\ud800\udf48\ud800\udf48");
    }
}

