/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class RandomExtensionTest {
    @Inject
    RandomSupport random;

    RandomExtensionTest() {
    }

    @BeforeEach
    void injectedBeforeEach() {
        RandomExtensionTest.assertInjected(this.random);
    }

    @BeforeEach
    void initialisedBeforeEach() {
        RandomExtensionTest.assertInitialised(this.random);
    }

    @Test
    void injectedTest() {
        RandomExtensionTest.assertInjected(this.random);
    }

    @Test
    void initialisedTest() {
        RandomExtensionTest.assertInitialised(this.random);
    }

    @Test
    @RandomSupport.Seed(value=1337L)
    void seedTest() {
        RandomExtensionTest.assertSeed(this.random, 1337L);
    }

    private static void assertInjected(RandomSupport random) {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)random);
    }

    private static void assertInitialised(RandomSupport random) {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)random.nextAlphaNumericString());
    }

    private static void assertSeed(RandomSupport random, long seed) {
        Assertions.assertThat((long)random.seed()).isEqualTo(seed);
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @TestMethodOrder(value=MethodOrderer.MethodName.class)
    class NestedPerClassWithOrderRandomTest {
        @Inject
        RandomSupport lifetimeRandom;
        private long firstSeed;
        private long testCounter;

        NestedPerClassWithOrderRandomTest() {
        }

        @BeforeAll
        void assertPerClassBeforeAll() {
            RandomExtensionTest.assertInjected(this.lifetimeRandom);
            RandomExtensionTest.assertInitialised(this.lifetimeRandom);
            this.firstSeed = this.lifetimeRandom.seed();
        }

        @BeforeEach
        void injectedPerClassBeforeEach() {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.lifetimeRandom);
        }

        @BeforeEach
        void initialisedPerClassBeforeEach() {
            RandomExtensionTest.assertInitialised(this.lifetimeRandom);
        }

        @BeforeEach
        void seedPerClassBeforeEach() {
            RandomExtensionTest.assertSeed(this.lifetimeRandom, this.firstSeed);
        }

        @Test
        void injectedPerClassTest() {
            RandomExtensionTest.assertInjected(this.lifetimeRandom);
            Assertions.assertThat((long)this.testCounter++).isEqualTo(1L);
        }

        @Test
        void initialisedPerClassTest() {
            RandomExtensionTest.assertInitialised(this.lifetimeRandom);
            Assertions.assertThat((long)this.testCounter++).isEqualTo(0L);
        }

        @Test
        void seedPerClassTest() {
            RandomExtensionTest.assertSeed(this.lifetimeRandom, this.firstSeed);
            Assertions.assertThat((long)this.testCounter++).isEqualTo(2L);
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    @RandomSupport.Seed(value=555L)
    class NestedPerClassWithSeedRandomTest {
        @Inject
        RandomSupport lifetimeRandom;

        NestedPerClassWithSeedRandomTest() {
        }

        @BeforeAll
        void assertPerClassWithSeedBeforeAll() {
            RandomExtensionTest.assertInjected(this.lifetimeRandom);
            RandomExtensionTest.assertInitialised(this.lifetimeRandom);
            RandomExtensionTest.assertSeed(this.lifetimeRandom, 555L);
        }

        @BeforeEach
        void seedPerClassWithSeedBeforeEach() {
            RandomExtensionTest.assertSeed(this.lifetimeRandom, 555L);
        }

        @Test
        void seedPerClassWithSeedTest() {
            RandomExtensionTest.assertSeed(this.lifetimeRandom, 555L);
        }
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class NestedPerClassRandomTest {
        @Inject
        RandomSupport lifetimeRandom;
        private long firstSeed;

        NestedPerClassRandomTest() {
        }

        @BeforeAll
        void assertPerClassBeforeAll() {
            RandomExtensionTest.assertInjected(this.lifetimeRandom);
            RandomExtensionTest.assertInitialised(this.lifetimeRandom);
            this.firstSeed = this.lifetimeRandom.seed();
        }

        @BeforeEach
        void injectedPerClassBeforeEach() {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)this.lifetimeRandom);
        }

        @BeforeEach
        void initialisedPerClassBeforeEach() {
            RandomExtensionTest.assertInitialised(this.lifetimeRandom);
        }

        @BeforeEach
        void seedPerClassBeforeEach() {
            RandomExtensionTest.assertSeed(this.lifetimeRandom, this.firstSeed);
        }

        @Test
        void injectedPerClassTest() {
            RandomExtensionTest.assertInjected(this.lifetimeRandom);
        }

        @Test
        void initialisedPerClassTest() {
            RandomExtensionTest.assertInitialised(this.lifetimeRandom);
        }

        @Test
        void seedPerClassTest() {
            RandomExtensionTest.assertSeed(this.lifetimeRandom, this.firstSeed);
        }
    }

    @Nested
    class NestedRandomTest {
        @Inject
        RandomSupport nestedRandom;

        NestedRandomTest() {
        }

        @BeforeEach
        void injectedNestedBeforeEach() {
            RandomExtensionTest.assertInjected(this.nestedRandom);
        }

        @BeforeEach
        void initialisedNestedBeforeEach() {
            RandomExtensionTest.assertInitialised(this.nestedRandom);
        }

        @Test
        void injectedNestedTest() {
            RandomExtensionTest.assertInjected(this.nestedRandom);
        }

        @Test
        void initialisedNestedTest() {
            RandomExtensionTest.assertInitialised(this.nestedRandom);
        }

        @Test
        @RandomSupport.Seed(value=15L)
        void seedNestedTest() {
            RandomExtensionTest.assertSeed(this.nestedRandom, 15L);
        }
    }
}

