/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

@ExtendWith(value={RandomExtension.class})
class ListValueFuzzTest {
    @Inject
    private RandomSupport random;
    private static final int ITERATIONS = 1000;

    ListValueFuzzTest() {
    }

    @Test
    void shouldBeStorableIfAppendToStorableWithCompatibleTypes() {
        for (int i = 0; i < 1000; ++i) {
            for (ValueType valueType : ValueType.arrayTypes()) {
                ArrayValue arrayValue = (ArrayValue)this.random.nextValue(valueType);
                ListValue.ArrayValueListValue inner = VirtualValues.fromArray((ArrayValue)arrayValue);
                ListValue.AppendList appended = inner.append((AnyValue)this.nextCompatible(arrayValue));
                Assertions.assertEquals((Object)appended, (Object)VirtualValues.fromArray((ArrayValue)appended.toStorableArray()));
            }
        }
    }

    @Test
    void shouldNotBeStorableIfAppendToStorableWithIncompatibleTypes() {
        for (int i = 0; i < 1000; ++i) {
            for (ValueType valueType : ValueType.arrayTypes()) {
                ArrayValue arrayValue = (ArrayValue)this.random.nextValue(valueType);
                ListValue.ArrayValueListValue inner = VirtualValues.fromArray((ArrayValue)arrayValue);
                ListValue.AppendList appended = inner.append((AnyValue)this.nextIncompatible(arrayValue));
                Assertions.assertThrows(CypherTypeException.class, () -> ((ListValue)appended).toStorableArray());
            }
        }
    }

    @Test
    void shouldBeStorableIfPrependToStorableWithCompatibleTypes() {
        for (int i = 0; i < 1000; ++i) {
            for (ValueType valueType : ValueType.arrayTypes()) {
                ArrayValue arrayValue = (ArrayValue)this.random.nextValue(valueType);
                ListValue.ArrayValueListValue inner = VirtualValues.fromArray((ArrayValue)arrayValue);
                ListValue prepended = inner.prepend((AnyValue)this.nextCompatible(arrayValue));
                Assertions.assertEquals((Object)prepended, (Object)VirtualValues.fromArray((ArrayValue)prepended.toStorableArray()));
            }
        }
    }

    @Test
    void shouldNotBeStorableIfPrependToStorableWithIncompatibleTypes() {
        for (int i = 0; i < 1000; ++i) {
            for (ValueType valueType : ValueType.arrayTypes()) {
                ArrayValue arrayValue = (ArrayValue)this.random.nextValue(valueType);
                ListValue.ArrayValueListValue inner = VirtualValues.fromArray((ArrayValue)arrayValue);
                ListValue prepended = inner.prepend((AnyValue)this.nextIncompatible(arrayValue));
                Assertions.assertThrows(CypherTypeException.class, () -> ((ListValue)prepended).toStorableArray());
            }
        }
    }

    @Test
    void shouldCreateStorableLists() {
        for (int i = 0; i < 1000; ++i) {
            boolean seenStorable = false;
            boolean seenNonStorable = false;
            for (ValueType valueType : ValueType.values()) {
                ListValue list;
                Value value = this.random.nextValue(valueType);
                if (value.valueRepresentation().canCreateArrayOfValueGroup()) {
                    list = VirtualValues.list((AnyValue[])new AnyValue[]{value, value, value});
                    Assertions.assertEquals((Object)list, (Object)VirtualValues.fromArray((ArrayValue)list.toStorableArray()));
                    seenStorable = true;
                    continue;
                }
                list = VirtualValues.list((AnyValue[])new AnyValue[]{value, value, value});
                Assertions.assertThrows(CypherTypeException.class, () -> ((ListValue)list).toStorableArray());
                seenNonStorable = true;
            }
            Assertions.assertTrue((boolean)seenStorable);
            Assertions.assertTrue((boolean)seenNonStorable);
        }
    }

    private Value nextCompatible(ArrayValue value) {
        Value nextValue;
        ValueType[] types = ValueType.values();
        while (!value.hasCompatibleType((AnyValue)(nextValue = this.random.nextValue(types[this.random.nextInt(types.length)])))) {
        }
        return nextValue;
    }

    private Value nextIncompatible(ArrayValue value) {
        Value nextValue;
        ValueType[] types = ValueType.values();
        do {
            nextValue = this.random.nextValue(types[this.random.nextInt(types.length)]);
            if (!value.isEmpty()) continue;
            return nextValue;
        } while (value.value(0).valueRepresentation().coerce(nextValue.valueRepresentation()).canCreateArrayOfValueGroup());
        return nextValue;
    }
}

