/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class TextValueFuzzTest {
    @Inject
    private RandomSupport random;
    private static final int ITERATIONS = 1000;

    TextValueFuzzTest() {
    }

    @Test
    void shouldCompareToForAllStringsInBasicMultilingualPlane() {
        for (int i = 0; i < 1000; ++i) {
            this.assertConsistent(this.random.nextBasicMultilingualPlaneString(), this.random.nextBasicMultilingualPlaneString(), (t1, t2) -> Float.valueOf(Math.signum(t1.compareTo(t2))));
        }
    }

    @Test
    void shouldAdd() {
        for (int i = 0; i < 1000; ++i) {
            this.assertConsistent(this.random.nextString(), this.random.nextString(), TextValue::plus);
        }
    }

    @Test
    void shouldComputeLength() {
        for (int i = 0; i < 1000; ++i) {
            this.assertConsistent(this.random.nextString(), TextValue::length);
        }
    }

    @Test
    void shouldComputeIsEmpty() {
        for (int i = 0; i < 1000; ++i) {
            this.assertConsistent(this.random.nextString(), TextValue::isEmpty);
        }
    }

    @Test
    void shouldReverse() {
        for (int i = 0; i < 1000; ++i) {
            this.assertConsistent(this.random.nextString(), TextValue::reverse);
        }
    }

    @Test
    void shouldTrim() {
        for (int i = 0; i < 1000; ++i) {
            this.assertConsistent(this.random.nextString(), TextValue::trim);
        }
    }

    @Test
    void shouldSubstring() {
        for (int i = 0; i < 1000; ++i) {
            String randomString = this.random.nextString();
            int stringLength = randomString.length();
            int start = this.random.nextInt(stringLength);
            int length = this.random.nextInt(stringLength - start);
            this.assertConsistent(randomString, value -> value.substring(start, length));
        }
    }

    @Test
    void shouldHandleStringPredicates() {
        for (int i = 0; i < 1000; ++i) {
            String value = this.random.nextString();
            String other = this.random.nextBoolean() ? value : this.random.nextString();
            this.assertConsistent(value, other, TextValue::startsWith);
            this.assertConsistent(value, other, TextValue::endsWith);
            this.assertConsistent(value, other, TextValue::contains);
        }
    }

    private <T> void assertConsistent(String string, Function<TextValue, T> test) {
        byte[] utf8Bytes = string.getBytes(StandardCharsets.UTF_8);
        TextValue textValue = Values.stringValue((String)string);
        TextValue utf8Value = Values.utf8Value((byte[])utf8Bytes);
        TextValue utf8Substring = this.randomUTF8SubstringEqualTo(string);
        T a = test.apply(textValue);
        T b = test.apply(utf8Value);
        T c = test.apply(utf8Substring);
        String errorMsg = String.format("operation not consistent for %s", string);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(b);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(c);
        ((ObjectAssert)Assertions.assertThat(b).as(errorMsg, new Object[0])).isEqualTo(a);
        ((ObjectAssert)Assertions.assertThat(b).as(errorMsg, new Object[0])).isEqualTo(c);
        ((ObjectAssert)Assertions.assertThat(c).as(errorMsg, new Object[0])).isEqualTo(a);
        ((ObjectAssert)Assertions.assertThat(c).as(errorMsg, new Object[0])).isEqualTo(b);
    }

    private <T> void assertConsistent(String string1, String string2, BiFunction<TextValue, TextValue, T> test) {
        TextValue textValue1 = Values.stringValue((String)string1);
        TextValue textValue2 = Values.stringValue((String)string2);
        TextValue utf8Value1 = Values.utf8Value((byte[])string1.getBytes(StandardCharsets.UTF_8));
        TextValue utf8Value2 = Values.utf8Value((byte[])string2.getBytes(StandardCharsets.UTF_8));
        TextValue utf8Substring1 = this.randomUTF8SubstringEqualTo(string1);
        TextValue utf8Substring2 = this.randomUTF8SubstringEqualTo(string2);
        T a = test.apply(textValue1, textValue2);
        T b = test.apply(textValue1, utf8Value2);
        T c = test.apply(utf8Value1, textValue2);
        T d = test.apply(utf8Value1, utf8Value2);
        T e = test.apply(utf8Substring1, utf8Substring2);
        T f = test.apply(utf8Substring1, utf8Value2);
        String errorMsg = String.format("operation not consistent for `%s` and `%s`", string1, string2);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(b);
        ((ObjectAssert)Assertions.assertThat(b).as(errorMsg, new Object[0])).isEqualTo(a);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(c);
        ((ObjectAssert)Assertions.assertThat(c).as(errorMsg, new Object[0])).isEqualTo(a);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(d);
        ((ObjectAssert)Assertions.assertThat(d).as(errorMsg, new Object[0])).isEqualTo(a);
        ((ObjectAssert)Assertions.assertThat(e).as(errorMsg, new Object[0])).isEqualTo(a);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(e);
        ((ObjectAssert)Assertions.assertThat(f).as(errorMsg, new Object[0])).isEqualTo(a);
        ((ObjectAssert)Assertions.assertThat(a).as(errorMsg, new Object[0])).isEqualTo(f);
    }

    private TextValue randomUTF8SubstringEqualTo(String string) {
        byte[] utf8Bytes = string.getBytes(StandardCharsets.UTF_8);
        byte[] prefix = this.random.nextString().getBytes(StandardCharsets.UTF_8);
        byte[] suffix = this.random.nextString().getBytes(StandardCharsets.UTF_8);
        byte[] substringBytes = Arrays.copyOf(prefix, prefix.length + utf8Bytes.length + suffix.length);
        System.arraycopy(utf8Bytes, 0, substringBytes, prefix.length, utf8Bytes.length);
        System.arraycopy(suffix, 0, substringBytes, prefix.length + utf8Bytes.length, suffix.length);
        return Values.utf8Value((byte[])substringBytes, (int)prefix.length, (int)utf8Bytes.length);
    }
}

