/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.UTF8StringValueTest;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
class UTF8StringValueRandomTest {
    @Inject
    RandomSupport random;

    UTF8StringValueRandomTest() {
    }

    @Test
    void shouldCompareToRandomAlphanumericString() {
        for (int i = 0; i < 100; ++i) {
            String string1 = this.random.nextAlphaNumericString();
            String string2 = this.random.nextAlphaNumericString();
            UTF8StringValueTest.assertCompareTo((String)string1, (String)string2);
        }
    }

    @Test
    void shouldCompareToAsciiString() {
        for (int i = 0; i < 100; ++i) {
            String string1 = this.random.nextAsciiString();
            String string2 = this.random.nextAsciiString();
            UTF8StringValueTest.assertCompareTo((String)string1, (String)string2);
        }
    }

    @Test
    void shouldCompareBasicMultilingualPlaneString() {
        for (int i = 0; i < 100; ++i) {
            String string1 = this.random.nextBasicMultilingualPlaneString();
            String string2 = this.random.nextBasicMultilingualPlaneString();
            UTF8StringValueTest.assertCompareTo((String)string1, (String)string2);
        }
    }

    @Test
    void trimTest() {
        for (int i = 0; i < 10000; ++i) {
            String string = this.random.nextString();
            int[] originalStringCodepoints = string.codePoints().toArray();
            if (string.length() <= 1) continue;
            TextValue utf8StringValue = Values.utf8Value((String)string);
            TextValue stringWrappingValue = Values.stringValue((String)string);
            int from = this.random.nextInt(string.length() - 1);
            int length = this.random.nextInt(string.length() - from);
            String trim = new String(new int[]{this.random.among(originalStringCodepoints)}, 0, 1);
            TextValue trimA = Values.utf8Value((String)trim);
            TextValue trimB = Values.stringValue((String)trim);
            TextValue utfString = utf8StringValue.substring(from, length);
            TextValue wrappedString = stringWrappingValue.substring(from, length);
            TextValue resultA = utfString.trim(trimA);
            TextValue resultB = utfString.trim(trimB);
            TextValue resultC = wrappedString.trim(trimA);
            TextValue resultD = wrappedString.trim(trimB);
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)resultA).describedAs("trimA=%s, trimB=%s, results: %s, %s, %s, %s", new Object[]{trimA, trimB, resultA, resultB, resultC, resultD})).isEqualTo((Object)resultB)).isEqualTo((Object)resultC)).isEqualTo((Object)resultD);
        }
    }
}

