/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.neo4j.cypher.internal.v3_5.rewriting

import org.neo4j.cypher.internal.v3_5.util.Rewriter

object RewriterStep {
   implicit def namedProductRewriter(p: Product with Rewriter): ApplyRewriter = ApplyRewriter(p.productPrefix, p)

   def enableCondition(p: Condition) = EnableRewriterCondition(RewriterCondition(p.name, p))
   def disableCondition(p: Condition) = DisableRewriterCondition(RewriterCondition(p.name, p))
 }

sealed trait RewriterStep
final case class ApplyRewriter(name: String, rewriter: Rewriter) extends RewriterStep
final case class EnableRewriterCondition(cond: RewriterCondition) extends RewriterStep
final case class DisableRewriterCondition(cond: RewriterCondition) extends RewriterStep

trait Condition extends (Any => Seq[String]) {
   def name: String
}
