/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.ProcedureConfig;

public class ProcedureConfigTest {
    private static final String[] EMPTY = new String[0];

    private static String[] arrayOf(String ... values) {
        return values;
    }

    @Test
    public void shouldHaveEmptyDefaultConfigs() {
        Config config = Config.defaults();
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("x"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
    }

    @Test
    public void shouldHaveConfigsWithDefaultProcedureAllowed() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", "role1"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("x"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("role1")));
    }

    @Test
    public void shouldHaveConfigsWithExactMatchProcedureAllowed() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", "role1", "dbms.security.procedures.roles", "xyz:anotherRole"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyz"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("anotherRole")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("role1")));
    }

    @Test
    public void shouldNotFailOnEmptyStringDefaultName() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", ""}));
        new ProcedureConfig(config);
    }

    @Test
    public void shouldNotFailOnEmptyStringRoles() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.roles", ""}));
        new ProcedureConfig(config);
    }

    @Test
    public void shouldNotFailOnBadStringRoles() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.roles", "matrix"}));
        new ProcedureConfig(config);
    }

    @Test
    public void shouldNotFailOnEmptyStringBoth() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", "", "dbms.security.procedures.roles", ""}));
        new ProcedureConfig(config);
    }

    @Test
    public void shouldHaveConfigsWithWildcardProcedureAllowed() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", "role1", "dbms.security.procedures.roles", "xyz*:anotherRole"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("anotherRole")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abcxyz"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("role1")));
    }

    @Test
    public void shouldHaveConfigsWithWildcardProcedureAllowedAndNoDefault() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.roles", "xyz*:anotherRole"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("anotherRole")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abcxyz"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
    }

    @Test
    public void shouldHaveConfigsWithMultipleWildcardProcedureAllowedAndNoDefault() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.roles", "apoc.convert.*:apoc_reader;apoc.load.json:apoc_writer;apoc.trigger.add:TriggerHappy"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyz"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.convert.xml"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("apoc_reader")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.convert.json"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("apoc_reader")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load.xml"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load.json"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("apoc_writer")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.trigger.add"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("TriggerHappy")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.convert-json"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load-xml"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load-json"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.trigger-add"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
    }

    @Test
    public void shouldHaveConfigsWithOverlappingMatchingWildcards() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.default_allowed", "default", "dbms.security.procedures.roles", "apoc.*:apoc;apoc.load.*:loader;apoc.trigger.*:trigger;apoc.trigger.add:TriggerHappy"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyz"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("default")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.convert.xml"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("apoc")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load.xml"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("apoc", "loader")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.trigger.add"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("apoc", "trigger", "TriggerHappy")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.trigger.remove"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("apoc", "trigger")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("apoc.load-xml"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("apoc")));
    }

    @Test
    public void shouldSupportSeveralRolesPerPattern() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{"dbms.security.procedures.roles", "xyz*:role1,role2,  role3  ,    role4   ;    abc:  role3   ,role1"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.rolesFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("role1", "role2", "role3", "role4")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abc"), (Matcher)CoreMatchers.equalTo((Object)ProcedureConfigTest.arrayOf("role3", "role1")));
        MatcherAssert.assertThat((Object)procConfig.rolesFor("abcxyz"), (Matcher)CoreMatchers.equalTo((Object)EMPTY));
    }

    @Test
    public void shouldNotAllowFullAccessDefault() {
        Config config = Config.defaults();
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("x"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldAllowFullAccessForProcedures() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_unrestricted.name(), "test.procedure.name"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test.procedure.name"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldAllowFullAccessForSeveralProcedures() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_unrestricted.name(), "test.procedure.name, test.procedure.otherName"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test.procedure.name"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test.procedure.otherName"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldAllowFullAcsessForSeveralProceduresOddNames() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_unrestricted.name(), "test\\.procedure.name, test*rocedure.otherName"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test\\.procedure.name"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test*procedure.otherName"), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldAllowFullAccessWildcardProceduresNames() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_unrestricted.name(), " test.procedure.*  ,     test.*.otherName"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test.procedure.name"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test.procedure.otherName"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test.other.otherName"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test.other.cool.otherName"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.fullAccessFor("test.other.name"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldBlockWithWhiteListingForProcedures() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_unrestricted.name(), "test.procedure.name, test.procedure.name2", GraphDatabaseSettings.procedure_whitelist.name(), "test.procedure.name"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("test.procedure.name"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("test.procedure.name2"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldAllowWhiteListsWildcardProceduresNames() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), " test.procedure.* ,  test.*.otherName"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("xyzabc"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("test.procedure.name"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("test.procedure.otherName"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("test.other.otherName"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("test.other.cool.otherName"), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("test.other.name"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldIgnoreOddRegex() {
        Config config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "[\\db^a]*"}));
        ProcedureConfig procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("123"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("b"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("a"), (Matcher)CoreMatchers.equalTo((Object)false));
        config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "(abc)"}));
        procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("(abc)"), (Matcher)CoreMatchers.equalTo((Object)true));
        config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "^$"}));
        procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("^$"), (Matcher)CoreMatchers.equalTo((Object)true));
        config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "\\"}));
        procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("\\"), (Matcher)CoreMatchers.equalTo((Object)true));
        config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "&&"}));
        procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("&&"), (Matcher)CoreMatchers.equalTo((Object)true));
        config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "\\p{Lower}"}));
        procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("a"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("\\p{Lower}"), (Matcher)CoreMatchers.equalTo((Object)true));
        config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "a+"}));
        procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("aaaaaa"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("a+"), (Matcher)CoreMatchers.equalTo((Object)true));
        config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "a|b"}));
        procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("a"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("b"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("|"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("a|b"), (Matcher)CoreMatchers.equalTo((Object)true));
        config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "[a-c]"}));
        procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("a"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("b"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("c"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("-"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("[a-c]"), (Matcher)CoreMatchers.equalTo((Object)true));
        config = Config.defaults().with(MapUtil.genericMap((Object[])new Object[]{GraphDatabaseSettings.procedure_whitelist.name(), "a\tb"}));
        procConfig = new ProcedureConfig(config);
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("a    b"), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)procConfig.isWhitelisted("a\tb"), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

