/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Map;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.server.security.enterprise.auth.ProcedureInteractionTestBase;
import org.neo4j.test.DoubleLatch;

public abstract class AuthProceduresInteractionTestBase<S>
extends ProcedureInteractionTestBase<S> {
    private static final String PWD_CHANGE = AuthenticationResult.PASSWORD_CHANGE_REQUIRED.name().toLowerCase();

    @Test
    public void shouldHaveDescriptionsOnAllSecurityProcedures() throws Throwable {
        this.assertSuccess(this.readSubject, "CALL dbms.procedures", r -> {
            Stream<Map> securityProcedures = r.stream().filter(s -> {
                String name = s.get("name").toString();
                String description = s.get("description").toString();
                if (name.contains("dbms.security") && !name.contains("Transaction") && !name.contains("Connection")) {
                    MatcherAssert.assertThat((String)("Description for '" + name + "' should not be empty"), (Object)description.trim().length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                    return true;
                }
                return false;
            });
            MatcherAssert.assertThat((Object)securityProcedures.count(), (Matcher)Matchers.equalTo((Object)16L));
        });
    }

    @Test
    public void shouldChangeOwnPassword() throws Throwable {
        this.assertEmpty(this.readSubject, "CALL dbms.security.changePassword( '321' )");
        this.neo.updateAuthToken(this.readSubject, "readSubject", "321");
        this.neo.assertAuthenticated(this.readSubject);
        this.testSuccessfulRead(this.readSubject, 3);
    }

    @Test
    public void shouldChangeOwnPasswordEvenIfHasNoAuthorization() throws Throwable {
        this.neo.assertAuthenticated(this.noneSubject);
        this.assertEmpty(this.noneSubject, "CALL dbms.security.changePassword( '321' )");
        this.neo.updateAuthToken(this.noneSubject, "noneSubject", "321");
        this.neo.assertAuthenticated(this.noneSubject);
    }

    @Test
    public void shouldNotChangeOwnPasswordIfNewPasswordInvalid() throws Exception {
        this.assertFail(this.readSubject, "CALL dbms.security.changePassword( '' )", "A password cannot be empty.");
        this.assertFail(this.readSubject, "CALL dbms.security.changePassword( '123' )", "Old password and new password cannot be the same.");
    }

    @Test
    public void shouldChangeUserPassword() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.changeUserPassword( 'readSubject', '321', false )");
        this.neo.assertInitFailed(this.neo.login("readSubject", "123"));
        this.neo.assertAuthenticated(this.neo.login("readSubject", "321"));
    }

    @Test
    public void shouldChangeUserPasswordAndRequirePasswordChangeOnNextLoginByDefault() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.changeUserPassword( 'readSubject', '321' )");
        this.neo.assertInitFailed(this.neo.login("readSubject", "123"));
        this.neo.assertPasswordChangeRequired(this.neo.login("readSubject", "321"));
    }

    @Test
    public void shouldChangeUserPasswordAndRequirePasswordChangeOnNextLoginOnRequest() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.changeUserPassword( 'readSubject', '321', true )");
        this.neo.assertInitFailed(this.neo.login("readSubject", "123"));
        this.neo.assertPasswordChangeRequired(this.neo.login("readSubject", "321"));
    }

    @Test
    public void shouldNotChangeUserPasswordIfNotAdmin() throws Exception {
        this.assertFail(this.schemaSubject, "CALL dbms.security.changeUserPassword( 'readSubject', '321' )", "Permission denied.");
        this.assertFail(this.schemaSubject, "CALL dbms.security.changeUserPassword( 'jake', '321' )", "Permission denied.");
        this.assertFail(this.schemaSubject, "CALL dbms.security.changeUserPassword( 'readSubject', '' )", "Permission denied.");
    }

    @Test
    public void shouldChangeUserPasswordIfSameUser() throws Throwable {
        this.assertEmpty(this.readSubject, "CALL dbms.security.changeUserPassword( 'readSubject', '321', false )");
        this.neo.updateAuthToken(this.readSubject, "readSubject", "321");
        this.neo.assertAuthenticated(this.readSubject);
        this.testSuccessfulRead(this.readSubject, 3);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.changeUserPassword( 'adminSubject', 'cba', false )");
        this.neo.updateAuthToken(this.adminSubject, "adminSubject", "cba");
        this.neo.assertAuthenticated(this.adminSubject);
        this.testSuccessfulRead(this.adminSubject, 3);
    }

    @Test
    public void shouldFailToChangeUserPasswordIfSameUserButInvalidPassword() throws Exception {
        this.assertFail(this.readSubject, "CALL dbms.security.changeUserPassword( 'readSubject', '123' )", "Old password and new password cannot be the same.");
        this.assertFail(this.adminSubject, "CALL dbms.security.changeUserPassword( 'adminSubject', 'abc' )", "Old password and new password cannot be the same.");
    }

    @Test
    public void shouldNotChangeUserPasswordIfNonExistentUser() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.changeUserPassword( 'jake', '321' )", "User 'jake' does not exist.");
    }

    @Test
    public void shouldNotChangeUserPasswordIfEmptyPassword() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.changeUserPassword( 'readSubject', '' )", "A password cannot be empty.");
    }

    @Test
    public void shouldNotChangeUserPasswordIfSamePassword() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.changeUserPassword( 'readSubject', '123' )", "Old password and new password cannot be the same.");
    }

    @Test
    public void shouldCreateUserAndRequirePasswordChangeByDefault() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('craig', '1234' )");
        this.userManager.getUser("craig");
        this.neo.assertInitFailed(this.neo.login("craig", "321"));
        this.neo.assertPasswordChangeRequired(this.neo.login("craig", "1234"));
    }

    @Test
    public void shouldCreateUserAndRequirePasswordChangeIfRequested() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('craig', '1234', true)");
        this.userManager.getUser("craig");
        this.neo.assertInitFailed(this.neo.login("craig", "321"));
        this.neo.assertPasswordChangeRequired(this.neo.login("craig", "1234"));
    }

    @Test
    public void shouldCreateUserAndRequireNoPasswordChangeIfRequested() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('craig', '1234', false)");
        this.userManager.getUser("craig");
        this.neo.assertAuthenticated(this.neo.login("craig", "1234"));
    }

    @Test
    public void shouldNotCreateUserIfInvalidUsername() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.createUser(null, '1234', true)", "The provided username is empty.");
        this.assertFail(this.adminSubject, "CALL dbms.security.createUser('', '1234', true)", "The provided username is empty.");
        this.assertFail(this.adminSubject, "CALL dbms.security.createUser(',ss!', '1234', true)", "Username ',ss!' contains illegal characters.");
        this.assertFail(this.adminSubject, "CALL dbms.security.createUser(',ss!', '', true)", "Username ',ss!' contains illegal characters.");
    }

    @Test
    public void shouldNotCreateUserIfInvalidPassword() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.createUser('craig', '', true)", "A password cannot be empty.");
        this.assertFail(this.adminSubject, "CALL dbms.security.createUser('craig', null, true)", "A password cannot be empty.");
    }

    @Test
    public void shouldNotCreateExistingUser() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.createUser('readSubject', '1234', true)", "The specified user 'readSubject' already exists");
        this.assertFail(this.adminSubject, "CALL dbms.security.createUser('readSubject', '', true)", "A password cannot be empty.");
    }

    @Test
    public void shouldNotAllowNonAdminCreateUser() throws Exception {
        this.testFailCreateUser(this.pwdSubject, this.CHANGE_PWD_ERR_MSG);
        this.testFailCreateUser(this.readSubject, "Permission denied.");
        this.testFailCreateUser(this.writeSubject, "Permission denied.");
        this.testFailCreateUser(this.schemaSubject, "Permission denied.");
    }

    @Test
    public void shouldDeleteUser() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteUser('noneSubject')");
        try {
            this.userManager.getUser("noneSubject");
            Assert.fail((String)"User noneSubject should not exist");
        }
        catch (InvalidArgumentsException e) {
            Assert.assertTrue((String)"User noneSubject should not exist", (boolean)e.getMessage().contains("User 'noneSubject' does not exist."));
        }
        this.userManager.addRoleToUser("publisher", "readSubject");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteUser('readSubject')");
        try {
            this.userManager.getUser("readSubject");
            Assert.fail((String)"User readSubject should not exist");
        }
        catch (InvalidArgumentsException e) {
            Assert.assertTrue((String)"User readSubject should not exist", (boolean)e.getMessage().contains("User 'readSubject' does not exist."));
        }
        Assert.assertFalse((boolean)this.userManager.getUsernamesForRole("reader").contains("readSubject"));
        Assert.assertFalse((boolean)this.userManager.getUsernamesForRole("publisher").contains("readSubject"));
    }

    @Test
    public void shouldNotDeleteUserIfNotAdmin() throws Exception {
        this.testFailDeleteUser(this.pwdSubject, "readSubject", this.CHANGE_PWD_ERR_MSG);
        this.testFailDeleteUser(this.readSubject, "readSubject", "Permission denied.");
        this.testFailDeleteUser(this.writeSubject, "readSubject", "Permission denied.");
        this.testFailDeleteUser(this.schemaSubject, "readSubject", "Permission denied.");
        this.testFailDeleteUser(this.schemaSubject, "Craig", "Permission denied.");
        this.testFailDeleteUser(this.schemaSubject, "", "Permission denied.");
    }

    @Test
    public void shouldNotAllowDeletingNonExistentUser() throws Exception {
        this.testFailDeleteUser(this.adminSubject, "Craig", "User 'Craig' does not exist.");
        this.testFailDeleteUser(this.adminSubject, "", "User '' does not exist.");
    }

    @Test
    public void shouldNotAllowDeletingYourself() throws Exception {
        this.testFailDeleteUser(this.adminSubject, "adminSubject", "Deleting yourself (user 'adminSubject') is not allowed.");
    }

    @Test
    public void shouldTerminateTransactionsOnUserDeletion() throws Throwable {
        this.shouldTerminateTransactionsForUser(this.writeSubject, "dbms.security.deleteUser( '%s' )");
    }

    @Test
    public void shouldTerminateConnectionsOnUserDeletion() throws Exception {
        TransportConnection conn = this.startBoltSession("writeSubject", "abc");
        Map<String, Long> boltConnections = this.countBoltConnectionsByUsername();
        MatcherAssert.assertThat((Object)boltConnections.get("writeSubject"), (Matcher)Matchers.equalTo((Object)(this.IS_BOLT ? 2L : 1L)));
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteUser( 'writeSubject' )");
        boltConnections = this.countBoltConnectionsByUsername();
        MatcherAssert.assertThat((Object)boltConnections.get("writeSubject"), (Matcher)Matchers.equalTo(null));
        conn.disconnect();
    }

    @Test
    public void shouldSuspendUser() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.suspendUser('readSubject')");
        Assert.assertTrue((boolean)this.userManager.getUser("readSubject").hasFlag("is_suspended"));
    }

    @Test
    public void shouldSuspendSuspendedUser() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.suspendUser('readSubject')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.suspendUser('readSubject')");
        Assert.assertTrue((boolean)this.userManager.getUser("readSubject").hasFlag("is_suspended"));
    }

    @Test
    public void shouldFailToSuspendNonExistentUser() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.suspendUser('Craig')", "User 'Craig' does not exist.");
    }

    @Test
    public void shouldFailToSuspendIfNotAdmin() throws Exception {
        this.assertFail(this.schemaSubject, "CALL dbms.security.suspendUser('readSubject')", "Permission denied.");
        this.assertFail(this.schemaSubject, "CALL dbms.security.suspendUser('Craig')", "Permission denied.");
        this.assertFail(this.schemaSubject, "CALL dbms.security.suspendUser('')", "Permission denied.");
    }

    @Test
    public void shouldFailToSuspendYourself() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.suspendUser('adminSubject')", "Suspending yourself (user 'adminSubject') is not allowed.");
    }

    @Test
    public void shouldTerminateTransactionsOnUserSuspension() throws Throwable {
        this.shouldTerminateTransactionsForUser(this.writeSubject, "dbms.security.suspendUser( '%s' )");
    }

    @Test
    public void shouldTerminateConnectionsOnUserSuspension() throws Exception {
        TransportConnection conn = this.startBoltSession("writeSubject", "abc");
        Map<String, Long> boltConnections = this.countBoltConnectionsByUsername();
        MatcherAssert.assertThat((Object)boltConnections.get("writeSubject"), (Matcher)Matchers.equalTo((Object)(this.IS_BOLT ? 2L : 1L)));
        this.assertEmpty(this.adminSubject, "CALL dbms.security.suspendUser( 'writeSubject' )");
        boltConnections = this.countBoltConnectionsByUsername();
        MatcherAssert.assertThat((Object)boltConnections.get("writeSubject"), (Matcher)Matchers.equalTo(null));
        conn.disconnect();
    }

    @Test
    public void shouldActivateUserAndRequirePasswordChangeByDefault() throws Exception {
        this.userManager.suspendUser("readSubject");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.activateUser('readSubject')");
        this.neo.assertInitFailed(this.neo.login("readSubject", "321"));
        this.neo.assertPasswordChangeRequired(this.neo.login("readSubject", "123"));
        Assert.assertFalse((boolean)this.userManager.getUser("readSubject").hasFlag("is_suspended"));
    }

    @Test
    public void shouldActivateUserAndRequirePasswordChangeIfRequested() throws Exception {
        this.userManager.suspendUser("readSubject");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.activateUser('readSubject', true)");
        this.neo.assertInitFailed(this.neo.login("readSubject", "321"));
        this.neo.assertPasswordChangeRequired(this.neo.login("readSubject", "123"));
        Assert.assertFalse((boolean)this.userManager.getUser("readSubject").hasFlag("is_suspended"));
    }

    @Test
    public void shouldActivateUserAndRequireNoPasswordChangeIfRequested() throws Exception {
        this.userManager.suspendUser("readSubject");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.activateUser('readSubject', false)");
        Assert.assertFalse((boolean)this.userManager.getUser("readSubject").hasFlag("is_suspended"));
    }

    @Test
    public void shouldActivateActiveUser() throws Exception {
        this.userManager.suspendUser("readSubject");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.activateUser('readSubject')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.activateUser('readSubject')");
        Assert.assertFalse((boolean)this.userManager.getUser("readSubject").hasFlag("is_suspended"));
    }

    @Test
    public void shouldFailToActivateNonExistentUser() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.activateUser('Craig')", "User 'Craig' does not exist.");
    }

    @Test
    public void shouldFailToActivateIfNotAdmin() throws Exception {
        this.userManager.suspendUser("readSubject");
        this.assertFail(this.schemaSubject, "CALL dbms.security.activateUser('readSubject')", "Permission denied.");
        this.assertFail(this.schemaSubject, "CALL dbms.security.activateUser('Craig')", "Permission denied.");
        this.assertFail(this.schemaSubject, "CALL dbms.security.activateUser('')", "Permission denied.");
    }

    @Test
    public void shouldFailToActivateYourself() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.activateUser('adminSubject')", "Activating yourself (user 'adminSubject') is not allowed.");
    }

    @Test
    public void shouldAddRoleToUser() throws Exception {
        Assert.assertFalse((String)"Should not have role publisher", (boolean)this.userHasRole("readSubject", "publisher"));
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'readSubject' )");
        Assert.assertTrue((String)"Should have role publisher", (boolean)this.userHasRole("readSubject", "publisher"));
    }

    @Test
    public void shouldAddRetainUserInRole() throws Exception {
        Assert.assertTrue((String)"Should have role reader", (boolean)this.userHasRole("readSubject", "reader"));
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'readSubject')");
        Assert.assertTrue((String)"Should have still have role reader", (boolean)this.userHasRole("readSubject", "reader"));
    }

    @Test
    public void shouldFailToAddNonExistentUserToRole() throws Exception {
        this.testFailAddRoleToUser(this.adminSubject, "publisher", "Olivia", "User 'Olivia' does not exist.");
        this.testFailAddRoleToUser(this.adminSubject, "thisRoleDoesNotExist", "Olivia", "User 'Olivia' does not exist.");
        this.testFailAddRoleToUser(this.adminSubject, "", "Olivia", "The provided role name is empty.");
    }

    @Test
    public void shouldFailToAddUserToNonExistentRole() throws Exception {
        this.testFailAddRoleToUser(this.adminSubject, "thisRoleDoesNotExist", "readSubject", "Role 'thisRoleDoesNotExist' does not exist.");
        this.testFailAddRoleToUser(this.adminSubject, "", "readSubject", "The provided role name is empty.");
    }

    @Test
    public void shouldFailToAddRoleToUserIfNotAdmin() throws Exception {
        this.testFailAddRoleToUser(this.pwdSubject, "publisher", "readSubject", this.CHANGE_PWD_ERR_MSG);
        this.testFailAddRoleToUser(this.readSubject, "publisher", "readSubject", "Permission denied.");
        this.testFailAddRoleToUser(this.writeSubject, "publisher", "readSubject", "Permission denied.");
        this.testFailAddRoleToUser(this.schemaSubject, "publisher", "readSubject", "Permission denied.");
        this.testFailAddRoleToUser(this.schemaSubject, "publisher", "Olivia", "Permission denied.");
        this.testFailAddRoleToUser(this.schemaSubject, "thisRoleDoesNotExist", "Olivia", "Permission denied.");
    }

    @Test
    public void shouldRemoveRoleFromUser() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('reader', 'readSubject')");
        Assert.assertFalse((String)"Should not have role reader", (boolean)this.userHasRole("readSubject", "reader"));
    }

    @Test
    public void shouldKeepUserOutOfRole() throws Exception {
        Assert.assertFalse((String)"Should not have role publisher", (boolean)this.userHasRole("readSubject", "publisher"));
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('publisher', 'readSubject')");
        Assert.assertFalse((String)"Should not have role publisher", (boolean)this.userHasRole("readSubject", "publisher"));
    }

    @Test
    public void shouldFailToRemoveNonExistentUserFromRole() throws Exception {
        this.testFailRemoveRoleFromUser(this.adminSubject, "publisher", "Olivia", "User 'Olivia' does not exist.");
        this.testFailRemoveRoleFromUser(this.adminSubject, "thisRoleDoesNotExist", "Olivia", "User 'Olivia' does not exist.");
        this.testFailRemoveRoleFromUser(this.adminSubject, "", "Olivia", "The provided role name is empty.");
        this.testFailRemoveRoleFromUser(this.adminSubject, "", "", "The provided role name is empty.");
        this.testFailRemoveRoleFromUser(this.adminSubject, "publisher", "", "The provided username is empty.");
    }

    @Test
    public void shouldFailToRemoveUserFromNonExistentRole() throws Exception {
        this.testFailRemoveRoleFromUser(this.adminSubject, "thisRoleDoesNotExist", "readSubject", "Role 'thisRoleDoesNotExist' does not exist.");
        this.testFailRemoveRoleFromUser(this.adminSubject, "", "readSubject", "The provided role name is empty.");
    }

    @Test
    public void shouldFailToRemoveRoleFromUserIfNotAdmin() throws Exception {
        this.testFailRemoveRoleFromUser(this.pwdSubject, "publisher", "readSubject", this.CHANGE_PWD_ERR_MSG);
        this.testFailRemoveRoleFromUser(this.readSubject, "publisher", "readSubject", "Permission denied.");
        this.testFailRemoveRoleFromUser(this.writeSubject, "publisher", "readSubject", "Permission denied.");
        this.testFailRemoveRoleFromUser(this.schemaSubject, "reader", "readSubject", "Permission denied.");
        this.testFailRemoveRoleFromUser(this.schemaSubject, "reader", "Olivia", "Permission denied.");
        this.testFailRemoveRoleFromUser(this.schemaSubject, "thisRoleDoesNotExist", "Olivia", "Permission denied.");
    }

    @Test
    public void shouldFailToRemoveYourselfFromAdminRole() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.removeRoleFromUser('admin', 'adminSubject')", "Removing yourself (user 'adminSubject') from the admin role is not allowed.");
    }

    @Test
    public void shouldAllowAddingAndRemovingUserFromMultipleRoles() throws Exception {
        Assert.assertFalse((String)"Should not have role publisher", (boolean)this.userHasRole("readSubject", "publisher"));
        Assert.assertFalse((String)"Should not have role architect", (boolean)this.userHasRole("readSubject", "architect"));
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'readSubject')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('architect', 'readSubject')");
        Assert.assertTrue((String)"Should have role publisher", (boolean)this.userHasRole("readSubject", "publisher"));
        Assert.assertTrue((String)"Should have role architect", (boolean)this.userHasRole("readSubject", "architect"));
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('publisher', 'readSubject')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('architect', 'readSubject')");
        Assert.assertFalse((String)"Should not have role publisher", (boolean)this.userHasRole("readSubject", "publisher"));
        Assert.assertFalse((String)"Should not have role architect", (boolean)this.userHasRole("readSubject", "architect"));
    }

    @Test
    public void shouldCreateRole() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createRole('new_role')");
        this.userManager.getRole("new_role");
    }

    @Test
    public void shouldNotCreateRoleIfInvalidRoleName() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.createRole('')", "The provided role name is empty.");
        this.assertFail(this.adminSubject, "CALL dbms.security.createRole('&%ss!')", "Role name '&%ss!' contains illegal characters. Use simple ascii characters and numbers.");
        this.assertFail(this.adminSubject, "CALL dbms.security.createRole('\u00e5\u00e4\u00f6\u00f8')", "Role name '\u00e5\u00e4\u00f6\u00f8' contains illegal characters. Use simple ascii characters and numbers");
    }

    @Test
    public void shouldNotCreateExistingRole() throws Exception {
        this.assertFail(this.adminSubject, String.format("CALL dbms.security.createRole('%s')", "architect"), "The specified role 'architect' already exists");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createRole('new_role')");
        this.assertFail(this.adminSubject, "CALL dbms.security.createRole('new_role')", "The specified role 'new_role' already exists");
    }

    @Test
    public void shouldNotAllowNonAdminCreateRole() throws Exception {
        this.testFailCreateRole(this.pwdSubject, this.CHANGE_PWD_ERR_MSG);
        this.testFailCreateRole(this.readSubject, "Permission denied.");
        this.testFailCreateRole(this.writeSubject, "Permission denied.");
        this.testFailCreateRole(this.schemaSubject, "Permission denied.");
    }

    @Test
    public void shouldThrowIfTryingToDeletePredefinedRole() throws Exception {
        this.testFailDeleteRole(this.adminSubject, "admin", String.format("'%s' is a predefined role and can not be deleted.", "admin"));
        this.testFailDeleteRole(this.adminSubject, "architect", String.format("'%s' is a predefined role and can not be deleted.", "architect"));
        this.testFailDeleteRole(this.adminSubject, "publisher", String.format("'%s' is a predefined role and can not be deleted.", "publisher"));
        this.testFailDeleteRole(this.adminSubject, "reader", String.format("'%s' is a predefined role and can not be deleted.", "reader"));
    }

    @Test
    public void shouldThrowIfNonAdminTryingToDeleteRole() throws Exception {
        this.assertEmpty(this.adminSubject, String.format("CALL dbms.security.createRole('%s')", "new_role"));
        this.testFailDeleteRole(this.schemaSubject, "new_role", "Permission denied.");
        this.testFailDeleteRole(this.writeSubject, "new_role", "Permission denied.");
        this.testFailDeleteRole(this.readSubject, "new_role", "Permission denied.");
        this.testFailDeleteRole(this.noneSubject, "new_role", "Permission denied.");
    }

    @Test
    public void shouldThrowIfDeletingNonExistentRole() {
        this.testFailDeleteRole(this.adminSubject, "nonExistent", "Role 'nonExistent' does not exist.");
    }

    @Test
    public void shouldDeleteRole() throws Exception {
        this.neo.getLocalUserManager().newRole("new_role", new String[0]);
        this.assertEmpty(this.adminSubject, String.format("CALL dbms.security.deleteRole('%s')", "new_role"));
        MatcherAssert.assertThat((Object)this.userManager.getAllRoleNames(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"new_role"})));
    }

    @Test
    public void deletingRoleAssignedToSelfShouldWork() throws Exception {
        this.assertEmpty(this.adminSubject, String.format("CALL dbms.security.createRole('%s')", "new_role"));
        this.assertEmpty(this.adminSubject, String.format("CALL dbms.security.addRoleToUser('%s', '%s')", "new_role", "adminSubject"));
        MatcherAssert.assertThat((Object)this.userManager.getRoleNamesForUser("adminSubject"), (Matcher)Matchers.hasItem((Object)"new_role"));
        this.assertEmpty(this.adminSubject, String.format("CALL dbms.security.deleteRole('%s')", "new_role"));
        MatcherAssert.assertThat((Object)this.userManager.getRoleNamesForUser("adminSubject"), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)"new_role")));
        MatcherAssert.assertThat((Object)this.userManager.getAllRoleNames(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{"new_role"})));
    }

    @Test
    public void shouldListUsers() throws Exception {
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listUsers() YIELD username", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "username", this.initialUsers));
    }

    @Test
    public void shouldReturnUsersWithRoles() throws Exception {
        Map expected = MapUtil.map((Object[])new Object[]{"adminSubject", this.listOf("admin"), "readSubject", this.listOf("reader"), "schemaSubject", this.listOf("architect"), "writeSubject", this.listOf("reader", "publisher"), "editorSubject", this.listOf("editor"), "pwdSubject", this.listOf(new String[0]), "noneSubject", this.listOf(new String[0]), "neo4j", this.listOf("admin")});
        this.userManager.addRoleToUser("reader", "writeSubject");
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listUsers()", r -> AuthProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "roles", expected));
    }

    @Test
    public void shouldReturnUsersWithFlags() throws Exception {
        Map expected = MapUtil.map((Object[])new Object[]{"adminSubject", this.listOf(new String[0]), "readSubject", this.listOf(new String[0]), "schemaSubject", this.listOf(new String[0]), "editorSubject", this.listOf(new String[0]), "writeSubject", this.listOf("is_suspended"), "pwdSubject", this.listOf(PWD_CHANGE, "is_suspended"), "noneSubject", this.listOf(new String[0]), "neo4j", this.listOf(PWD_CHANGE.toLowerCase())});
        this.userManager.suspendUser("writeSubject");
        this.userManager.suspendUser("pwdSubject");
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listUsers()", r -> AuthProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "flags", expected));
    }

    @Test
    public void shouldShowCurrentUser() throws Exception {
        this.userManager.addRoleToUser("reader", "writeSubject");
        this.assertSuccess(this.adminSubject, "CALL dbms.showCurrentUser()", r -> AuthProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "roles", MapUtil.map((Object[])new Object[]{"adminSubject", this.listOf("admin")})));
        this.assertSuccess(this.readSubject, "CALL dbms.showCurrentUser()", r -> AuthProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "roles", MapUtil.map((Object[])new Object[]{"readSubject", this.listOf("reader")})));
        this.assertSuccess(this.schemaSubject, "CALL dbms.showCurrentUser()", r -> AuthProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "roles", MapUtil.map((Object[])new Object[]{"schemaSubject", this.listOf("architect")})));
        this.assertSuccess(this.writeSubject, "CALL dbms.showCurrentUser()", r -> AuthProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "roles", MapUtil.map((Object[])new Object[]{"writeSubject", this.listOf("reader", "publisher")})));
        this.assertSuccess(this.noneSubject, "CALL dbms.showCurrentUser()", r -> AuthProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "roles", MapUtil.map((Object[])new Object[]{"noneSubject", this.listOf(new String[0])})));
    }

    @Test
    public void shouldNotAllowNonAdminListUsers() throws Exception {
        this.testFailListUsers(this.pwdSubject, 5, this.CHANGE_PWD_ERR_MSG);
        this.testFailListUsers(this.readSubject, 5, "Permission denied.");
        this.testFailListUsers(this.writeSubject, 5, "Permission denied.");
        this.testFailListUsers(this.schemaSubject, 5, "Permission denied.");
    }

    @Test
    public void shouldListRoles() throws Exception {
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listRoles() YIELD role", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "role", this.initialRoles));
    }

    @Test
    public void shouldReturnRolesWithUsers() throws Exception {
        Map expected = MapUtil.map((Object[])new Object[]{"admin", this.listOf("adminSubject", "neo4j"), "reader", this.listOf("readSubject"), "architect", this.listOf("schemaSubject"), "publisher", this.listOf("writeSubject"), "editor", this.listOf("editorSubject"), "empty", this.listOf(new String[0])});
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listRoles()", r -> AuthProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "role", "users", expected));
    }

    @Test
    public void shouldNotAllowNonAdminListRoles() throws Exception {
        this.testFailListRoles(this.pwdSubject, this.CHANGE_PWD_ERR_MSG);
        this.testFailListRoles(this.readSubject, "Permission denied.");
        this.testFailListRoles(this.writeSubject, "Permission denied.");
        this.testFailListRoles(this.schemaSubject, "Permission denied.");
    }

    @Test
    public void shouldListRolesForUser() throws Exception {
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listRolesForUser('adminSubject') YIELD value as roles RETURN roles", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "roles", "admin"));
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listRolesForUser('readSubject') YIELD value as roles RETURN roles", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "roles", "reader"));
    }

    @Test
    public void shouldListNoRolesForUserWithNoRoles() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.listRolesForUser('Henrik') YIELD value as roles RETURN roles");
    }

    @Test
    public void shouldNotListRolesForNonExistentUser() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.listRolesForUser('Petra') YIELD value as roles RETURN roles", "User 'Petra' does not exist.");
        this.assertFail(this.adminSubject, "CALL dbms.security.listRolesForUser('') YIELD value as roles RETURN roles", "User '' does not exist.");
    }

    @Test
    public void shouldListOwnRolesRoles() throws Exception {
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listRolesForUser('adminSubject') YIELD value as roles RETURN roles", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "roles", "admin"));
        this.assertSuccess(this.readSubject, "CALL dbms.security.listRolesForUser('readSubject') YIELD value as roles RETURN roles", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "roles", "reader"));
    }

    @Test
    public void shouldNotAllowNonAdminListUserRoles() throws Exception {
        this.testFailListUserRoles(this.pwdSubject, "adminSubject", this.CHANGE_PWD_ERR_MSG);
        this.testFailListUserRoles(this.readSubject, "adminSubject", "Permission denied.");
        this.testFailListUserRoles(this.writeSubject, "adminSubject", "Permission denied.");
        this.testFailListUserRoles(this.schemaSubject, "adminSubject", "Permission denied.");
    }

    @Test
    public void shouldListUsersForRole() throws Exception {
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listUsersForRole('admin') YIELD value as users RETURN users", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "users", "adminSubject", "neo4j"));
    }

    @Test
    public void shouldListNoUsersForRoleWithNoUsers() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.listUsersForRole('empty') YIELD value as users RETURN users");
    }

    @Test
    public void shouldNotListUsersForNonExistentRole() throws Exception {
        this.assertFail(this.adminSubject, "CALL dbms.security.listUsersForRole('poodle') YIELD value as users RETURN users", "Role 'poodle' does not exist.");
        this.assertFail(this.adminSubject, "CALL dbms.security.listUsersForRole('') YIELD value as users RETURN users", "Role '' does not exist.");
    }

    @Test
    public void shouldNotListUsersForRoleIfNotAdmin() throws Exception {
        this.testFailListRoleUsers(this.pwdSubject, "admin", this.CHANGE_PWD_ERR_MSG);
        this.testFailListRoleUsers(this.readSubject, "admin", "Permission denied.");
        this.testFailListRoleUsers(this.writeSubject, "admin", "Permission denied.");
        this.testFailListRoleUsers(this.schemaSubject, "admin", "Permission denied.");
    }

    @Test
    public void shouldAllowClearAuthCacheIfAdmin() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.clearAuthCache()");
    }

    @Test
    public void shouldNotClearAuthCacheIfNotAdmin() throws Exception {
        this.assertFail(this.pwdSubject, "CALL dbms.security.clearAuthCache()", this.CHANGE_PWD_ERR_MSG);
        this.assertFail(this.readSubject, "CALL dbms.security.clearAuthCache()", "Permission denied.");
        this.assertFail(this.writeSubject, "CALL dbms.security.clearAuthCache()", "Permission denied.");
        this.assertFail(this.schemaSubject, "CALL dbms.security.clearAuthCache()", "Permission denied.");
    }

    @Test
    public void shouldPrintUserAndRolesWhenPermissionDenied() throws Throwable {
        this.userManager.newUser("mats", "foo", false);
        this.userManager.newRole("failer", new String[]{"mats"});
        Object mats = this.neo.login("mats", "foo");
        this.assertFail(this.noneSubject, "CALL test.numNodes", "Read operations are not allowed for user 'noneSubject' with no roles.");
        this.assertFail(this.readSubject, "CALL test.allowedWriteProcedure", "Write operations are not allowed for user 'readSubject' with roles [reader].");
        this.assertFail(this.writeSubject, "CALL test.allowedSchemaProcedure", "Schema operations are not allowed for user 'writeSubject' with roles [publisher].");
        this.assertFail(mats, "CALL test.numNodes", "Read operations are not allowed for user 'mats' with roles [failer].");
        this.assertFail(mats, "RETURN test.allowedFunction1()", "Read operations are not allowed for user 'mats' with roles [failer].");
    }

    @Test
    public void shouldAllowProcedureStartingTransactionInNewThread() throws Throwable {
        DoubleLatch latch;
        ProcedureInteractionTestBase.ClassWithProcedures.exceptionsInProcedure.clear();
        ProcedureInteractionTestBase.ClassWithProcedures.doubleLatch = latch = new DoubleLatch(2);
        latch.start();
        this.assertEmpty(this.writeSubject, "CALL test.threadTransaction");
        latch.finishAndWaitForAllToFinish();
        MatcherAssert.assertThat((Object)ProcedureInteractionTestBase.ClassWithProcedures.exceptionsInProcedure.size(), (Matcher)Matchers.equalTo((Object)0));
        this.assertSuccess(this.adminSubject, "MATCH (:VeryUniqueLabel) RETURN toString(count(*)) as n", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "n", "1"));
    }

    @Test
    public void shouldInheritSecurityContextWhenProcedureStartingTransactionInNewThread() throws Throwable {
        DoubleLatch latch;
        ProcedureInteractionTestBase.ClassWithProcedures.exceptionsInProcedure.clear();
        ProcedureInteractionTestBase.ClassWithProcedures.doubleLatch = latch = new DoubleLatch(2);
        latch.start();
        this.assertEmpty(this.readSubject, "CALL test.threadReadDoingWriteTransaction");
        latch.finishAndWaitForAllToFinish();
        MatcherAssert.assertThat((Object)ProcedureInteractionTestBase.ClassWithProcedures.exceptionsInProcedure.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)ProcedureInteractionTestBase.ClassWithProcedures.exceptionsInProcedure.get(0).getMessage(), (Matcher)Matchers.containsString((String)this.WRITE_OPS_NOT_ALLOWED));
        this.assertSuccess(this.adminSubject, "MATCH (:VeryUniqueLabel) RETURN toString(count(*)) as n", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "n", "0"));
    }

    @Test
    public void shouldSetCorrectUnAuthenticatedPermissions() throws Throwable {
        Object unknownUser = this.neo.login("Batman", "Matban");
        this.assertFail(unknownUser, "MATCH (n) RETURN n", "");
        unknownUser = this.neo.login("Batman", "Matban");
        this.assertFail(unknownUser, "CREATE (:Node)", "");
        unknownUser = this.neo.login("Batman", "Matban");
        this.assertFail(unknownUser, "CREATE INDEX ON :Node(number)", "");
        unknownUser = this.neo.login("Batman", "Matban");
        this.assertFail(unknownUser, "CALL dbms.security.changePassword( '321' )", "");
        unknownUser = this.neo.login("Batman", "Matban");
        this.assertFail(unknownUser, "CALL dbms.security.createUser('Henrik', 'bar', true)", "");
    }

    @Test
    public void shouldSetCorrectPasswordChangeRequiredPermissions() throws Throwable {
        this.testFailRead(this.pwdSubject, 3, this.pwdReqErrMsg(this.READ_OPS_NOT_ALLOWED));
        this.testFailWrite(this.pwdSubject, this.pwdReqErrMsg(this.WRITE_OPS_NOT_ALLOWED));
        this.testFailSchema(this.pwdSubject, this.pwdReqErrMsg(this.SCHEMA_OPS_NOT_ALLOWED));
        this.assertPasswordChangeWhenPasswordChangeRequired(this.pwdSubject, "321");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', true)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('architect', 'Henrik')");
        Object henrik = this.neo.login("Henrik", "bar");
        this.neo.assertPasswordChangeRequired(henrik);
        this.testFailRead(henrik, 3, this.pwdReqErrMsg(this.READ_OPS_NOT_ALLOWED));
        this.testFailWrite(henrik, this.pwdReqErrMsg(this.WRITE_OPS_NOT_ALLOWED));
        this.testFailSchema(henrik, this.pwdReqErrMsg(this.SCHEMA_OPS_NOT_ALLOWED));
        this.assertPasswordChangeWhenPasswordChangeRequired(henrik, "321");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Olivia', 'bar', true)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('admin', 'Olivia')");
        Object olivia = this.neo.login("Olivia", "bar");
        this.neo.assertPasswordChangeRequired(olivia);
        this.testFailRead(olivia, 3, this.pwdReqErrMsg(this.READ_OPS_NOT_ALLOWED));
        this.testFailWrite(olivia, this.pwdReqErrMsg(this.WRITE_OPS_NOT_ALLOWED));
        this.testFailSchema(olivia, this.pwdReqErrMsg(this.SCHEMA_OPS_NOT_ALLOWED));
        this.assertFail(olivia, "CALL dbms.security.createUser('OliviasFriend', 'bar', false)", this.CHANGE_PWD_ERR_MSG);
        this.assertPasswordChangeWhenPasswordChangeRequired(olivia, "321");
    }

    @Test
    public void shouldSetCorrectNoRolePermissions() throws Exception {
        this.testFailRead(this.noneSubject, 3);
        this.testFailWrite(this.noneSubject);
        this.testFailSchema(this.noneSubject);
        this.testFailCreateUser(this.noneSubject, "Permission denied.");
        this.assertEmpty(this.noneSubject, "CALL dbms.security.changePassword( '321' )");
    }

    @Test
    public void shouldSetCorrectReaderPermissions() throws Exception {
        this.testSuccessfulRead(this.readSubject, 3);
        this.testFailWrite(this.readSubject);
        this.testFailTokenWrite(this.readSubject, this.WRITE_OPS_NOT_ALLOWED);
        this.testFailSchema(this.readSubject);
        this.testFailCreateUser(this.readSubject, "Permission denied.");
        this.assertEmpty(this.readSubject, "CALL dbms.security.changePassword( '321' )");
    }

    @Test
    public void shouldSetCorrectEditorPermissions() throws Exception {
        this.testSuccessfulRead(this.editorSubject, 3);
        this.testSuccessfulWrite(this.editorSubject);
        this.testFailTokenWrite(this.editorSubject);
        this.testFailSchema(this.editorSubject);
        this.testFailCreateUser(this.editorSubject, "Permission denied.");
        this.assertEmpty(this.editorSubject, "CALL dbms.security.changePassword( '321' )");
    }

    @Test
    public void shouldSetCorrectPublisherPermissions() throws Exception {
        this.testSuccessfulRead(this.writeSubject, 3);
        this.testSuccessfulWrite(this.writeSubject);
        this.testSuccessfulTokenWrite(this.writeSubject);
        this.testFailSchema(this.writeSubject);
        this.testFailCreateUser(this.writeSubject, "Permission denied.");
        this.assertEmpty(this.writeSubject, "CALL dbms.security.changePassword( '321' )");
    }

    @Test
    public void shouldSetCorrectSchemaPermissions() throws Exception {
        this.testSuccessfulRead(this.schemaSubject, 3);
        this.testSuccessfulWrite(this.schemaSubject);
        this.testSuccessfulTokenWrite(this.schemaSubject);
        this.testSuccessfulSchema(this.schemaSubject);
        this.testFailCreateUser(this.schemaSubject, "Permission denied.");
        this.assertEmpty(this.schemaSubject, "CALL dbms.security.changePassword( '321' )");
    }

    @Test
    public void shouldSetCorrectAdminPermissions() throws Exception {
        this.testSuccessfulRead(this.adminSubject, 3);
        this.testSuccessfulWrite(this.adminSubject);
        this.testSuccessfulTokenWrite(this.adminSubject);
        this.testSuccessfulSchema(this.adminSubject);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Olivia', 'bar', true)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.changePassword( '321' )");
    }

    @Test
    public void shouldSetCorrectMultiRolePermissions() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'schemaSubject')");
        this.testSuccessfulRead(this.schemaSubject, 3);
        this.testSuccessfulWrite(this.schemaSubject);
        this.testSuccessfulSchema(this.schemaSubject);
        this.testFailCreateUser(this.schemaSubject, "Permission denied.");
        this.assertEmpty(this.schemaSubject, "CALL dbms.security.changePassword( '321' )");
    }
}

