/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.Charsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.server.security.enterprise.auth.ProcedureInteractionTestBase;
import org.neo4j.server.security.enterprise.auth.ThreadedTransaction;
import org.neo4j.test.DoubleLatch;

public abstract class AuthScenariosInteractionTestBase<S>
extends ProcedureInteractionTestBase<S> {
    @Test
    public void readOperationsShouldNotBeAllowedWhenPasswordChangeRequired() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', true)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertPasswordChangeRequired(subject);
        this.testFailRead(subject, 3, this.pwdReqErrMsg(this.READ_OPS_NOT_ALLOWED));
    }

    @Test
    public void passwordChangeShouldEnableRolePermissions() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', true)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertPasswordChangeRequired(subject);
        this.assertPasswordChangeWhenPasswordChangeRequired(subject, "foo");
        subject = this.neo.login("Henrik", "foo");
        this.neo.assertAuthenticated(subject);
        this.testFailWrite(subject);
        this.testSuccessfulRead(subject, 3);
    }

    @Test
    public void loginShouldFailWithIncorrectPassword() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', true)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        Object subject = this.neo.login("Henrik", "foo");
        this.neo.assertInitFailed(subject);
    }

    @Test
    public void shouldLogSecurityEvents() throws Exception {
        Object mats = this.neo.login("mats", "neo4j");
        this.neo.executeQuery(mats, "UNWIND [] AS i RETURN 1", Collections.emptyMap(), r -> {});
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('mats', 'neo4j', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createRole('role1')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteRole('role1')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'mats')");
        mats = this.neo.login("mats", "neo4j");
        this.assertEmpty(mats, "MATCH (n) WHERE id(n) < 0 RETURN 1");
        this.assertFail(mats, "CALL dbms.security.changeUserPassword('neo4j', 'hackerPassword')", "Permission denied.");
        this.assertFail(mats, "CALL dbms.security.changeUserPassword('mats', '')", "A password cannot be empty.");
        this.assertEmpty(mats, "CALL dbms.security.changeUserPassword('mats', 'hackerPassword')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('reader', 'mats')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteUser('mats')");
        this.neo.getLocalGraph().shutdown();
        SecurityLog log = new SecurityLog();
        log.load();
        log.assertHasLine("mats", "logged in");
        log.assertHasLine("adminSubject", "created user `mats`");
        log.assertHasLine("adminSubject", "created role `role1`");
        log.assertHasLine("adminSubject", "deleted role `role1`");
        log.assertHasLine("mats", "logged in");
        log.assertHasLine("adminSubject", "added role `reader` to user `mats`");
        log.assertHasLine("mats", "tried to change password for user `neo4j`: Permission denied.");
        log.assertHasLine("mats", "tried to change password: A password cannot be empty.");
        log.assertHasLine("mats", "changed password");
        log.assertHasLine("adminSubject", "removed role `reader` from user `mats`");
        log.assertHasLine("adminSubject", "deleted user `mats`");
    }

    @Test
    public void userCreation2() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', true)");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertPasswordChangeRequired(subject);
        this.assertPasswordChangeWhenPasswordChangeRequired(subject, "foo");
        subject = this.neo.login("Henrik", "foo");
        this.neo.assertAuthenticated(subject);
        this.testFailRead(subject, 3);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        this.testFailWrite(subject);
        this.testSuccessfulRead(subject, 3);
    }

    @Test
    public void userCreation3() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.testFailRead(subject, 3);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        this.testSuccessfulWrite(subject);
        this.testSuccessfulRead(subject, 4);
        this.testFailSchema(subject);
    }

    @Test
    public void userCreation4() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.testFailRead(subject, 3);
        this.testFailWrite(subject);
        this.testFailSchema(subject);
        this.testFailCreateUser(subject, "Permission denied.");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('architect', 'Henrik')");
        this.testSuccessfulWrite(subject);
        this.testSuccessfulRead(subject, 4);
        this.testSuccessfulSchema(subject);
        this.testFailCreateUser(subject, "Permission denied.");
    }

    @Test
    public void userCreation5() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.testFailCreateUser(subject, "Permission denied.");
    }

    @Test
    public void userDeletion1() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteUser('Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertInitFailed(subject);
    }

    @Test
    public void userDeletion2() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteUser('Henrik')");
        this.assertFail(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')", "User 'Henrik' does not exist");
    }

    @Test
    public void userDeletion3() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteUser('Henrik')");
        this.assertFail(this.adminSubject, "CALL dbms.security.removeRoleFromUser('publisher', 'Henrik')", "User 'Henrik' does not exist");
    }

    @Test
    public void userDeletion4() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        Object henrik = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(henrik);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteUser('Henrik')");
        this.neo.assertSessionKilled(henrik);
        henrik = this.neo.login("Henrik", "bar");
        this.neo.assertInitFailed(henrik);
    }

    @Test
    public void roleManagement1() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.testSuccessfulWrite(subject);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('publisher', 'Henrik')");
        this.testFailRead(subject, 4);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        this.testFailWrite(subject);
        this.testSuccessfulRead(subject, 4);
    }

    @Test
    public void roleManagement2() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.testFailWrite(subject);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        this.testSuccessfulWrite(subject);
    }

    @Test
    public void roleManagement3() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        this.testSuccessfulWrite(subject);
        this.testSuccessfulRead(subject, 4);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('publisher', 'Henrik')");
        this.testFailWrite(subject);
        this.testSuccessfulRead(subject, 4);
    }

    @Test
    public void roleManagement4() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        this.testSuccessfulWrite(subject);
        this.testSuccessfulRead(subject, 4);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('reader', 'Henrik')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('publisher', 'Henrik')");
        this.testFailWrite(subject);
        this.testFailRead(subject, 4);
    }

    @Test
    public void roleManagement5() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        Object henrik = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(henrik);
        DoubleLatch latch = new DoubleLatch(2);
        ThreadedTransaction write = new ThreadedTransaction(this.neo, latch);
        write.executeCreateNode(this.threading, henrik);
        latch.startAndWaitForAllToStart();
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('publisher', 'Henrik')");
        latch.finishAndWaitForAllToFinish();
        write.closeAndAssertSuccess();
        this.testFailWrite(henrik);
    }

    @Test
    public void customRoleWithProcedureAccess() throws Exception {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('mats', 'neo4j', false)");
        Object mats = this.neo.login("mats", "neo4j");
        this.testFailTestProcs(mats);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createRole('role1')");
        this.testFailTestProcs(mats);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('role1', 'mats')");
        this.testSuccessfulTestProcs(mats);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.deleteRole('role1')");
        this.testFailTestProcs(mats);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createRole('role1')");
        this.testFailTestProcs(mats);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('architect', 'mats')");
        this.testSuccessfulTestProcs(mats);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('role1', 'mats')");
        this.testSuccessfulTestProcs(mats);
    }

    @Test
    public void userSuspension1() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.neo.logout(subject);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.suspendUser('Henrik')");
        subject = this.neo.login("Henrik", "bar");
        this.neo.assertInitFailed(subject);
    }

    @Test
    public void userSuspension2() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.testSuccessfulRead(subject, 3);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.suspendUser('Henrik')");
        this.neo.assertSessionKilled(subject);
        subject = this.neo.login("Henrik", "bar");
        this.neo.assertInitFailed(subject);
    }

    @Test
    public void userActivation1() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.suspendUser('Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertInitFailed(subject);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.activateUser('Henrik', false)");
        subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
    }

    @Test
    public void userListing() throws Throwable {
        this.testSuccessfulListUsers(this.adminSubject, this.initialUsers);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.testSuccessfulListUsers(this.adminSubject, this.with(this.initialUsers, "Henrik"));
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.testFailListUsers(subject, 6, "Permission denied.");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('admin', 'Henrik')");
        this.testSuccessfulListUsers(subject, this.with(this.initialUsers, "Henrik"));
    }

    @Test
    public void rolesListing() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.testFailListRoles(subject, "Permission denied.");
        this.testSuccessfulListRoles(this.adminSubject, this.initialRoles);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('admin', 'Henrik')");
        this.testSuccessfulListRoles(subject, this.initialRoles);
    }

    @Test
    public void listingUserRoles() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Craig', 'foo', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Craig')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.testFailListUserRoles(subject, "Craig", "Permission denied.");
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listRolesForUser('Craig') YIELD value as roles RETURN roles", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "roles", "publisher"));
        Object craigSubject = this.neo.login("Craig", "foo");
        this.assertSuccess(craigSubject, "CALL dbms.security.listRolesForUser('Craig') YIELD value as roles RETURN roles", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "roles", "publisher"));
    }

    @Test
    public void listingRoleUsers() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Craig', 'foo', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Craig')");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        Object subject = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(subject);
        this.testFailListRoleUsers(subject, "publisher", "Permission denied.");
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listUsersForRole('publisher') YIELD value as users RETURN users", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "users", "Henrik", "Craig", "writeSubject"));
    }

    @Test
    public void callProcedures1() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'bar', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('publisher', 'Henrik')");
        Object henrik = this.neo.login("Henrik", "bar");
        this.neo.assertAuthenticated(henrik);
        this.assertEmpty(henrik, "CALL test.createNode()");
        this.assertSuccess(henrik, "CALL test.numNodes() YIELD count as count RETURN count", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "count", "4"));
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        this.assertEmpty(henrik, "CALL test.createNode()");
        this.assertSuccess(henrik, "CALL test.numNodes() YIELD count as count RETURN count", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "count", "5"));
        this.assertEmpty(this.adminSubject, "CALL dbms.security.removeRoleFromUser('publisher', 'Henrik')");
        this.assertFail(henrik, "CALL test.createNode()", "Write operations are not allowed for user 'Henrik' with roles [reader].");
    }

    @Test
    public void changeUserPassword1() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'abc', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        Object subject = this.neo.login("Henrik", "abc");
        this.neo.assertAuthenticated(subject);
        this.testSuccessfulRead(subject, 3);
        this.assertEmpty(subject, "CALL dbms.security.changeUserPassword('Henrik', '123', false)");
        this.neo.updateAuthToken(subject, "Henrik", "123");
        this.testSuccessfulRead(subject, 3);
        this.neo.logout(subject);
        subject = this.neo.login("Henrik", "abc");
        this.neo.assertInitFailed(subject);
        subject = this.neo.login("Henrik", "123");
        this.neo.assertAuthenticated(subject);
        this.testSuccessfulRead(subject, 3);
    }

    @Test
    public void changeUserPassword2() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'abc', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        Object subject = this.neo.login("Henrik", "abc");
        this.neo.assertAuthenticated(subject);
        this.testSuccessfulRead(subject, 3);
        this.assertEmpty(this.adminSubject, "CALL dbms.security.changeUserPassword('Henrik', '123', false)");
        this.neo.logout(subject);
        subject = this.neo.login("Henrik", "abc");
        this.neo.assertInitFailed(subject);
        subject = this.neo.login("Henrik", "123");
        this.neo.assertAuthenticated(subject);
        this.testSuccessfulRead(subject, 3);
    }

    @Test
    public void changeUserPassword3() throws Throwable {
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Craig', 'abc', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.createUser('Henrik', 'abc', false)");
        this.assertEmpty(this.adminSubject, "CALL dbms.security.addRoleToUser('reader', 'Henrik')");
        Object subject = this.neo.login("Henrik", "abc");
        this.neo.assertAuthenticated(subject);
        this.testSuccessfulRead(subject, 3);
        this.assertFail(subject, "CALL dbms.security.changeUserPassword('Craig', '123')", "Permission denied.");
    }

    @Test
    public void shouldNotTryToCreateTokensWhenReading() {
        this.assertEmpty(this.adminSubject, "CREATE (:MyNode)");
        this.assertSuccess(this.readSubject, "MATCH (n:MyNode) WHERE n.nonExistent = 'foo' RETURN toString(count(*)) AS c", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "c", "0"));
        this.assertFail(this.readSubject, "MATCH (n:MyNode) SET n.nonExistent = 'foo' RETURN toString(count(*)) AS c", this.TOKEN_CREATE_OPS_NOT_ALLOWED);
        this.assertFail(this.readSubject, "MATCH (n:MyNode) SET n:Foo RETURN toString(count(*)) AS c", this.TOKEN_CREATE_OPS_NOT_ALLOWED);
        this.assertSuccess(this.schemaSubject, "MATCH (n:MyNode) SET n.nonExistent = 'foo' RETURN toString(count(*)) AS c", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "c", "1"));
        this.assertSuccess(this.readSubject, "MATCH (n:MyNode) WHERE n.nonExistent = 'foo' RETURN toString(count(*)) AS c", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "c", "1"));
    }

    private class SecurityLog {
        List<String> lines;

        private SecurityLog() {
        }

        void load() throws IOException {
            File securityLog = new File(AuthScenariosInteractionTestBase.this.securityLog.getAbsolutePath());
            try (FileSystemAbstraction fileSystem = AuthScenariosInteractionTestBase.this.neo.fileSystem();
                 BufferedReader bufferedReader = new BufferedReader(fileSystem.openAsReader(securityLog, Charsets.UTF_8));){
                this.lines = bufferedReader.lines().collect(Collectors.toList());
            }
        }

        void assertHasLine(String subject, String msg) {
            Objects.requireNonNull(this.lines);
            MatcherAssert.assertThat(this.lines, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)("[" + subject + "]: " + msg))));
        }
    }
}

