/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.v1.messaging.message.FailureMessage;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RecordMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.ResetMessage;
import org.neo4j.bolt.v1.messaging.message.ResponseMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.message.SuccessMessage;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseAuthManager;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.security.enterprise.auth.EnterpriseAuthAndUserManager;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.NeoInteractionLevel;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;

class BoltInteraction
implements NeoInteractionLevel<BoltSubject> {
    protected final HostnamePort address = new HostnamePort("localhost:7687");
    private final Factory<TransportConnection> connectionFactory = SocketConnection::new;
    private final Neo4jWithSocket server;
    private Map<String, BoltSubject> subjects = new HashMap<String, BoltSubject>();
    private FileSystemAbstraction fileSystem;
    private EnterpriseAuthManager authManager;

    BoltInteraction(Map<String, String> config) throws IOException {
        this(config, EphemeralFileSystemAbstraction::new);
    }

    BoltInteraction(Map<String, String> config, Supplier<FileSystemAbstraction> fileSystemSupplier) throws IOException {
        TestEnterpriseGraphDatabaseFactory factory = new TestEnterpriseGraphDatabaseFactory();
        this.fileSystem = fileSystemSupplier.get();
        this.server = new Neo4jWithSocket(this.getClass(), (TestGraphDatabaseFactory)factory, () -> this.fileSystem, settings -> {
            settings.put(GraphDatabaseSettings.auth_enabled.name(), "true");
            settings.putAll(config);
        });
        this.server.ensureDatabase(r -> {});
        GraphDatabaseFacade db = (GraphDatabaseFacade)this.server.graphDatabaseService();
        this.authManager = (EnterpriseAuthManager)db.getDependencyResolver().resolveDependency(EnterpriseAuthManager.class);
    }

    @Override
    public EnterpriseUserManager getLocalUserManager() throws Exception {
        if (this.authManager instanceof EnterpriseAuthAndUserManager) {
            return ((EnterpriseAuthAndUserManager)this.authManager).getUserManager();
        }
        throw new Exception("The used configuration does not have a user manager");
    }

    @Override
    public GraphDatabaseFacade getLocalGraph() {
        return (GraphDatabaseFacade)this.server.graphDatabaseService();
    }

    @Override
    public FileSystemAbstraction fileSystem() {
        return this.fileSystem;
    }

    @Override
    public InternalTransaction beginLocalTransactionAsUser(BoltSubject subject, KernelTransaction.Type txType) throws Throwable {
        EnterpriseSecurityContext securityContext = this.authManager.login(AuthToken.newBasicAuthToken((String)subject.username, (String)subject.password));
        return this.getLocalGraph().beginTransaction(txType, (SecurityContext)securityContext);
    }

    @Override
    public String executeQuery(BoltSubject subject, String call, Map<String, Object> params, Consumer<ResourceIterator<Map<String, Object>>> resultConsumer) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        try {
            subject.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)call, params), PullAllMessage.pullAll()}));
            resultConsumer.accept(BoltInteraction.collectResults(subject.client));
            return "";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public BoltSubject login(String username, String password) throws Exception {
        BoltSubject subject = this.subjects.get(username);
        if (subject == null) {
            subject = new BoltSubject((TransportConnection)this.connectionFactory.newInstance(), username, password);
            this.subjects.put(username, subject);
        } else {
            subject.client.disconnect();
            subject.client = (TransportConnection)this.connectionFactory.newInstance();
        }
        subject.client.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"realm", "native", "principal", username, "credentials", password, "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)subject.client, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        subject.setLoginResult(TransportTestUtil.receiveOneResponseMessage((TransportConnection)subject.client));
        return subject;
    }

    @Override
    public void logout(BoltSubject subject) throws Exception {
        subject.client.disconnect();
        subject.client = (TransportConnection)this.connectionFactory.newInstance();
    }

    @Override
    public void updateAuthToken(BoltSubject subject, String username, String password) {
    }

    @Override
    public String nameOf(BoltSubject subject) {
        return subject.username;
    }

    @Override
    public void tearDown() throws Throwable {
        for (BoltSubject subject : this.subjects.values()) {
            subject.client.disconnect();
        }
        this.subjects.clear();
        this.server.graphDatabaseService().shutdown();
        this.fileSystem.close();
    }

    @Override
    public void assertAuthenticated(BoltSubject subject) {
        Assert.assertTrue((String)"Should be authenticated", (boolean)subject.isAuthenticated());
    }

    @Override
    public void assertPasswordChangeRequired(BoltSubject subject) {
        Assert.assertTrue((String)"Should need to change password", (boolean)subject.passwordChangeRequired());
    }

    @Override
    public void assertInitFailed(BoltSubject subject) {
        Assert.assertFalse((String)"Should not be authenticated", (boolean)subject.isAuthenticated());
    }

    @Override
    public void assertSessionKilled(BoltSubject subject) {
        MatcherAssert.assertThat((Object)subject.client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Override
    public String getConnectionProtocol() {
        return "bolt";
    }

    private static BoltResult collectResults(TransportConnection client) throws Exception {
        ResponseMessage message = TransportTestUtil.receiveOneResponseMessage((TransportConnection)client);
        List fieldNames = new ArrayList();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (message instanceof SuccessMessage) {
            Map metadata = ((SuccessMessage)message).meta();
            fieldNames = (List)metadata.get("fields");
        } else if (message instanceof FailureMessage) {
            FailureMessage failMessage = (FailureMessage)message;
            TransportTestUtil.receiveOneResponseMessage((TransportConnection)client);
            client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{ResetMessage.reset()}));
            TransportTestUtil.receiveOneResponseMessage((TransportConnection)client);
            throw new AuthenticationException(failMessage.status(), failMessage.message());
        }
        do {
            if (!((message = TransportTestUtil.receiveOneResponseMessage((TransportConnection)client)) instanceof RecordMessage)) continue;
            Object[] row = ((RecordMessage)message).record().fields();
            HashMap rowMap = new HashMap();
            for (int i = 0; i < row.length; ++i) {
                rowMap.put(fieldNames.get(i), row[i]);
            }
            result.add(rowMap);
        } while (!(message instanceof SuccessMessage) && !(message instanceof FailureMessage));
        if (message instanceof FailureMessage) {
            FailureMessage failMessage = (FailureMessage)message;
            client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{ResetMessage.reset()}));
            TransportTestUtil.receiveOneResponseMessage((TransportConnection)client);
            throw new AuthenticationException(failMessage.status(), failMessage.message());
        }
        return new BoltResult(result);
    }

    static class BoltResult
    implements ResourceIterator<Map<String, Object>> {
        private int index = 0;
        private List<Map<String, Object>> data;

        BoltResult(List<Map<String, Object>> data) {
            this.data = data;
        }

        public void close() {
            this.index = this.data.size();
        }

        public boolean hasNext() {
            return this.index < this.data.size();
        }

        public Map<String, Object> next() {
            Map<String, Object> row = this.data.get(this.index);
            ++this.index;
            return row;
        }
    }

    static class BoltSubject {
        TransportConnection client;
        String username;
        String password;
        AuthenticationResult loginResult = AuthenticationResult.FAILURE;

        BoltSubject(TransportConnection client, String username, String password) {
            this.client = client;
            this.username = username;
            this.password = password;
        }

        void setLoginResult(ResponseMessage result) {
            if (result instanceof SuccessMessage) {
                Map meta = ((SuccessMessage)result).meta();
                this.loginResult = meta.containsKey("credentials_expired") && meta.get("credentials_expired").equals(true) ? AuthenticationResult.PASSWORD_CHANGE_REQUIRED : AuthenticationResult.SUCCESS;
            } else if (result instanceof FailureMessage) {
                this.loginResult = AuthenticationResult.FAILURE;
                Status status = ((FailureMessage)result).status();
                if (status.equals(Status.Security.AuthenticationRateLimit)) {
                    this.loginResult = AuthenticationResult.TOO_MANY_ATTEMPTS;
                }
            }
        }

        boolean isAuthenticated() {
            return this.loginResult.equals((Object)AuthenticationResult.SUCCESS);
        }

        boolean passwordChangeRequired() {
            return this.loginResult.equals((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
        }
    }
}

