/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.bolt.v1.runtime.integration.TransactionIT;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.enterprise.builtinprocs.QueryStatusResult;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.security.enterprise.auth.ProcedureInteractionTestBase;
import org.neo4j.server.security.enterprise.auth.ThreadedTransaction;
import org.neo4j.test.Barrier;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.matchers.CommonMatchers;

public abstract class BuiltInProceduresInteractionTestBase<S>
extends ProcedureInteractionTestBase<S> {
    public void shouldListSelfTransaction() {
        this.assertSuccess(this.adminSubject, "CALL dbms.listTransactions()", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "activeTransactions", MapUtil.map((Object[])new Object[]{"adminSubject", "1"})));
    }

    public void shouldNotListTransactionsIfNotAdmin() {
        this.assertFail(this.noneSubject, "CALL dbms.listTransactions()", "Permission denied.");
        this.assertFail(this.readSubject, "CALL dbms.listTransactions()", "Permission denied.");
        this.assertFail(this.writeSubject, "CALL dbms.listTransactions()", "Permission denied.");
        this.assertFail(this.schemaSubject, "CALL dbms.listTransactions()", "Permission denied.");
    }

    public void shouldListTransactions() throws Throwable {
        DoubleLatch latch = new DoubleLatch(3);
        ThreadedTransaction<Object> write1 = new ThreadedTransaction<Object>(this.neo, latch);
        ThreadedTransaction<Object> write2 = new ThreadedTransaction<Object>(this.neo, latch);
        String q1 = write1.executeCreateNode(this.threading, this.writeSubject);
        String q2 = write2.executeCreateNode(this.threading, this.writeSubject);
        latch.startAndWaitForAllToStart();
        this.assertSuccess(this.adminSubject, "CALL dbms.listTransactions()", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "activeTransactions", MapUtil.map((Object[])new Object[]{"adminSubject", "1", "writeSubject", "2"})));
        latch.finishAndWaitForAllToFinish();
        write1.closeAndAssertSuccess();
        write2.closeAndAssertSuccess();
    }

    public void shouldListRestrictedTransaction() {
        DoubleLatch doubleLatch = new DoubleLatch(2);
        ProcedureInteractionTestBase.ClassWithProcedures.setTestLatch(new ProcedureInteractionTestBase.ClassWithProcedures.LatchedRunnables(doubleLatch, () -> {}, () -> {}));
        new Thread(() -> this.assertEmpty(this.writeSubject, "CALL test.waitForLatch()")).start();
        doubleLatch.startAndWaitForAllToStart();
        try {
            this.assertSuccess(this.adminSubject, "CALL dbms.listTransactions()", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "activeTransactions", MapUtil.map((Object[])new Object[]{"adminSubject", "1", "writeSubject", "1"})));
        }
        finally {
            doubleLatch.finishAndWaitForAllToFinish();
        }
    }

    @Test
    public void shouldListAllQueryIncludingMetaData() throws Throwable {
        String setMetaDataQuery = "CALL dbms.setTXMetaData( { realUser: 'MyMan' } )";
        String matchQuery = "MATCH (n) RETURN n";
        String listQueriesQuery = "CALL dbms.listQueries()";
        DoubleLatch latch = new DoubleLatch(2);
        OffsetDateTime startTime = OffsetDateTime.now();
        ThreadedTransaction<Object> tx = new ThreadedTransaction<Object>(this.neo, latch);
        tx.execute(this.threading, this.writeSubject, setMetaDataQuery, matchQuery);
        latch.startAndWaitForAllToStart();
        this.assertSuccess(this.adminSubject, listQueriesQuery, r -> {
            Set maps = r.stream().collect(Collectors.toSet());
            Matcher<Map<String, Object>> thisQuery = this.listedQueryOfInteractionLevel(startTime, "adminSubject", listQueriesQuery);
            Matcher<Map<String, Object>> matchQueryMatcher = this.listedQueryWithMetaData(startTime, "writeSubject", matchQuery, MapUtil.map((Object[])new Object[]{"realUser", "MyMan"}));
            Assert.assertThat(maps, (Matcher)CommonMatchers.matchesOneToOneInAnyOrder((Matcher[])new Matcher[]{thisQuery, matchQueryMatcher}));
        });
        latch.finishAndWaitForAllToFinish();
        tx.closeAndAssertSuccess();
    }

    @Test
    public void shouldListAllQueriesWhenRunningAsAdmin() throws Throwable {
        DoubleLatch latch = new DoubleLatch(3, true);
        OffsetDateTime startTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(OffsetDateTime.now().toEpochSecond()), QueryStatusResult.UTC_ZONE_ID);
        ThreadedTransaction<Object> read1 = new ThreadedTransaction<Object>(this.neo, latch);
        ThreadedTransaction<Object> read2 = new ThreadedTransaction<Object>(this.neo, latch);
        String q1 = read1.execute(this.threading, this.readSubject, "UNWIND [1,2,3] AS x RETURN x");
        String q2 = read2.execute(this.threading, this.writeSubject, "UNWIND [4,5,6] AS y RETURN y");
        latch.startAndWaitForAllToStart();
        String query = "CALL dbms.listQueries()";
        this.assertSuccess(this.adminSubject, query, r -> {
            Set maps = r.stream().collect(Collectors.toSet());
            Matcher<Map<String, Object>> thisQuery = this.listedQueryOfInteractionLevel(startTime, "adminSubject", query);
            Matcher<Map<String, Object>> matcher1 = this.listedQuery(startTime, "readSubject", q1);
            Matcher<Map<String, Object>> matcher2 = this.listedQuery(startTime, "writeSubject", q2);
            Assert.assertThat(maps, (Matcher)CommonMatchers.matchesOneToOneInAnyOrder((Matcher[])new Matcher[]{matcher1, matcher2, thisQuery}));
        });
        latch.finishAndWaitForAllToFinish();
        read1.closeAndAssertSuccess();
        read2.closeAndAssertSuccess();
    }

    @Test
    public void shouldOnlyListOwnQueriesWhenNotRunningAsAdmin() throws Throwable {
        DoubleLatch latch = new DoubleLatch(3, true);
        OffsetDateTime startTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(OffsetDateTime.now().toEpochSecond()), QueryStatusResult.UTC_ZONE_ID);
        ThreadedTransaction<Object> read1 = new ThreadedTransaction<Object>(this.neo, latch);
        ThreadedTransaction<Object> read2 = new ThreadedTransaction<Object>(this.neo, latch);
        String q1 = read1.execute(this.threading, this.readSubject, "UNWIND [1,2,3] AS x RETURN x");
        String ignored = read2.execute(this.threading, this.writeSubject, "UNWIND [4,5,6] AS y RETURN y");
        latch.startAndWaitForAllToStart();
        String query = "CALL dbms.listQueries()";
        this.assertSuccess(this.readSubject, query, r -> {
            Set maps = r.stream().collect(Collectors.toSet());
            Matcher<Map<String, Object>> thisQuery = this.listedQuery(startTime, "readSubject", query);
            Matcher<Map<String, Object>> queryMatcher = this.listedQuery(startTime, "readSubject", q1);
            Assert.assertThat(maps, (Matcher)CommonMatchers.matchesOneToOneInAnyOrder((Matcher[])new Matcher[]{queryMatcher, thisQuery}));
        });
        latch.finishAndWaitForAllToFinish();
        read1.closeAndAssertSuccess();
        read2.closeAndAssertSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldListQueriesEvenIfUsingPeriodicCommit() throws Throwable {
        for (int i = 8; i <= 11; ++i) {
            DoubleLatch latch = new DoubleLatch(3, true);
            Barrier.Control barrier = new Barrier.Control();
            Server server = TransactionIT.createHttpServer((DoubleLatch)latch, (Barrier.Control)barrier, (int)i, (int)(50 - i));
            server.start();
            int localPort = this.getLocalPort(server);
            OffsetDateTime startTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(OffsetDateTime.now().toEpochSecond()), QueryStatusResult.UTC_ZONE_ID);
            ThreadedTransaction<Object> write = new ThreadedTransaction<Object>(this.neo, latch);
            try {
                String writeQuery = write.executeEarly(this.threading, this.writeSubject, KernelTransaction.Type.implicit, String.format("USING PERIODIC COMMIT 10 LOAD CSV FROM 'http://localhost:%d' AS line ", localPort) + "CREATE (n:A {id: line[0], square: line[1]}) RETURN count(*)");
                latch.startAndWaitForAllToStart();
                String query = "CALL dbms.listQueries()";
                this.assertSuccess(this.adminSubject, query, r -> {
                    Set maps = r.stream().collect(Collectors.toSet());
                    Matcher<Map<String, Object>> thisMatcher = this.listedQuery(startTime, "adminSubject", query);
                    Matcher<Map<String, Object>> writeMatcher = this.listedQuery(startTime, "writeSubject", writeQuery);
                    Assert.assertThat(maps, (Matcher)CoreMatchers.hasItem(thisMatcher));
                    Assert.assertThat(maps, (Matcher)CoreMatchers.hasItem(writeMatcher));
                });
                continue;
            }
            finally {
                barrier.release();
                latch.finishAndWaitForAllToFinish();
                server.stop();
                write.closeAndAssertSuccess();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldListAllQueriesWithAuthDisabled() throws Throwable {
        this.neo.tearDown();
        this.neo = this.setUpNeoServer(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.auth_enabled.name(), "false"}));
        DoubleLatch latch = new DoubleLatch(2, true);
        OffsetDateTime startTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(OffsetDateTime.now().toEpochSecond()), QueryStatusResult.UTC_ZONE_ID);
        ThreadedTransaction read = new ThreadedTransaction(this.neo, latch);
        String q = read.execute(this.threading, this.neo.login("user1", ""), "UNWIND [1,2,3] AS x RETURN x");
        latch.startAndWaitForAllToStart();
        String query = "CALL dbms.listQueries()";
        try {
            this.assertSuccess(this.neo.login("admin", ""), query, r -> {
                Set maps = r.stream().collect(Collectors.toSet());
                Matcher<Map<String, Object>> thisQuery = this.listedQueryOfInteractionLevel(startTime, "", query);
                Matcher<Map<String, Object>> matcher1 = this.listedQuery(startTime, "", q);
                Assert.assertThat(maps, (Matcher)CommonMatchers.matchesOneToOneInAnyOrder((Matcher[])new Matcher[]{matcher1, thisQuery}));
            });
        }
        finally {
            latch.finishAndWaitForAllToFinish();
        }
        read.closeAndAssertSuccess();
    }

    @Test
    public void shouldCreateLabel() {
        this.assertFail(this.editorSubject, "CREATE (:MySpecialLabel)", this.TOKEN_CREATE_OPS_NOT_ALLOWED);
        this.assertFail(this.editorSubject, "CALL db.createLabel('MySpecialLabel')", this.TOKEN_CREATE_OPS_NOT_ALLOWED);
        this.assertEmpty(this.writeSubject, "CALL db.createLabel('MySpecialLabel')");
        this.assertSuccess(this.writeSubject, "MATCH (n:MySpecialLabel) RETURN count(n) AS count", r -> ((Map)r.next()).get("count").equals(0));
        this.assertEmpty(this.editorSubject, "CREATE (:MySpecialLabel)");
    }

    @Test
    public void shouldCreateRelationshipType() {
        this.assertEmpty(this.writeSubject, "CREATE (a:Node {id:0}) CREATE ( b:Node {id:1} )");
        this.assertFail(this.editorSubject, "MATCH (a:Node), (b:Node) WHERE a.id = 0 AND b.id = 1 CREATE (a)-[:MySpecialRelationship]->(b)", this.TOKEN_CREATE_OPS_NOT_ALLOWED);
        this.assertFail(this.editorSubject, "CALL db.createRelationshipType('MySpecialRelationship')", this.TOKEN_CREATE_OPS_NOT_ALLOWED);
        this.assertEmpty(this.writeSubject, "CALL db.createRelationshipType('MySpecialRelationship')");
        this.assertSuccess(this.editorSubject, "MATCH (n)-[c:MySpecialRelationship]-(m) RETURN count(c) AS count", r -> ((Map)r.next()).get("count").equals(0));
        this.assertEmpty(this.editorSubject, "MATCH (a:Node), (b:Node) WHERE a.id = 0 AND b.id = 1 CREATE (a)-[:MySpecialRelationship]->(b)");
    }

    @Test
    public void shouldCreateProperty() {
        this.assertFail(this.editorSubject, "CREATE (a) SET a.MySpecialProperty = 'a'", this.TOKEN_CREATE_OPS_NOT_ALLOWED);
        this.assertFail(this.editorSubject, "CALL db.createProperty('MySpecialProperty')", this.TOKEN_CREATE_OPS_NOT_ALLOWED);
        this.assertEmpty(this.writeSubject, "CALL db.createProperty('MySpecialProperty')");
        this.assertSuccess(this.editorSubject, "MATCH (n) WHERE n.MySpecialProperty IS NULL RETURN count(n) AS count", r -> ((Map)r.next()).get("count").equals(0));
        this.assertEmpty(this.editorSubject, "CREATE (a) SET a.MySpecialProperty = 'a'");
    }

    @Test
    public void queryWaitingForLocksShouldBeKilledBeforeLocksAreReleased() throws Throwable {
        this.assertEmpty(this.adminSubject, "CREATE (:MyNode {prop: 2})");
        ProcedureInteractionTestBase.ClassWithProcedures.doubleLatch = new DoubleLatch(2);
        String query1 = "MATCH (n:MyNode) SET n.prop = 5 WITH * CALL test.neverEnding() RETURN 1";
        ThreadedTransaction<Object> tx1 = new ThreadedTransaction<Object>(this.neo, new DoubleLatch());
        tx1.executeEarly(this.threading, this.writeSubject, KernelTransaction.Type.explicit, query1);
        ProcedureInteractionTestBase.ClassWithProcedures.doubleLatch.startAndWaitForAllToStart();
        ThreadedTransaction<Object> tx2 = new ThreadedTransaction<Object>(this.neo, new DoubleLatch());
        String query2 = "MATCH (n:MyNode) SET n.prop = 10 RETURN 1";
        tx2.executeEarly(this.threading, this.writeSubject, KernelTransaction.Type.explicit, query2);
        this.assertQueryIsRunning(query2);
        this.assertSuccess(this.adminSubject, "CALL dbms.listQueries() YIELD query, queryId WITH query, queryId WHERE query = '" + query2 + "'CALL dbms.killQuery(queryId) YIELD queryId AS killedId RETURN 1", itr -> Assert.assertThat((Object)itr.hasNext(), (Matcher)Matchers.equalTo((Object)true)));
        tx2.closeAndAssertSomeTermination();
        ProcedureInteractionTestBase.ClassWithProcedures.doubleLatch.finish();
        tx1.closeAndAssertSuccess();
    }

    @Test
    public void shouldKillQueryAsAdmin() throws Throwable {
        this.executeTwoQueriesAndKillTheFirst(this.readSubject, this.readSubject, this.adminSubject);
    }

    @Test
    public void shouldKillQueryAsUser() throws Throwable {
        this.executeTwoQueriesAndKillTheFirst(this.readSubject, this.writeSubject, this.readSubject);
    }

    private void executeTwoQueriesAndKillTheFirst(S executor1, S executor2, S killer) throws Throwable {
        DoubleLatch latch = new DoubleLatch(3);
        ThreadedTransaction<S> tx1 = new ThreadedTransaction<S>(this.neo, latch);
        ThreadedTransaction<S> tx2 = new ThreadedTransaction<S>(this.neo, latch);
        String q1 = tx1.execute(this.threading, executor1, "UNWIND [1,2,3] AS x RETURN x");
        tx2.execute(this.threading, executor2, "UNWIND [4,5,6] AS y RETURN y");
        latch.startAndWaitForAllToStart();
        String id1 = this.extractQueryId(q1);
        this.assertSuccess(killer, "CALL dbms.killQuery('" + id1 + "') YIELD username RETURN count(username) AS count, username", r -> {
            List actual = r.stream().collect(Collectors.toList());
            Matcher mapMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"count"), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)1), (Matcher)Matchers.equalTo((Object)1L))), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"username"), (Matcher)Matchers.equalTo((Object)"readSubject")));
            Assert.assertThat(actual, (Matcher)CommonMatchers.matchesOneToOneInAnyOrder((Matcher[])new Matcher[]{mapMatcher}));
        });
        latch.finishAndWaitForAllToFinish();
        tx1.closeAndAssertExplicitTermination();
        tx2.closeAndAssertSuccess();
        this.assertEmpty(this.adminSubject, "CALL dbms.listQueries() YIELD query WITH * WHERE NOT query CONTAINS 'listQueries' RETURN *");
    }

    @Test
    public void shouldSelfKillQuery() throws Throwable {
        String result = this.neo.executeQuery(this.readSubject, "WITH 'Hello' AS marker CALL dbms.listQueries() YIELD queryId AS id, query WITH * WHERE query CONTAINS 'Hello' CALL dbms.killQuery(id) YIELD username RETURN count(username) AS count, username", Collections.emptyMap(), r -> {});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"Explicitly terminated by the user."));
        this.assertEmpty(this.adminSubject, "CALL dbms.listQueries() YIELD query WITH * WHERE NOT query CONTAINS 'listQueries' RETURN *");
    }

    @Test
    public void shouldFailToTerminateOtherUsersQuery() throws Throwable {
        DoubleLatch latch = new DoubleLatch(3, true);
        ThreadedTransaction<Object> read = new ThreadedTransaction<Object>(this.neo, latch);
        ThreadedTransaction<Object> write = new ThreadedTransaction<Object>(this.neo, latch);
        String q1 = read.execute(this.threading, this.readSubject, "UNWIND [1,2,3] AS x RETURN x");
        write.execute(this.threading, this.writeSubject, "UNWIND [4,5,6] AS y RETURN y");
        latch.startAndWaitForAllToStart();
        try {
            String id1 = this.extractQueryId(q1);
            this.assertFail(this.writeSubject, "CALL dbms.killQuery('" + id1 + "') YIELD username RETURN *", "Permission denied.");
            latch.finishAndWaitForAllToFinish();
            read.closeAndAssertSuccess();
            write.closeAndAssertSuccess();
        }
        catch (Throwable t) {
            latch.finishAndWaitForAllToFinish();
            throw t;
        }
        this.assertEmpty(this.adminSubject, "CALL dbms.listQueries() YIELD query WITH * WHERE NOT query CONTAINS 'listQueries' RETURN *");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTerminateQueriesEvenIfUsingPeriodicCommit() throws Throwable {
        for (int batchSize = 8; batchSize <= 11; ++batchSize) {
            DoubleLatch latch = new DoubleLatch(3, true);
            Barrier.Control barrier = new Barrier.Control();
            Server server = TransactionIT.createHttpServer((DoubleLatch)latch, (Barrier.Control)barrier, (int)batchSize, (int)(50 - batchSize));
            server.start();
            int localPort = this.getLocalPort(server);
            ThreadedTransaction<Object> write = new ThreadedTransaction<Object>(this.neo, latch);
            try {
                String writeQuery = write.executeEarly(this.threading, this.writeSubject, KernelTransaction.Type.implicit, String.format("USING PERIODIC COMMIT 10 LOAD CSV FROM 'http://localhost:%d' AS line ", localPort) + "CREATE (n:A {id: line[0], square: line[1]}) RETURN count(*)");
                latch.startAndWaitForAllToStart();
                String writeQueryId = this.extractQueryId(writeQuery);
                this.assertSuccess(this.adminSubject, "CALL dbms.killQuery('" + writeQueryId + "') YIELD username RETURN count(username) AS count, username", r -> {
                    List actual = r.stream().collect(Collectors.toList());
                    Matcher mapMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"count"), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)1), (Matcher)Matchers.equalTo((Object)1L))), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"username"), (Matcher)Matchers.equalTo((Object)"writeSubject")));
                    Assert.assertThat(actual, (Matcher)CommonMatchers.matchesOneToOneInAnyOrder((Matcher[])new Matcher[]{mapMatcher}));
                });
                continue;
            }
            finally {
                barrier.release();
                latch.finishAndWaitForAllToFinish();
                write.closeAndAssertSomeTermination();
                server.stop();
            }
        }
    }

    @Test
    public void shouldKillMultipleUserQueries() throws Throwable {
        DoubleLatch latch = new DoubleLatch(5);
        ThreadedTransaction<Object> read1 = new ThreadedTransaction<Object>(this.neo, latch);
        ThreadedTransaction<Object> read2 = new ThreadedTransaction<Object>(this.neo, latch);
        ThreadedTransaction<Object> read3 = new ThreadedTransaction<Object>(this.neo, latch);
        ThreadedTransaction<Object> write = new ThreadedTransaction<Object>(this.neo, latch);
        String q1 = read1.execute(this.threading, this.readSubject, "UNWIND [1,2,3] AS x RETURN x");
        String q2 = read2.execute(this.threading, this.readSubject, "UNWIND [4,5,6] AS y RETURN y");
        read3.execute(this.threading, this.readSubject, "UNWIND [7,8,9] AS z RETURN z");
        write.execute(this.threading, this.writeSubject, "UNWIND [11,12,13] AS q RETURN q");
        latch.startAndWaitForAllToStart();
        String id1 = this.extractQueryId(q1);
        String id2 = this.extractQueryId(q2);
        String idParam = "['" + id1 + "', '" + id2 + "']";
        this.assertSuccess(this.adminSubject, "CALL dbms.killQueries(" + idParam + ") YIELD username RETURN count(username) AS count, username", r -> {
            List actual = r.stream().collect(Collectors.toList());
            Matcher mapMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"count"), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)2), (Matcher)Matchers.equalTo((Object)2L))), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"username"), (Matcher)Matchers.equalTo((Object)"readSubject")));
            Assert.assertThat(actual, (Matcher)CommonMatchers.matchesOneToOneInAnyOrder((Matcher[])new Matcher[]{mapMatcher}));
        });
        latch.finishAndWaitForAllToFinish();
        read1.closeAndAssertExplicitTermination();
        read2.closeAndAssertExplicitTermination();
        read3.closeAndAssertSuccess();
        write.closeAndAssertSuccess();
        this.assertEmpty(this.adminSubject, "CALL dbms.listQueries() YIELD query WITH * WHERE NOT query CONTAINS 'listQueries' RETURN *");
    }

    String extractQueryId(String writeQuery) {
        return ((Map)Iterables.single((Iterable)this.collectSuccessResult(this.adminSubject, "CALL dbms.listQueries()").stream().filter(m -> m.get("query").equals(writeQuery)).collect(Collectors.toList()))).get("queryId").toString();
    }

    @Test
    public void shouldHaveSetTXMetaDataProcedure() throws Throwable {
        this.assertEmpty(this.writeSubject, "CALL dbms.setTXMetaData( { aKey: 'aValue' } )");
    }

    @Test
    public void readUpdatedMetadataValue() throws Throwable {
        String testValue = "testValue";
        String testKey = "test";
        GraphDatabaseFacade graph = this.neo.getLocalGraph();
        try (InternalTransaction transaction = this.neo.beginLocalTransactionAsUser(this.writeSubject, KernelTransaction.Type.explicit);){
            graph.execute("CALL dbms.setTXMetaData({" + testKey + ":'" + testValue + "'})");
            Map metadata = (Map)graph.execute("CALL dbms.getTXMetaData ").next().get("metadata");
            Assert.assertEquals((Object)testValue, metadata.get(testKey));
        }
    }

    @Test
    public void readEmptyMetadataInOtherTransaction() {
        String testValue = "testValue";
        String testKey = "test";
        this.assertEmpty(this.writeSubject, "CALL dbms.setTXMetaData({" + testKey + ":'" + testValue + "'})");
        this.assertSuccess(this.writeSubject, "CALL dbms.getTXMetaData", mapResourceIterator -> {
            Map metadata = (Map)mapResourceIterator.next();
            Assert.assertNull(metadata.get(testKey));
            mapResourceIterator.close();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTerminateLongRunningProcedureThatChecksTheGuardRegularlyIfKilled() throws Throwable {
        DoubleLatch latch;
        ProcedureInteractionTestBase.ClassWithProcedures.volatileLatch = latch = new DoubleLatch(2);
        String loopQuery = "CALL test.loop";
        new Thread(() -> this.assertFail(this.readSubject, loopQuery, "Explicitly terminated by the user.")).start();
        latch.startAndWaitForAllToStart();
        try {
            String loopId = this.extractQueryId(loopQuery);
            this.assertSuccess(this.adminSubject, "CALL dbms.killQuery('" + loopId + "') YIELD username RETURN count(username) AS count, username", r -> {
                List actual = r.stream().collect(Collectors.toList());
                Matcher mapMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"count"), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)1), (Matcher)Matchers.equalTo((Object)1L))), (Matcher)Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"username"), (Matcher)Matchers.equalTo((Object)"readSubject")));
                Assert.assertThat(actual, (Matcher)CommonMatchers.matchesOneToOneInAnyOrder((Matcher[])new Matcher[]{mapMatcher}));
            });
        }
        finally {
            latch.finishAndWaitForAllToFinish();
        }
        this.assertEmpty(this.adminSubject, "CALL dbms.listQueries() YIELD query WITH * WHERE NOT query CONTAINS 'listQueries' RETURN *");
    }

    @Test
    public void shouldHandleWriteAfterAllowedReadProcedureForWriteUser() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.userManager.addRoleToUser("publisher", "role1Subject");
        this.assertEmpty(this.neo.login("role1Subject", "abc"), "CALL test.allowedReadProcedure() YIELD value CREATE (:NEWNODE {name:value})");
    }

    @Test
    public void shouldNotAllowNonWriterToWriteAfterCallingAllowedWriteProc() throws Exception {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("nopermission", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "nopermission");
        this.assertSuccess(this.neo.login("nopermission", "abc"), "CALL test.allowedWriteProcedure()", itr -> Assert.assertEquals((long)itr.stream().collect(Collectors.toList()).size(), (long)2L));
        this.assertFail(this.neo.login("nopermission", "abc"), "CALL test.allowedWriteProcedure() YIELD value CREATE (:NEWNODE {name:value})", this.WRITE_OPS_NOT_ALLOWED);
    }

    @Test
    public void shouldNotAllowUnauthorizedAccessToProcedure() throws Exception {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("nopermission", "abc", false);
        this.assertFail(this.neo.login("nopermission", "abc"), "CALL test.staticReadProcedure()", this.READ_OPS_NOT_ALLOWED);
        this.assertFail(this.neo.login("nopermission", "abc"), "CALL test.staticWriteProcedure()", this.WRITE_OPS_NOT_ALLOWED);
        this.assertFail(this.neo.login("nopermission", "abc"), "CALL test.staticSchemaProcedure()", this.SCHEMA_OPS_NOT_ALLOWED);
    }

    @Test
    public void shouldNotAllowNonReaderToReadAfterCallingAllowedReadProc() throws Exception {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("nopermission", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "nopermission");
        this.assertSuccess(this.neo.login("nopermission", "abc"), "CALL test.allowedReadProcedure()", itr -> Assert.assertEquals((long)itr.stream().collect(Collectors.toList()).size(), (long)1L));
        this.assertFail(this.neo.login("nopermission", "abc"), "CALL test.allowedReadProcedure() YIELD value MATCH (n:Secret) RETURN n.pass", this.READ_OPS_NOT_ALLOWED);
    }

    @Test
    public void shouldHandleNestedReadProcedures() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.assertSuccess(this.neo.login("role1Subject", "abc"), "CALL test.nestedAllowedProcedure('test.allowedReadProcedure') YIELD value", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "value", "foo"));
    }

    @Test
    public void shouldHandleDoubleNestedReadProcedures() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.assertSuccess(this.neo.login("role1Subject", "abc"), "CALL test.doubleNestedAllowedProcedure YIELD value", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "value", "foo"));
    }

    @Test
    public void shouldFailNestedAllowedWriteProcedureFromAllowedReadProcedure() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.assertFail(this.neo.login("role1Subject", "abc"), "CALL test.nestedAllowedProcedure('test.allowedWriteProcedure') YIELD value", this.WRITE_OPS_NOT_ALLOWED);
    }

    @Test
    public void shouldFailNestedAllowedWriteProcedureFromAllowedReadProcedureEvenIfAdmin() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.userManager.addRoleToUser("admin", "role1Subject");
        this.assertFail(this.neo.login("role1Subject", "abc"), "CALL test.nestedAllowedProcedure('test.allowedWriteProcedure') YIELD value", this.WRITE_OPS_NOT_ALLOWED);
    }

    @Test
    public void shouldRestrictNestedReadProcedureFromAllowedWriteProcedures() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.assertFail(this.neo.login("role1Subject", "abc"), "CALL test.failingNestedAllowedWriteProcedure YIELD value", this.WRITE_OPS_NOT_ALLOWED);
    }

    @Test
    public void shouldHandleNestedReadProcedureWithDifferentAllowedRole() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.assertSuccess(this.neo.login("role1Subject", "abc"), "CALL test.nestedAllowedProcedure('test.otherAllowedReadProcedure') YIELD value", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "value", "foo"));
    }

    @Test
    public void shouldFailNestedAllowedWriteProcedureFromNormalReadProcedure() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.userManager.addRoleToUser("publisher", "role1Subject");
        this.assertFail(this.neo.login("role1Subject", "abc"), "CALL test.nestedReadProcedure('test.allowedWriteProcedure') YIELD value", this.WRITE_OPS_NOT_ALLOWED);
    }

    @Test
    public void shouldHandleFunctionWithAllowed() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.assertSuccess(this.neo.login("role1Subject", "abc"), "RETURN test.allowedFunction1() AS value", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "value", "foo"));
    }

    @Test
    public void shouldHandleNestedFunctionsWithAllowed() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.assertSuccess(this.neo.login("role1Subject", "abc"), "RETURN test.nestedAllowedFunction('test.allowedFunction1()') AS value", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "value", "foo"));
    }

    @Test
    public void shouldHandleNestedFunctionWithDifferentAllowedRole() throws Throwable {
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("role1Subject", "abc", false);
        this.userManager.newRole("role1", new String[0]);
        this.userManager.addRoleToUser("role1", "role1Subject");
        this.assertSuccess(this.neo.login("role1Subject", "abc"), "RETURN test.nestedAllowedFunction('test.allowedFunction2()') AS value", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "value", "foo"));
    }

    public void shouldTerminateTransactionForUser() throws Throwable {
        DoubleLatch latch = new DoubleLatch(2);
        ThreadedTransaction<Object> write = new ThreadedTransaction<Object>(this.neo, latch);
        write.executeCreateNode(this.threading, this.writeSubject);
        latch.startAndWaitForAllToStart();
        this.assertSuccess(this.adminSubject, "CALL dbms.terminateTransactionsForUser( 'writeSubject' )", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "transactionsTerminated", MapUtil.map((Object[])new Object[]{"writeSubject", "1"})));
        this.assertSuccess(this.adminSubject, "CALL dbms.listTransactions()", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "activeTransactions", MapUtil.map((Object[])new Object[]{"adminSubject", "1"})));
        latch.finishAndWaitForAllToFinish();
        write.closeAndAssertExplicitTermination();
        this.assertEmpty(this.adminSubject, "MATCH (n:Test) RETURN n.name AS name");
    }

    public void shouldTerminateOnlyGivenUsersTransaction() throws Throwable {
        DoubleLatch latch = new DoubleLatch(3);
        ThreadedTransaction<Object> schema = new ThreadedTransaction<Object>(this.neo, latch);
        ThreadedTransaction<Object> write = new ThreadedTransaction<Object>(this.neo, latch);
        schema.executeCreateNode(this.threading, this.schemaSubject);
        write.executeCreateNode(this.threading, this.writeSubject);
        latch.startAndWaitForAllToStart();
        this.assertSuccess(this.adminSubject, "CALL dbms.terminateTransactionsForUser( 'schemaSubject' )", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "transactionsTerminated", MapUtil.map((Object[])new Object[]{"schemaSubject", "1"})));
        this.assertSuccess(this.adminSubject, "CALL dbms.listTransactions()", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "activeTransactions", MapUtil.map((Object[])new Object[]{"adminSubject", "1", "writeSubject", "1"})));
        latch.finishAndWaitForAllToFinish();
        schema.closeAndAssertExplicitTermination();
        write.closeAndAssertSuccess();
        this.assertSuccess(this.adminSubject, "MATCH (n:Test) RETURN n.name AS name", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "name", "writeSubject-node"));
    }

    public void shouldTerminateAllTransactionsForGivenUser() throws Throwable {
        DoubleLatch latch = new DoubleLatch(3);
        ThreadedTransaction<Object> schema1 = new ThreadedTransaction<Object>(this.neo, latch);
        ThreadedTransaction<Object> schema2 = new ThreadedTransaction<Object>(this.neo, latch);
        schema1.executeCreateNode(this.threading, this.schemaSubject);
        schema2.executeCreateNode(this.threading, this.schemaSubject);
        latch.startAndWaitForAllToStart();
        this.assertSuccess(this.adminSubject, "CALL dbms.terminateTransactionsForUser( 'schemaSubject' )", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "transactionsTerminated", MapUtil.map((Object[])new Object[]{"schemaSubject", "2"})));
        this.assertSuccess(this.adminSubject, "CALL dbms.listTransactions()", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "activeTransactions", MapUtil.map((Object[])new Object[]{"adminSubject", "1"})));
        latch.finishAndWaitForAllToFinish();
        schema1.closeAndAssertExplicitTermination();
        schema2.closeAndAssertExplicitTermination();
        this.assertEmpty(this.adminSubject, "MATCH (n:Test) RETURN n.name AS name");
    }

    public void shouldNotTerminateTerminationTransaction() throws InterruptedException, ExecutionException {
        this.assertSuccess(this.adminSubject, "CALL dbms.terminateTransactionsForUser( 'adminSubject' )", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "transactionsTerminated", MapUtil.map((Object[])new Object[]{"adminSubject", "0"})));
        this.assertSuccess(this.readSubject, "CALL dbms.terminateTransactionsForUser( 'readSubject' )", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "transactionsTerminated", MapUtil.map((Object[])new Object[]{"readSubject", "0"})));
    }

    public void shouldTerminateSelfTransactionsExceptTerminationTransactionIfAdmin() throws Throwable {
        this.shouldTerminateSelfTransactionsExceptTerminationTransaction(this.adminSubject);
    }

    public void shouldTerminateSelfTransactionsExceptTerminationTransactionIfNotAdmin() throws Throwable {
        this.shouldTerminateSelfTransactionsExceptTerminationTransaction(this.writeSubject);
    }

    private void shouldTerminateSelfTransactionsExceptTerminationTransaction(S subject) throws Throwable {
        DoubleLatch latch = new DoubleLatch(2);
        ThreadedTransaction<S> create = new ThreadedTransaction<S>(this.neo, latch);
        create.executeCreateNode(this.threading, subject);
        latch.startAndWaitForAllToStart();
        String subjectName = this.neo.nameOf(subject);
        this.assertSuccess(subject, "CALL dbms.terminateTransactionsForUser( '" + subjectName + "' )", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "transactionsTerminated", MapUtil.map((Object[])new Object[]{subjectName, "1"})));
        latch.finishAndWaitForAllToFinish();
        create.closeAndAssertExplicitTermination();
        this.assertEmpty(this.adminSubject, "MATCH (n:Test) RETURN n.name AS name");
    }

    public void shouldNotTerminateTransactionsIfNonExistentUser() throws InterruptedException, ExecutionException {
        this.assertFail(this.adminSubject, "CALL dbms.terminateTransactionsForUser( 'Petra' )", "User 'Petra' does not exist");
        this.assertFail(this.adminSubject, "CALL dbms.terminateTransactionsForUser( '' )", "User '' does not exist");
    }

    public void shouldNotTerminateTransactionsIfNotAdmin() throws Throwable {
        DoubleLatch latch = new DoubleLatch(2);
        ThreadedTransaction<Object> write = new ThreadedTransaction<Object>(this.neo, latch);
        write.executeCreateNode(this.threading, this.writeSubject);
        latch.startAndWaitForAllToStart();
        this.assertFail(this.noneSubject, "CALL dbms.terminateTransactionsForUser( 'writeSubject' )", "Permission denied.");
        this.assertFail(this.pwdSubject, "CALL dbms.terminateTransactionsForUser( 'writeSubject' )", this.CHANGE_PWD_ERR_MSG);
        this.assertFail(this.readSubject, "CALL dbms.terminateTransactionsForUser( 'writeSubject' )", "Permission denied.");
        this.assertFail(this.schemaSubject, "CALL dbms.terminateTransactionsForUser( 'writeSubject' )", "Permission denied.");
        this.assertSuccess(this.adminSubject, "CALL dbms.listTransactions()", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "username", "adminSubject", "writeSubject"));
        latch.finishAndWaitForAllToFinish();
        write.closeAndAssertSuccess();
        this.assertSuccess(this.adminSubject, "MATCH (n:Test) RETURN n.name AS name", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "name", "writeSubject-node"));
    }

    public void shouldTerminateRestrictedTransaction() {
        DoubleLatch doubleLatch = new DoubleLatch(2);
        ProcedureInteractionTestBase.ClassWithProcedures.setTestLatch(new ProcedureInteractionTestBase.ClassWithProcedures.LatchedRunnables(doubleLatch, () -> {}, () -> {}));
        new Thread(() -> this.assertFail(this.writeSubject, "CALL test.waitForLatch()", "Explicitly terminated by the user.")).start();
        doubleLatch.startAndWaitForAllToStart();
        try {
            this.assertSuccess(this.adminSubject, "CALL dbms.terminateTransactionsForUser( 'writeSubject' )", r -> BuiltInProceduresInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "transactionsTerminated", MapUtil.map((Object[])new Object[]{"writeSubject", "1"})));
        }
        finally {
            doubleLatch.finishAndWaitForAllToFinish();
        }
    }

    private void assertQueryIsRunning(String query) throws InterruptedException {
        org.neo4j.test.assertion.Assert.assertEventually((String)"Query did not appear in dbms.listQueries output", () -> this.queryIsRunning(query), (Matcher)Matchers.equalTo((Object)true), (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private boolean queryIsRunning(String targetQuery) {
        String query = "CALL dbms.listQueries() YIELD query WITH query WHERE query = '" + targetQuery + "' RETURN 1";
        MutableBoolean resultIsNotEmpty = new MutableBoolean();
        this.neo.executeQuery(this.adminSubject, query, Collections.emptyMap(), itr -> resultIsNotEmpty.setValue(itr.hasNext()));
        return resultIsNotEmpty.booleanValue();
    }

    private int getLocalPort(Server server) {
        return ((ServerConnector)server.getConnectors()[0]).getLocalPort();
    }

    private Matcher<Map<String, Object>> listedQuery(OffsetDateTime startTime, String username, String query) {
        return Matchers.allOf(this.hasQuery(query), this.hasUsername(username), this.hasQueryId(), this.hasStartTimeAfter(startTime), this.hasNoParameters());
    }

    private Matcher<Map<String, Object>> listedQueryOfInteractionLevel(OffsetDateTime startTime, String username, String query) {
        return Matchers.allOf(this.hasQuery(query), this.hasUsername(username), this.hasQueryId(), this.hasStartTimeAfter(startTime), this.hasNoParameters(), this.hasProtocol(this.neo.getConnectionProtocol()));
    }

    private Matcher<Map<String, Object>> listedQueryWithMetaData(OffsetDateTime startTime, String username, String query, Map<String, Object> metaData) {
        return Matchers.allOf(this.hasQuery(query), this.hasUsername(username), this.hasQueryId(), this.hasStartTimeAfter(startTime), this.hasNoParameters(), this.hasMetaData(metaData));
    }

    private Matcher<Map<String, Object>> hasQuery(String query) {
        return Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"query"), (Matcher)Matchers.equalTo((Object)query));
    }

    private Matcher<Map<String, Object>> hasUsername(String username) {
        return Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"username"), (Matcher)Matchers.equalTo((Object)username));
    }

    private Matcher<Map<String, Object>> hasQueryId() {
        return Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"queryId"), (Matcher)Matchers.allOf((Matcher)Matchers.isA(String.class), (Matcher)CoreMatchers.containsString((String)"query-")));
    }

    private Matcher<Map<String, Object>> hasStartTimeAfter(final OffsetDateTime startTime) {
        return Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"startTime"), (Matcher)new BaseMatcher<String>(){

            public void describeTo(Description description) {
                description.appendText("should be after " + startTime.toString());
            }

            public boolean matches(Object item) {
                OffsetDateTime otherTime = OffsetDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(item.toString()));
                return startTime.compareTo(otherTime) <= 0;
            }
        });
    }

    private Matcher<Map<String, Object>> hasNoParameters() {
        return Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"parameters"), (Matcher)Matchers.equalTo(Collections.emptyMap()));
    }

    private Matcher<Map<String, Object>> hasProtocol(String expected) {
        return Matchers.hasEntry((Object)"protocol", (Object)expected);
    }

    private Matcher<Map<String, Object>> hasMetaData(Map<String, Object> expected) {
        return Matchers.hasEntry((Matcher)Matchers.equalTo((Object)"metaData"), (Matcher)Matchers.allOf((Iterable)expected.entrySet().stream().map(this.entryMapper()).collect(Collectors.toList())));
    }

    private Function<Map.Entry<String, Object>, Matcher<Map.Entry<String, Object>>> entryMapper() {
        return entry -> {
            Matcher keyMatcher = Matchers.equalTo(entry.getKey());
            Matcher valueMatcher = Matchers.equalTo(entry.getValue());
            return Matchers.hasEntry((Matcher)keyMatcher, (Matcher)valueMatcher);
        };
    }
}

