/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.security.enterprise.auth.ProcedureInteractionTestBase;
import org.neo4j.server.security.enterprise.auth.StandardEnterpriseSecurityContext;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;

public abstract class ConfiguredAuthScenariosInteractionTestBase<S>
extends ProcedureInteractionTestBase<S> {
    private Map<String, Object> userList = MapUtil.map((Object[])new Object[]{"adminSubject", this.listOf("admin"), "readSubject", this.listOf("reader"), "schemaSubject", this.listOf("architect"), "writeSubject", this.listOf("publisher"), "editorSubject", this.listOf("editor"), "pwdSubject", this.listOf(new String[0]), "noneSubject", this.listOf(new String[0]), "neo4j", this.listOf("admin")});

    @Override
    public void setUp() throws Throwable {
    }

    @Test
    public void shouldAllowRoleCallCreateNewTokensProceduresWhenConfigured() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.default_allowed.name(), "role1"}));
        this.userManager.newRole("role1", new String[]{"noneSubject"});
        this.assertEmpty(this.noneSubject, "CALL db.createLabel('MySpecialLabel')");
        this.assertEmpty(this.noneSubject, "CALL db.createRelationshipType('MySpecialRelationship')");
        this.assertEmpty(this.noneSubject, "CALL db.createProperty('MySpecialProperty')");
    }

    @Test
    public void shouldWarnWhenUsingNativeAndOtherProvider() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.auth_providers.name(), "native ,LDAP"}));
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listUsers", r -> ConfiguredAuthScenariosInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "roles", this.userList));
        GraphDatabaseFacade localGraph = this.neo.getLocalGraph();
        InternalTransaction transaction = localGraph.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)StandardEnterpriseSecurityContext.AUTH_DISABLED);
        Result result = localGraph.execute(transaction, "EXPLAIN CALL dbms.security.listUsers", Collections.emptyMap());
        String description = String.format("%s (%s)", Status.Procedure.ProcedureWarning.code().description(), "dbms.security.listUsers only applies to native users.");
        MatcherAssert.assertThat((Object)this.containsNotification(result, description), (Matcher)Matchers.equalTo((Object)true));
        transaction.success();
        transaction.close();
    }

    @Test
    public void shouldNotWarnWhenOnlyUsingNativeProvider() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.auth_provider.name(), "native"}));
        this.assertSuccess(this.adminSubject, "CALL dbms.security.listUsers", r -> ConfiguredAuthScenariosInteractionTestBase.assertKeyIsMap((ResourceIterator<Map<String, Object>>)r, "username", "roles", this.userList));
        GraphDatabaseFacade localGraph = this.neo.getLocalGraph();
        InternalTransaction transaction = localGraph.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)StandardEnterpriseSecurityContext.AUTH_DISABLED);
        Result result = localGraph.execute(transaction, "EXPLAIN CALL dbms.security.listUsers", Collections.emptyMap());
        String description = String.format("%s (%s)", Status.Procedure.ProcedureWarning.code().description(), "dbms.security.listUsers only applies to native users.");
        MatcherAssert.assertThat((Object)this.containsNotification(result, description), (Matcher)Matchers.equalTo((Object)false));
        transaction.success();
        transaction.close();
    }

    private boolean containsNotification(Result result, String description) {
        Iterator itr = result.getNotifications().iterator();
        boolean found = false;
        while (itr.hasNext()) {
            found |= ((Notification)itr.next()).getDescription().equals(description);
        }
        return found;
    }
}

