/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.internal.util.collections.Sets;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.proc.QualifiedName;
import org.neo4j.kernel.api.proc.UserFunctionSignature;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.server.security.enterprise.auth.ProcedureInteractionTestBase;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;

public abstract class ConfiguredProceduresTestBase<S>
extends ProcedureInteractionTestBase<S> {
    @Override
    public void setUp() throws Throwable {
    }

    @Test
    public void shouldTerminateLongRunningProcedureThatChecksTheGuardRegularlyOnTimeout() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.transaction_timeout.name(), "2s"}));
        this.assertFail(this.adminSubject, "CALL test.loop", "Transaction guard check failed");
        Result result = this.neo.getLocalGraph().execute("CALL dbms.listQueries() YIELD query WITH * WHERE NOT query CONTAINS 'listQueries' RETURN *");
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void shouldSetAllowedToConfigSetting() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.default_allowed.name(), "nonEmpty"}));
        Procedures procedures = (Procedures)this.neo.getLocalGraph().getDependencyResolver().resolveDependency(Procedures.class);
        ProcedureSignature numNodes = procedures.procedure(new QualifiedName(new String[]{"test"}, "numNodes"));
        MatcherAssert.assertThat(Arrays.asList(numNodes.allowed()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"nonEmpty"}));
    }

    @Test
    public void shouldSetAllowedToDefaultValueAndRunningWorks() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.default_allowed.name(), "role1"}));
        this.userManager.newRole("role1", new String[]{"noneSubject"});
        this.assertSuccess(this.noneSubject, "CALL test.numNodes", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "count", "3"));
    }

    @Test
    public void shouldRunProcedureWithMatchingWildcardAllowed() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.procedure_roles.name(), "test.*:role1"}));
        this.userManager.newRole("role1", new String[]{"noneSubject"});
        this.assertSuccess(this.noneSubject, "CALL test.numNodes", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "count", "3"));
    }

    @Test
    public void shouldNotRunProcedureWithMismatchingWildCardAllowed() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.procedure_roles.name(), "tes.*:role1"}));
        this.userManager.newRole("role1", new String[]{"noneSubject"});
        Procedures procedures = (Procedures)this.neo.getLocalGraph().getDependencyResolver().resolveDependency(Procedures.class);
        ProcedureSignature numNodes = procedures.procedure(new QualifiedName(new String[]{"test"}, "numNodes"));
        MatcherAssert.assertThat(Arrays.asList(numNodes.allowed()), (Matcher)Matchers.empty());
        this.assertFail(this.noneSubject, "CALL test.numNodes", "Read operations are not allowed");
    }

    @Test
    public void shouldNotSetProcedureAllowedIfSettingNotSet() throws Throwable {
        this.configuredSetup(this.defaultConfiguration());
        Procedures procedures = (Procedures)this.neo.getLocalGraph().getDependencyResolver().resolveDependency(Procedures.class);
        ProcedureSignature numNodes = procedures.procedure(new QualifiedName(new String[]{"test"}, "numNodes"));
        MatcherAssert.assertThat(Arrays.asList(numNodes.allowed()), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldSetAllowedToConfigSettingForUDF() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.default_allowed.name(), "nonEmpty"}));
        Procedures procedures = (Procedures)this.neo.getLocalGraph().getDependencyResolver().resolveDependency(Procedures.class);
        UserFunctionSignature funcSig = (UserFunctionSignature)procedures.function(new QualifiedName(new String[]{"test"}, "nonAllowedFunc")).get();
        MatcherAssert.assertThat(Arrays.asList(funcSig.allowed()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"nonEmpty"}));
    }

    @Test
    public void shouldSetAllowedToDefaultValueAndRunningWorksForUDF() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.default_allowed.name(), "role1"}));
        this.userManager.newRole("role1", new String[]{"noneSubject"});
        this.assertSuccess(this.neo.login("noneSubject", "abc"), "RETURN test.allowedFunc() AS c", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "c", "success for role1"));
    }

    @Test
    public void shouldNotSetProcedureAllowedIfSettingNotSetForUDF() throws Throwable {
        this.configuredSetup(this.defaultConfiguration());
        Procedures procedures = (Procedures)this.neo.getLocalGraph().getDependencyResolver().resolveDependency(Procedures.class);
        UserFunctionSignature funcSig = (UserFunctionSignature)procedures.function(new QualifiedName(new String[]{"test"}, "nonAllowedFunc")).get();
        MatcherAssert.assertThat(Arrays.asList(funcSig.allowed()), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldSetWildcardRoleConfigOnlyIfNotAnnotated() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.procedure_roles.name(), "test.*:tester"}));
        this.userManager.newRole("tester", new String[]{"noneSubject"});
        this.assertSuccess(this.noneSubject, "CALL test.numNodes", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "count", "3"));
    }

    @Test
    public void shouldSetAllMatchingWildcardRoleConfigs() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.procedure_roles.name(), "test.*:tester;test.create*:other"}));
        this.userManager.newRole("tester", new String[]{"noneSubject"});
        this.userManager.newRole("other", new String[]{"readSubject"});
        this.assertSuccess(this.readSubject, "CALL test.allowedReadProcedure", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "value", "foo"));
        this.assertSuccess(this.noneSubject, "CALL test.createNode", ResourceIterator::close);
        this.assertSuccess(this.readSubject, "CALL test.createNode", ResourceIterator::close);
        this.assertSuccess(this.noneSubject, "CALL test.numNodes", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "count", "5"));
    }

    @Test
    public void shouldSetAllMatchingWildcardRoleConfigsWithDefaultForUDFs() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.procedure_roles.name(), "test.*:tester;test.create*:other", SecuritySettings.default_allowed.name(), "default"}));
        this.userManager.newRole("tester", new String[]{"noneSubject"});
        this.userManager.newRole("default", new String[]{"noneSubject"});
        this.userManager.newRole("other", new String[]{"readSubject"});
        this.assertSuccess(this.noneSubject, "RETURN test.nonAllowedFunc() AS f", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "f", "success"));
        this.assertSuccess(this.readSubject, "RETURN test.allowedFunction1() AS f", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "f", "foo"));
        this.assertSuccess(this.readSubject, "RETURN test.nonAllowedFunc() AS f", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "f", "success"));
    }

    @Test
    public void shouldHandleWriteAfterAllowedReadProcedureWithAuthDisabled() throws Throwable {
        this.neo = this.setUpNeoServer(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.auth_enabled.name(), "false"}));
        ((Procedures)this.neo.getLocalGraph().getDependencyResolver().resolveDependency(Procedures.class)).registerProcedure(ProcedureInteractionTestBase.ClassWithProcedures.class);
        Object subject = this.neo.login("no_auth", "");
        this.assertEmpty(subject, "CALL test.allowedReadProcedure() YIELD value CREATE (:NewNode {name: value})");
    }

    @Test
    public void shouldHandleMultipleRolesSpecifiedForMapping() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.procedure_roles.name(), "test.*:tester, other"}));
        this.userManager.newRole("tester", new String[]{"noneSubject"});
        this.userManager.newRole("other", new String[]{"readSubject"});
        this.assertSuccess(this.readSubject, "CALL test.createNode", ResourceIterator::close);
        this.assertSuccess(this.noneSubject, "CALL test.numNodes", itr -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)itr, "count", "4"));
    }

    @Test
    public void shoulListCorrectRolesForDBMSProcedures() throws Throwable {
        this.configuredSetup(this.defaultConfiguration());
        Map expected = MapUtil.genericMap((Object[])new Object[]{"dbms.changePassword", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.functions", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.killQueries", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.killQuery", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.listActiveLocks", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.listConfig", Sets.newSet((Object[])new String[]{"admin"}), "dbms.listQueries", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.procedures", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.security.activateUser", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.addRoleToUser", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.changePassword", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.security.changeUserPassword", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.clearAuthCache", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.createRole", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.createUser", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.deleteRole", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.deleteUser", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.listRoles", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.listRolesForUser", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.listUsers", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.listUsersForRole", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.removeRoleFromUser", Sets.newSet((Object[])new String[]{"admin"}), "dbms.security.showCurrentUser", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.showCurrentUser", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"}), "dbms.security.suspendUser", Sets.newSet((Object[])new String[]{"admin"}), "dbms.setTXMetaData", Sets.newSet((Object[])new String[]{"reader", "editor", "publisher", "architect", "admin"})});
        this.assertListProceduresHasRoles(this.readSubject, expected, "CALL dbms.procedures");
    }

    @Test
    public void shouldShowAllowedRolesWhenListingProcedures() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.procedure_roles.name(), "test.numNodes:counter,user", SecuritySettings.default_allowed.name(), "default"}));
        Map expected = MapUtil.genericMap((Object[])new Object[]{"test.staticReadProcedure", Sets.newSet((Object[])new String[]{"default", "reader", "editor", "publisher", "architect", "admin"}), "test.staticWriteProcedure", Sets.newSet((Object[])new String[]{"default", "editor", "publisher", "architect", "admin"}), "test.staticSchemaProcedure", Sets.newSet((Object[])new String[]{"default", "architect", "admin"}), "test.annotatedProcedure", Sets.newSet((Object[])new String[]{"annotated", "reader", "editor", "publisher", "architect", "admin"}), "test.numNodes", Sets.newSet((Object[])new String[]{"counter", "user", "reader", "editor", "publisher", "architect", "admin"}), "db.labels", Sets.newSet((Object[])new String[]{"default", "reader", "editor", "publisher", "architect", "admin"}), "dbms.security.changePassword", Sets.newSet((Object[])new String[]{"default", "reader", "editor", "publisher", "architect", "admin"}), "dbms.procedures", Sets.newSet((Object[])new String[]{"default", "reader", "editor", "publisher", "architect", "admin"}), "dbms.listQueries", Sets.newSet((Object[])new String[]{"default", "reader", "editor", "publisher", "architect", "admin"}), "dbms.security.createUser", Sets.newSet((Object[])new String[]{"admin"}), "db.createLabel", Sets.newSet((Object[])new String[]{"default", "editor", "publisher", "architect", "admin"})});
        String call = "CALL dbms.procedures";
        this.assertListProceduresHasRoles(this.adminSubject, expected, call);
        this.assertListProceduresHasRoles(this.schemaSubject, expected, call);
        this.assertListProceduresHasRoles(this.writeSubject, expected, call);
        this.assertListProceduresHasRoles(this.readSubject, expected, call);
    }

    @Test
    public void shouldShowAllowedRolesWhenListingFunctions() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{SecuritySettings.procedure_roles.name(), "test.allowedFunc:counter,user", SecuritySettings.default_allowed.name(), "default"}));
        Map expected = MapUtil.genericMap((Object[])new Object[]{"test.annotatedFunction", Sets.newSet((Object[])new String[]{"annotated", "reader", "editor", "publisher", "architect", "admin"}), "test.allowedFunc", Sets.newSet((Object[])new String[]{"counter", "user", "reader", "editor", "publisher", "architect", "admin"}), "test.nonAllowedFunc", Sets.newSet((Object[])new String[]{"default", "reader", "editor", "publisher", "architect", "admin"})});
        String call = "CALL dbms.functions";
        this.assertListProceduresHasRoles(this.adminSubject, expected, call);
        this.assertListProceduresHasRoles(this.schemaSubject, expected, call);
        this.assertListProceduresHasRoles(this.writeSubject, expected, call);
        this.assertListProceduresHasRoles(this.readSubject, expected, call);
    }

    @Test
    public void shouldGiveNiceMessageAtFailWhenTryingToKill() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.kill_query_verbose.name(), "true"}));
        String query = "CALL dbms.killQuery('query-9999999999')";
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("queryId", "query-9999999999");
        expected.put("username", "n/a");
        expected.put("message", "No Query found with this id");
        this.assertSuccess(this.adminSubject, query, r -> Assert.assertThat((Object)r.next(), (Matcher)Matchers.equalTo((Object)expected)));
    }

    @Test
    public void shouldNotGiveNiceMessageAtFailWhenTryingToKillWhenConfigured() throws Throwable {
        super.setUp();
        String query = "CALL dbms.killQuery('query-9999999999')";
        this.assertSuccess(this.adminSubject, query, r -> Assert.assertThat((Object)r.hasNext(), (Matcher)Is.is((Object)false)));
    }

    @Test
    public void shouldGiveNiceMessageAtFailWhenTryingToKillMoreThenOne() throws Throwable {
        this.configuredSetup(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.kill_query_verbose.name(), "true"}));
        String query = "CALL dbms.killQueries(['query-9999999999', 'query-9999999989'])";
        HashSet expected = new HashSet();
        HashMap<String, String> firstResultExpected = new HashMap<String, String>();
        firstResultExpected.put("queryId", "query-9999999989");
        firstResultExpected.put("username", "n/a");
        firstResultExpected.put("message", "No Query found with this id");
        HashMap<String, String> secoundResultExpected = new HashMap<String, String>();
        secoundResultExpected.put("queryId", "query-9999999999");
        secoundResultExpected.put("username", "n/a");
        secoundResultExpected.put("message", "No Query found with this id");
        expected.add(firstResultExpected);
        expected.add(secoundResultExpected);
        this.assertSuccess(this.adminSubject, query, r -> {
            Set actual = r.stream().collect(Collectors.toSet());
            Assert.assertThat(actual, (Matcher)Matchers.equalTo((Object)expected));
        });
    }

    private void assertListProceduresHasRoles(S subject, Map<String, Set<String>> expected, String call) {
        this.assertSuccess(subject, call, itr -> {
            List failures = itr.stream().filter(record -> {
                String name = record.get("name").toString();
                List roles = (List)record.get("roles");
                return expected.containsKey(name) && !((Set)expected.get(name)).equals(new HashSet(roles));
            }).map(record -> {
                String name = record.get("name").toString();
                return name + ": expected '" + expected.get(name) + "' but was '" + record.get("roles") + "'";
            }).collect(Collectors.toList());
            MatcherAssert.assertThat((String)("Expectations violated: " + failures.toString()), (boolean)failures.isEmpty());
        });
    }
}

