/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.security.enterprise.auth.BuiltInProceduresInteractionTestBase;
import org.neo4j.server.security.enterprise.auth.EmbeddedInteraction;
import org.neo4j.server.security.enterprise.auth.NeoInteractionLevel;
import org.neo4j.server.security.enterprise.auth.ThreadedTransaction;
import org.neo4j.test.DoubleLatch;

public class EmbeddedBuiltInProceduresInteractionTest
extends BuiltInProceduresInteractionTestBase<EnterpriseSecurityContext> {
    @Override
    protected NeoInteractionLevel<EnterpriseSecurityContext> setUpNeoServer(Map<String, String> config) throws Throwable {
        return new EmbeddedInteraction(config);
    }

    @Test
    public void shouldNotListAnyQueriesIfNotAuthenticated() {
        GraphDatabaseFacade graph = this.neo.getLocalGraph();
        try (InternalTransaction tx = graph.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.none());){
            Result result = graph.execute(tx, "CALL dbms.listQueries", Collections.emptyMap());
            Assert.assertFalse((boolean)result.hasNext());
            tx.success();
        }
    }

    @Test
    public void shouldNotKillQueryIfNotAuthenticated() throws Throwable {
        EnterpriseSecurityContext authy = this.createFakeAnonymousEnterpriseSecurityContext();
        GraphDatabaseFacade graph = this.neo.getLocalGraph();
        DoubleLatch latch = new DoubleLatch(2);
        ThreadedTransaction<EnterpriseSecurityContext> read = new ThreadedTransaction<EnterpriseSecurityContext>(this.neo, latch);
        String query = read.execute(this.threading, authy, "UNWIND [1,2,3] AS x RETURN x");
        latch.startAndWaitForAllToStart();
        String id = this.extractQueryId(query);
        try {
            InternalTransaction tx = graph.beginTransaction(KernelTransaction.Type.explicit, (SecurityContext)AnonymousContext.none());
            Throwable throwable = null;
            try {
                try {
                    graph.execute(tx, "CALL dbms.killQuery('" + id + "')", Collections.emptyMap());
                    throw new AssertionError((Object)"Expected exception to be thrown");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        tx.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (QueryExecutionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Permission denied."));
            latch.finishAndWaitForAllToFinish();
            read.closeAndAssertSuccess();
            return;
        }
    }

    private EnterpriseSecurityContext createFakeAnonymousEnterpriseSecurityContext() {
        return new EnterpriseSecurityContext(){
            AnonymousContext inner = AnonymousContext.none();

            public EnterpriseSecurityContext freeze() {
                return this;
            }

            public EnterpriseSecurityContext withMode(AccessMode mode) {
                return new EnterpriseSecurityContext.Frozen(this.subject(), mode, this.roles(), this.isAdmin());
            }

            public Set<String> roles() {
                return Collections.emptySet();
            }

            public AuthSubject subject() {
                return this.inner.subject();
            }

            public AccessMode mode() {
                return this.inner.mode();
            }

            public boolean isAdmin() {
                return false;
            }
        };
    }
}

