/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ssl.LegacySslPolicyConfig;
import org.neo4j.kernel.enterprise.api.security.EnterpriseAuthManager;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.enterprise.auth.EnterpriseAuthAndUserManager;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.NeoInteractionLevel;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;

public class EmbeddedInteraction
implements NeoInteractionLevel<EnterpriseSecurityContext> {
    private GraphDatabaseFacade db;
    private EnterpriseAuthManager authManager;
    private FileSystemAbstraction fileSystem;

    EmbeddedInteraction(Map<String, String> config) throws Throwable {
        this(config, EphemeralFileSystemAbstraction::new);
    }

    EmbeddedInteraction(Map<String, String> config, Supplier<FileSystemAbstraction> fileSystemSupplier) throws Throwable {
        TestEnterpriseGraphDatabaseFactory factory = new TestEnterpriseGraphDatabaseFactory();
        factory.setFileSystem(fileSystemSupplier.get());
        GraphDatabaseBuilder builder = factory.newImpermanentDatabaseBuilder();
        this.fileSystem = factory.getFileSystem();
        this.init(builder, config);
    }

    public EmbeddedInteraction(GraphDatabaseBuilder builder, Map<String, String> config) throws Throwable {
        this.init(builder, config);
    }

    private void init(GraphDatabaseBuilder builder, Map<String, String> config) throws Throwable {
        builder.setConfig(new BoltConnector((String)"bolt").type, "BOLT");
        builder.setConfig(new BoltConnector((String)"bolt").enabled, "true");
        builder.setConfig(new BoltConnector((String)"bolt").encryption_level, BoltConnector.EncryptionLevel.OPTIONAL.name());
        builder.setConfig(LegacySslPolicyConfig.tls_key_file, NeoInteractionLevel.tempPath("key", ".key"));
        builder.setConfig(LegacySslPolicyConfig.tls_certificate_file, NeoInteractionLevel.tempPath("cert", ".cert"));
        builder.setConfig(GraphDatabaseSettings.auth_enabled, "true");
        builder.setConfig(config);
        this.db = (GraphDatabaseFacade)builder.newGraphDatabase();
        this.authManager = (EnterpriseAuthManager)this.db.getDependencyResolver().resolveDependency(EnterpriseAuthManager.class);
    }

    @Override
    public EnterpriseUserManager getLocalUserManager() throws Exception {
        if (this.authManager instanceof EnterpriseAuthAndUserManager) {
            return ((EnterpriseAuthAndUserManager)this.authManager).getUserManager();
        }
        throw new Exception("The configuration used does not have a user manager");
    }

    @Override
    public GraphDatabaseFacade getLocalGraph() {
        return this.db;
    }

    @Override
    public FileSystemAbstraction fileSystem() {
        return this.fileSystem;
    }

    @Override
    public InternalTransaction beginLocalTransactionAsUser(EnterpriseSecurityContext subject, KernelTransaction.Type txType) throws Throwable {
        return this.db.beginTransaction(txType, (SecurityContext)subject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String executeQuery(EnterpriseSecurityContext subject, String call, Map<String, Object> params, Consumer<ResourceIterator<Map<String, Object>>> resultConsumer) {
        try (InternalTransaction tx = this.db.beginTransaction(KernelTransaction.Type.implicit, (SecurityContext)subject);){
            Map<Object, Object> p = params == null ? Collections.emptyMap() : params;
            resultConsumer.accept((ResourceIterator<Map<String, Object>>)this.db.execute(call, p));
            tx.success();
            String string = "";
            return string;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public EnterpriseSecurityContext login(String username, String password) throws Exception {
        return this.authManager.login(SecurityTestUtils.authToken((String)username, (String)password));
    }

    @Override
    public void logout(EnterpriseSecurityContext securityContext) {
        securityContext.subject().logout();
    }

    @Override
    public void updateAuthToken(EnterpriseSecurityContext subject, String username, String password) {
    }

    @Override
    public String nameOf(EnterpriseSecurityContext securityContext) {
        return securityContext.subject().username();
    }

    @Override
    public void tearDown() throws Throwable {
        this.db.shutdown();
    }

    @Override
    public void assertAuthenticated(EnterpriseSecurityContext securityContext) {
        Assert.assertThat((Object)securityContext.subject().getAuthenticationResult(), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Override
    public void assertPasswordChangeRequired(EnterpriseSecurityContext securityContext) {
        Assert.assertThat((Object)securityContext.subject().getAuthenticationResult(), (Matcher)Matchers.equalTo((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED));
    }

    @Override
    public void assertInitFailed(EnterpriseSecurityContext securityContext) {
        Assert.assertThat((Object)securityContext.subject().getAuthenticationResult(), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Override
    public void assertSessionKilled(EnterpriseSecurityContext subject) {
    }

    @Override
    public String getConnectionProtocol() {
        return "embedded";
    }
}

