/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.time.Clock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManagerRule;

public class EnterpriseSecurityContextDescriptionTest {
    @Rule
    public MultiRealmAuthManagerRule authManagerRule = new MultiRealmAuthManagerRule((UserRepository)new InMemoryUserRepository(), (AuthenticationStrategy)new RateLimitedAuthenticationStrategy(Clock.systemUTC(), 3));
    private EnterpriseSecurityContext context;
    private EnterpriseUserManager manager;

    @Before
    public void setUp() throws Throwable {
        this.authManagerRule.getManager().start();
        this.manager = this.authManagerRule.getManager().getUserManager();
        this.manager.newUser("mats", "foo", false);
        this.context = this.authManagerRule.getManager().login(SecurityTestUtils.authToken((String)"mats", (String)"foo"));
    }

    @Test
    public void shouldMakeNiceDescriptionWithoutRoles() throws Throwable {
        Assert.assertThat((Object)this.context.description(), (Matcher)Matchers.equalTo((Object)"user 'mats' with no roles"));
    }

    @Test
    public void shouldMakeNiceDescriptionWithRoles() throws Throwable {
        this.manager.newRole("role1", new String[]{"mats"});
        this.manager.addRoleToUser("publisher", "mats");
        Assert.assertThat((Object)this.context.description(), (Matcher)Matchers.equalTo((Object)"user 'mats' with roles [publisher,role1]"));
    }

    @Test
    public void shouldMakeNiceDescriptionFrozen() throws Throwable {
        this.manager.newRole("role1", new String[]{"mats"});
        this.manager.addRoleToUser("publisher", "mats");
        EnterpriseSecurityContext frozen = this.context.freeze();
        Assert.assertThat((Object)frozen.description(), (Matcher)Matchers.equalTo((Object)"user 'mats' with roles [publisher,role1]"));
    }

    @Test
    public void shouldMakeNiceDescriptionWithMode() throws Throwable {
        this.manager.newRole("role1", new String[]{"mats"});
        this.manager.addRoleToUser("publisher", "mats");
        EnterpriseSecurityContext modified = this.context.withMode((AccessMode)AccessMode.Static.CREDENTIALS_EXPIRED);
        Assert.assertThat((Object)modified.description(), (Matcher)Matchers.equalTo((Object)"user 'mats' with CREDENTIALS_EXPIRED"));
    }

    @Test
    public void shouldMakeNiceDescriptionRestricted() throws Throwable {
        this.manager.newRole("role1", new String[]{"mats"});
        this.manager.addRoleToUser("publisher", "mats");
        EnterpriseSecurityContext restricted = this.context.withMode((AccessMode)new RestrictedAccessMode(this.context.mode(), (AccessMode)AccessMode.Static.READ));
        Assert.assertThat((Object)restricted.description(), (Matcher)Matchers.equalTo((Object)"user 'mats' with roles [publisher,role1] restricted to READ"));
    }

    @Test
    public void shouldMakeNiceDescriptionOverridden() throws Throwable {
        this.manager.newRole("role1", new String[]{"mats"});
        this.manager.addRoleToUser("publisher", "mats");
        EnterpriseSecurityContext overridden = this.context.withMode((AccessMode)new OverriddenAccessMode(this.context.mode(), (AccessMode)AccessMode.Static.READ));
        Assert.assertThat((Object)overridden.description(), (Matcher)Matchers.equalTo((Object)"user 'mats' with roles [publisher,role1] overridden by READ"));
    }

    @Test
    public void shouldMakeNiceDescriptionAuthDisabled() throws Throwable {
        EnterpriseSecurityContext disabled = EnterpriseSecurityContext.AUTH_DISABLED;
        Assert.assertThat((Object)disabled.description(), (Matcher)Matchers.equalTo((Object)"AUTH_DISABLED with FULL"));
    }

    @Test
    public void shouldMakeNiceDescriptionAuthDisabledAndRestricted() throws Throwable {
        EnterpriseSecurityContext disabled = EnterpriseSecurityContext.AUTH_DISABLED;
        EnterpriseSecurityContext restricted = disabled.withMode((AccessMode)new RestrictedAccessMode(disabled.mode(), (AccessMode)AccessMode.Static.READ));
        Assert.assertThat((Object)restricted.description(), (Matcher)Matchers.equalTo((Object)"AUTH_DISABLED with FULL restricted to READ"));
    }
}

