/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.time.Duration;
import java.util.Arrays;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.security.enterprise.auth.EnterpriseSecurityModule;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class EnterpriseSecurityModuleTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private Config config;
    private LogProvider mockLogProvider;

    @Test
    public void shouldFailOnIllegalRealmNameConfiguration() {
        this.nativeAuth(true, true);
        this.ldapAuth(true, true);
        this.pluginAuth(false, false);
        this.authProviders("this-realm-does-not-exist");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Illegal configuration: No valid auth provider is active.");
        new EnterpriseSecurityModule().newAuthManager(this.config, this.mockLogProvider, (SecurityLog)Mockito.mock(SecurityLog.class), null, null);
    }

    @Test
    public void shouldFailOnNoAuthenticationMechanism() {
        this.nativeAuth(false, true);
        this.ldapAuth(false, false);
        this.pluginAuth(false, false);
        this.authProviders("native");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Illegal configuration: All authentication providers are disabled.");
        new EnterpriseSecurityModule().newAuthManager(this.config, this.mockLogProvider, (SecurityLog)Mockito.mock(SecurityLog.class), null, null);
    }

    @Test
    public void shouldFailOnNoAuthorizationMechanism() {
        this.nativeAuth(true, false);
        this.ldapAuth(false, false);
        this.pluginAuth(false, false);
        this.authProviders("native");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Illegal configuration: All authorization providers are disabled.");
        new EnterpriseSecurityModule().newAuthManager(this.config, this.mockLogProvider, (SecurityLog)Mockito.mock(SecurityLog.class), null, null);
    }

    @Test
    public void shouldFailOnIllegalAdvancedRealmConfiguration() {
        this.nativeAuth(false, false);
        this.ldapAuth(false, false);
        this.pluginAuth(true, true);
        this.authProviders("native", "ldap");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Illegal configuration: Native auth provider configured, but both authentication and authorization are disabled.");
        new EnterpriseSecurityModule().newAuthManager(this.config, this.mockLogProvider, (SecurityLog)Mockito.mock(SecurityLog.class), null, null);
    }

    @Test
    public void shouldFailOnNotLoadedPluginAuthProvider() {
        this.nativeAuth(false, false);
        this.ldapAuth(false, false);
        this.pluginAuth(true, true);
        this.authProviders("plugin-TestAuthenticationPlugin", "plugin-IllConfiguredAuthorizationPlugin");
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Illegal configuration: Failed to load auth plugin 'plugin-IllConfiguredAuthorizationPlugin'.");
        new EnterpriseSecurityModule().newAuthManager(this.config, this.mockLogProvider, (SecurityLog)Mockito.mock(SecurityLog.class), null, null);
    }

    @Test
    public void shouldNotFailNativeWithPluginAuthorizationProvider() {
        this.nativeAuth(true, true);
        this.ldapAuth(false, false);
        this.pluginAuth(true, true);
        this.authProviders("native", "plugin-TestAuthorizationPlugin");
        new EnterpriseSecurityModule().newAuthManager(this.config, this.mockLogProvider, (SecurityLog)Mockito.mock(SecurityLog.class), null, null);
    }

    @Before
    public void setup() {
        this.config = (Config)Mockito.mock(Config.class);
        this.mockLogProvider = (LogProvider)Mockito.mock(LogProvider.class);
        Log mockLog = (Log)Mockito.mock(Log.class);
        Mockito.when((Object)this.mockLogProvider.getLog(Matchers.anyString())).thenReturn((Object)mockLog);
        Mockito.when((Object)mockLog.isDebugEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.config.get(SecuritySettings.auth_cache_ttl)).thenReturn((Object)Duration.ZERO);
        Mockito.when((Object)this.config.get(SecuritySettings.auth_cache_max_capacity)).thenReturn((Object)10);
        Mockito.when((Object)this.config.get(SecuritySettings.security_log_successful_authentication)).thenReturn((Object)false);
        Mockito.when((Object)this.config.get(GraphDatabaseSettings.auth_max_failed_attempts)).thenReturn((Object)3);
    }

    private void nativeAuth(boolean authn, boolean authr) {
        Mockito.when((Object)this.config.get(SecuritySettings.native_authentication_enabled)).thenReturn((Object)authn);
        Mockito.when((Object)this.config.get(SecuritySettings.native_authorization_enabled)).thenReturn((Object)authr);
    }

    private void ldapAuth(boolean authn, boolean authr) {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authentication_enabled)).thenReturn((Object)authn);
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_enabled)).thenReturn((Object)authr);
    }

    private void pluginAuth(boolean authn, boolean authr) {
        Mockito.when((Object)this.config.get(SecuritySettings.plugin_authentication_enabled)).thenReturn((Object)authn);
        Mockito.when((Object)this.config.get(SecuritySettings.plugin_authorization_enabled)).thenReturn((Object)authr);
    }

    private void authProviders(String ... authProviders) {
        Mockito.when((Object)this.config.get(SecuritySettings.auth_providers)).thenReturn(Arrays.asList(authProviders));
    }
}

