/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseSecurityModule;
import org.neo4j.server.security.enterprise.auth.FileRoleRepository;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealm;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.time.Clocks;

public class InternalFlatFileRealmIT {
    File userStoreFile;
    File roleStoreFile;
    TestJobScheduler jobScheduler = new TestJobScheduler();
    LogProvider logProvider = NullLogProvider.getInstance();
    InternalFlatFileRealm realm;
    EvilFileSystem fs;
    private static int LARGE_NUMBER = 123;

    @Before
    public void setup() throws Throwable {
        this.fs = new EvilFileSystem((FileSystemAbstraction)new EphemeralFileSystemAbstraction());
        this.userStoreFile = new File("dbms", "auth");
        this.roleStoreFile = new File("dbms", "roles");
        FileUserRepository userRepository = new FileUserRepository((FileSystemAbstraction)this.fs, this.userStoreFile, this.logProvider);
        FileRoleRepository roleRepository = new FileRoleRepository((FileSystemAbstraction)this.fs, this.roleStoreFile, this.logProvider);
        FileUserRepository initialUserRepository = CommunitySecurityModule.getInitialUserRepository((Config)Config.defaults(), (LogProvider)this.logProvider, (FileSystemAbstraction)this.fs);
        UserRepository defaultAdminRepository = EnterpriseSecurityModule.getDefaultAdminRepository((Config)Config.defaults(), (LogProvider)this.logProvider, (FileSystemAbstraction)this.fs);
        BasicPasswordPolicy passwordPolicy = new BasicPasswordPolicy();
        RateLimitedAuthenticationStrategy authenticationStrategy = new RateLimitedAuthenticationStrategy(Clocks.systemClock(), 3);
        this.realm = new InternalFlatFileRealm((UserRepository)userRepository, (RoleRepository)roleRepository, (PasswordPolicy)passwordPolicy, (AuthenticationStrategy)authenticationStrategy, true, true, (JobScheduler)this.jobScheduler, (UserRepository)initialUserRepository, defaultAdminRepository);
        this.realm.init();
        this.realm.start();
    }

    @After
    public void tearDown() throws Throwable {
        this.realm.shutdown();
        this.fs.close();
    }

    @Test
    public void shouldReloadAuthFiles() throws Exception {
        this.fs.addUserRoleFilePair("Hanna:SHA-256,FE0056C37E,A543:\nCarol:SHA-256,FE0056C37E,A543:\nMia:SHA-256,0E1FFFC23E,34A4:password_change_required\n", "admin:Mia\npublisher:Hanna,Carol\n");
        this.jobScheduler.scheduledRunnable.run();
        MatcherAssert.assertThat((Object)this.realm.getAllUsernames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Hanna", "Carol", "Mia"}));
        MatcherAssert.assertThat((Object)this.realm.getUsernamesForRole("admin"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Mia"}));
        MatcherAssert.assertThat((Object)this.realm.getUsernamesForRole("publisher"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Hanna", "Carol"}));
    }

    @Test
    public void shouldReloadAuthFilesUntilValid() throws Exception {
        this.fs.addUserRoleFilePair("Hanna:SHA-256,FE0056C37E,A543:\nCarol:SHA-256,FE0056C37E,A543:\nMia:SHA-256,0E1FFFC23E,34", "THIS_WILL_NOT_BE_READ");
        this.fs.addUserRoleFilePair("Hanna:SHA-256,FE0056C37E,A543:\nCarol:SHA-256,FE0056C37E,A543:\nMia:SHA-256,0E1FFFC23E,34A4:password_change_required\n", "admin:neo4j,Mao\npublisher:Hanna\n");
        this.fs.addUserRoleFilePair("Hanna:SHA-256,FE0056C37E,A543:\nCarol:SHA-256,FE0056C37E,A543:\nMia:SHA-256,0E1FFFC23E,34A4:password_change_required\n", "admin:Mia\npublisher:Hanna,Carol\n");
        this.jobScheduler.scheduledRunnable.run();
        MatcherAssert.assertThat((Object)this.realm.getAllUsernames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Hanna", "Carol", "Mia"}));
        MatcherAssert.assertThat((Object)this.realm.getUsernamesForRole("admin"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Mia"}));
        MatcherAssert.assertThat((Object)this.realm.getUsernamesForRole("publisher"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"Hanna", "Carol"}));
    }

    @Test
    public void shouldEventuallyFailReloadAttempts() throws Exception {
        this.fs.addUserRoleFilePair("Hanna:SHA-256,FE0056C37E,A543:\nCarol:SHA-256,FE0056C37E,A543:\nMia:SHA-256,0E1FFFC23E,34A4:password_change_required\n", "admin:neo4j,Mao\npublisher:Hanna\n");
        for (int i = 0; i < LARGE_NUMBER - 1; ++i) {
            this.fs.addUserRoleFilePair("Hanna:SHA-256,FE0056C37E,A543:\nCarol:SHA-256,FE0056C37E,A543:\nMia:SHA-256,0E1FFFC23E,34", "admin:Mia\npublisher:Hanna,Carol\n");
        }
        try {
            this.jobScheduler.scheduledRunnable.run();
            Assert.fail((String)"Expected exception due to invalid auth file combo.");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Unable to load valid flat file repositories! Attempts failed with:"));
            File authFile = new File("dbms/auth");
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)("Failed to read authentication file: " + authFile)));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Role-auth file combination not valid"));
        }
    }

    private class EvilFileSystem
    extends DelegatingFileSystemAbstraction {
        private Queue<String> userStoreVersions;
        private Queue<String> roleStoreVersions;

        EvilFileSystem(FileSystemAbstraction delegate) {
            super(delegate);
            this.userStoreVersions = new LinkedList<String>();
            this.roleStoreVersions = new LinkedList<String>();
        }

        void addUserRoleFilePair(String usersVersion, String rolesVersion) {
            this.userStoreVersions.add(usersVersion);
            this.roleStoreVersions.add(rolesVersion);
        }

        public Reader openAsReader(File fileName, Charset charset) throws IOException {
            if (fileName.equals(InternalFlatFileRealmIT.this.userStoreFile)) {
                return new CharArrayReader(this.userStoreVersions.remove().toCharArray());
            }
            if (fileName.equals(InternalFlatFileRealmIT.this.roleStoreFile)) {
                if (this.userStoreVersions.size() < this.roleStoreVersions.size() - 1) {
                    this.roleStoreVersions.remove();
                }
                return new CharArrayReader(this.roleStoreVersions.remove().toCharArray());
            }
            return super.openAsReader(fileName, charset);
        }

        public long lastModifiedTime(File fileName) throws IOException {
            if (fileName.equals(InternalFlatFileRealmIT.this.userStoreFile)) {
                return LARGE_NUMBER + 1 - this.userStoreVersions.size();
            }
            if (fileName.equals(InternalFlatFileRealmIT.this.roleStoreFile)) {
                return LARGE_NUMBER + 1 - this.roleStoreVersions.size();
            }
            return super.lastModifiedTime(fileName);
        }
    }

    static class TestJobScheduler
    extends Neo4jJobScheduler {
        Runnable scheduledRunnable;

        TestJobScheduler() {
        }

        public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable r, long initialDelay, TimeUnit timeUnit) {
            this.scheduledRunnable = r;
            return null;
        }
    }
}

