/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.AuthTestUtil;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.InMemoryRoleRepository;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealm;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealmIT;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManager;
import org.neo4j.server.security.enterprise.auth.RoleRecord;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.log.SecurityLog;
import org.neo4j.time.Clocks;

public class InternalFlatFileRealmTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private MultiRealmAuthManager authManager;
    private TestRealm testRealm;

    @Before
    public void setup() throws Throwable {
        this.testRealm = new TestRealm((UserRepository)new InMemoryUserRepository(), (RoleRepository)new InMemoryRoleRepository(), (PasswordPolicy)new BasicPasswordPolicy(), (AuthenticationStrategy)new RateLimitedAuthenticationStrategy(Clock.systemUTC(), 3), (JobScheduler)Mockito.mock(JobScheduler.class), (UserRepository)new InMemoryUserRepository(), (UserRepository)new InMemoryUserRepository());
        List<Realm> realms = AuthTestUtil.listOf(new Realm[]{this.testRealm});
        this.authManager = new MultiRealmAuthManager((EnterpriseUserManager)this.testRealm, realms, (CacheManager)new MemoryConstrainedCacheManager(), (SecurityLog)Mockito.mock(SecurityLog.class), true);
        this.authManager.init();
        this.authManager.start();
        this.authManager.getUserManager().newUser("mike", "123", false);
    }

    @Test
    public void shouldNotCacheAuthenticationInfo() throws InvalidAuthTokenException {
        EnterpriseSecurityContext mike = this.authManager.login(SecurityTestUtils.authToken((String)"mike", (String)"123"));
        Assert.assertThat((Object)mike.subject().getAuthenticationResult(), (Matcher)org.hamcrest.Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)org.hamcrest.Matchers.is((Object)true));
        mike = this.authManager.login(SecurityTestUtils.authToken((String)"mike", (String)"123"));
        Assert.assertThat((Object)mike.subject().getAuthenticationResult(), (Matcher)org.hamcrest.Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void shouldNotCacheAuthorizationInfo() throws InvalidAuthTokenException {
        EnterpriseSecurityContext mike = this.authManager.login(SecurityTestUtils.authToken((String)"mike", (String)"123"));
        Assert.assertThat((Object)mike.subject().getAuthenticationResult(), (Matcher)org.hamcrest.Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
        mike.mode().allowsReads();
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthorizationFlag(), (Matcher)org.hamcrest.Matchers.is((Object)true));
        mike.mode().allowsWrites();
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthorizationFlag(), (Matcher)org.hamcrest.Matchers.is((Object)true));
    }

    @Test
    public void shouldOnlyReloadUsersOrRolesIfNeeded() throws Throwable {
        this.assertSetUsersAndRolesNTimes(false, false, 0, 0);
        this.assertSetUsersAndRolesNTimes(false, true, 0, 1);
        this.assertSetUsersAndRolesNTimes(true, false, 1, 0);
        this.assertSetUsersAndRolesNTimes(true, true, 1, 1);
    }

    @Test
    public void shouldAssignAdminRoleToDefaultUser() throws Throwable {
        InternalFlatFileRealm realm = this.internalTestRealmWithUsers(Collections.emptyList(), Collections.emptyList());
        realm.initialize();
        realm.start();
        Assert.assertThat((Object)realm.getUsernamesForRole("admin"), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"neo4j"}));
    }

    @Test
    public void shouldAssignAdminRoleToSpecifiedUser() throws Throwable {
        InternalFlatFileRealm realm = this.internalTestRealmWithUsers(Arrays.asList("neo4j", "morpheus", "trinity"), Collections.singletonList("morpheus"));
        realm.initialize();
        realm.start();
        Assert.assertThat((Object)realm.getUsernamesForRole("admin"), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"morpheus"}));
        Assert.assertThat((Object)realm.getUsernamesForRole("admin").size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldAssignAdminRoleToOnlyUser() throws Throwable {
        InternalFlatFileRealm realm = this.internalTestRealmWithUsers(Collections.singletonList("morpheus"), Collections.emptyList());
        realm.initialize();
        realm.start();
        Assert.assertThat((Object)realm.getUsernamesForRole("admin"), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"morpheus"}));
        Assert.assertThat((Object)realm.getUsernamesForRole("admin").size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
    }

    @Test
    public void shouldNotAssignAdminToNonExistentUser() throws Throwable {
        InternalFlatFileRealm realm = this.internalTestRealmWithUsers(Collections.singletonList("neo4j"), Collections.singletonList("morpheus"));
        this.exception.expect(InvalidArgumentsException.class);
        this.exception.expectMessage("No roles defined, and default admin user 'morpheus' does not exist. Please use `neo4j-admin set-default-admin` to select a valid admin.");
        realm.initialize();
        realm.start();
    }

    @Test
    public void shouldGiveErrorOnMultipleUsersNoDefault() throws Throwable {
        InternalFlatFileRealm realm = this.internalTestRealmWithUsers(Arrays.asList("morpheus", "trinity"), Collections.emptyList());
        this.exception.expect(InvalidArgumentsException.class);
        this.exception.expectMessage("No roles defined, and cannot determine which user should be admin. Please use `neo4j-admin set-default-admin` to select an admin.");
        realm.initialize();
        realm.start();
    }

    @Test
    public void shouldFailToAssignMultipleDefaultAdmins() throws Throwable {
        InternalFlatFileRealm realm = this.internalTestRealmWithUsers(Arrays.asList("morpheus", "trinity", "tank"), Arrays.asList("morpheus", "trinity"));
        this.exception.expect(InvalidArgumentsException.class);
        this.exception.expectMessage("No roles defined, and multiple users defined as default admin user. Please use `neo4j-admin set-default-admin` to select a valid admin.");
        realm.initialize();
        realm.start();
    }

    @Test
    public void shouldAssignAdminRoleAfterBadSetting() throws Throwable {
        InMemoryUserRepository userRepository = new InMemoryUserRepository();
        InMemoryUserRepository initialUserRepository = new InMemoryUserRepository();
        InMemoryUserRepository adminUserRepository = new InMemoryUserRepository();
        InMemoryRoleRepository roleRepository = new InMemoryRoleRepository();
        userRepository.create(this.newUser("morpheus", "123", false));
        userRepository.create(this.newUser("trinity", "123", false));
        InternalFlatFileRealm realm = new InternalFlatFileRealm((UserRepository)userRepository, (RoleRepository)roleRepository, (PasswordPolicy)new BasicPasswordPolicy(), (AuthenticationStrategy)new RateLimitedAuthenticationStrategy(Clocks.systemClock(), 3), (JobScheduler)new InternalFlatFileRealmIT.TestJobScheduler(), (UserRepository)initialUserRepository, (UserRepository)adminUserRepository);
        try {
            realm.initialize();
            realm.start();
            Assert.fail((String)"Multiple users, no default admin provided");
        }
        catch (InvalidArgumentsException e) {
            realm.stop();
            realm.shutdown();
        }
        adminUserRepository.create(new User.Builder("trinity", Credential.INACCESSIBLE).build());
        realm.initialize();
        realm.start();
        Assert.assertThat((Object)realm.getUsernamesForRole("admin").size(), (Matcher)org.hamcrest.Matchers.equalTo((Object)1));
        Assert.assertThat((Object)realm.getUsernamesForRole("admin"), (Matcher)org.hamcrest.Matchers.contains((Object[])new String[]{"trinity"}));
    }

    private InternalFlatFileRealm internalTestRealmWithUsers(List<String> existing, List<String> defaultAdmin) throws Throwable {
        InMemoryUserRepository userRepository = new InMemoryUserRepository();
        InMemoryUserRepository initialUserRepository = new InMemoryUserRepository();
        InMemoryUserRepository adminUserRepository = new InMemoryUserRepository();
        InMemoryRoleRepository roleRepository = new InMemoryRoleRepository();
        for (String user : existing) {
            userRepository.create(this.newUser(user, "123", false));
        }
        for (String user : defaultAdmin) {
            adminUserRepository.create(new User.Builder(user, Credential.INACCESSIBLE).build());
        }
        return new InternalFlatFileRealm((UserRepository)userRepository, (RoleRepository)roleRepository, (PasswordPolicy)new BasicPasswordPolicy(), (AuthenticationStrategy)new RateLimitedAuthenticationStrategy(Clocks.systemClock(), 3), (JobScheduler)new InternalFlatFileRealmIT.TestJobScheduler(), (UserRepository)initialUserRepository, (UserRepository)adminUserRepository);
    }

    private User newUser(String userName, String password, boolean pwdChange) {
        return new User.Builder(userName, Credential.forPassword((String)password)).withRequiredPasswordChange(pwdChange).build();
    }

    private void assertSetUsersAndRolesNTimes(boolean usersChanged, boolean rolesChanged, int nSetUsers, int nSetRoles) throws Throwable {
        UserRepository userRepository = (UserRepository)Mockito.mock(UserRepository.class);
        RoleRepository roleRepository = (RoleRepository)Mockito.mock(RoleRepository.class);
        UserRepository initialUserRepository = (UserRepository)Mockito.mock(UserRepository.class);
        UserRepository defaultAdminRepository = (UserRepository)Mockito.mock(UserRepository.class);
        BasicPasswordPolicy passwordPolicy = new BasicPasswordPolicy();
        RateLimitedAuthenticationStrategy authenticationStrategy = new RateLimitedAuthenticationStrategy(Clocks.systemClock(), 3);
        InternalFlatFileRealmIT.TestJobScheduler jobScheduler = new InternalFlatFileRealmIT.TestJobScheduler();
        InternalFlatFileRealm realm = new InternalFlatFileRealm(userRepository, roleRepository, (PasswordPolicy)passwordPolicy, (AuthenticationStrategy)authenticationStrategy, (JobScheduler)jobScheduler, initialUserRepository, defaultAdminRepository);
        Mockito.when((Object)userRepository.getPersistedSnapshot()).thenReturn((Object)new ListSnapshot(10L, Collections.emptyList(), usersChanged));
        Mockito.when((Object)userRepository.getUserByName((String)Matchers.any())).thenReturn((Object)new User.Builder().build());
        Mockito.when((Object)roleRepository.getPersistedSnapshot()).thenReturn((Object)new ListSnapshot(10L, Collections.emptyList(), rolesChanged));
        Mockito.when((Object)roleRepository.getRoleByName(Matchers.anyString())).thenReturn((Object)new RoleRecord("", new String[0]));
        realm.init();
        realm.start();
        jobScheduler.scheduledRunnable.run();
        ((UserRepository)Mockito.verify((Object)userRepository, (VerificationMode)Mockito.times((int)nSetUsers))).setUsers((ListSnapshot)Matchers.any());
        ((RoleRepository)Mockito.verify((Object)roleRepository, (VerificationMode)Mockito.times((int)nSetRoles))).setRoles((ListSnapshot)Matchers.any());
    }

    private class TestRealm
    extends InternalFlatFileRealm {
        private boolean authenticationFlag;
        private boolean authorizationFlag;

        TestRealm(UserRepository userRepository, RoleRepository roleRepository, PasswordPolicy passwordPolicy, AuthenticationStrategy authenticationStrategy, JobScheduler jobScheduler, UserRepository initialUserRepository, UserRepository defaultAdminRepository) {
            super(userRepository, roleRepository, passwordPolicy, authenticationStrategy, jobScheduler, initialUserRepository, defaultAdminRepository);
            this.authenticationFlag = false;
            this.authorizationFlag = false;
        }

        boolean takeAuthenticationFlag() {
            boolean t = this.authenticationFlag;
            this.authenticationFlag = false;
            return t;
        }

        boolean takeAuthorizationFlag() {
            boolean t = this.authorizationFlag;
            this.authorizationFlag = false;
            return t;
        }

        public String getName() {
            return "TestRealm wrapping " + super.getName();
        }

        public boolean supports(AuthenticationToken token) {
            return super.supports(token);
        }

        protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
            this.authenticationFlag = true;
            return super.doGetAuthenticationInfo(token);
        }

        protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
            this.authorizationFlag = true;
            return super.doGetAuthorizationInfo(principals);
        }
    }
}

