/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import com.google.common.testing.FakeTicker;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.AuthTestUtil;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.InMemoryRoleRepository;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealm;
import org.neo4j.server.security.enterprise.auth.LdapRealm;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManager;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.auth.ShiroCaffeineCache;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class LdapCachingTest {
    private MultiRealmAuthManager authManager;
    private TestRealm testRealm;
    private FakeTicker fakeTicker;

    @Before
    public void setup() throws Throwable {
        SecurityLog securityLog = (SecurityLog)Mockito.mock(SecurityLog.class);
        InternalFlatFileRealm internalFlatFileRealm = new InternalFlatFileRealm((UserRepository)new InMemoryUserRepository(), (RoleRepository)new InMemoryRoleRepository(), (PasswordPolicy)new BasicPasswordPolicy(), (AuthenticationStrategy)new RateLimitedAuthenticationStrategy(Clock.systemUTC(), 3), (JobScheduler)Mockito.mock(JobScheduler.class), (UserRepository)new InMemoryUserRepository(), (UserRepository)new InMemoryUserRepository());
        this.testRealm = new TestRealm(this.getLdapConfig(), securityLog, new SecureHasher());
        List<Realm> realms = AuthTestUtil.listOf(new Realm[]{internalFlatFileRealm, this.testRealm});
        this.fakeTicker = new FakeTicker();
        this.authManager = new MultiRealmAuthManager((EnterpriseUserManager)internalFlatFileRealm, realms, (CacheManager)new ShiroCaffeineCache.Manager(() -> ((FakeTicker)this.fakeTicker).read(), 100L, 10), securityLog, false);
        this.authManager.init();
        this.authManager.start();
        this.authManager.getUserManager().newUser("mike", "123", false);
        this.authManager.getUserManager().newUser("mats", "456", false);
    }

    private Config getLdapConfig() {
        return Config.embeddedDefaults((Map)MapUtil.stringMap((String[])new String[]{SecuritySettings.native_authentication_enabled.name(), "false", SecuritySettings.native_authorization_enabled.name(), "false", SecuritySettings.ldap_authentication_enabled.name(), "true", SecuritySettings.ldap_authorization_enabled.name(), "true", SecuritySettings.ldap_authorization_user_search_base.name(), "dc=example,dc=com", SecuritySettings.ldap_authorization_group_membership_attribute_names.name(), "gidnumber"}));
    }

    @Test
    public void shouldCacheAuthenticationInfo() throws InvalidAuthTokenException {
        this.authManager.login(SecurityTestUtils.authToken((String)"mike", (String)"123"));
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)Matchers.is((Object)true));
        this.authManager.login(SecurityTestUtils.authToken((String)"mike", (String)"123"));
        Assert.assertThat((String)"Test realm received a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldCacheAuthorizationInfo() throws InvalidAuthTokenException {
        EnterpriseSecurityContext mike = this.authManager.login(SecurityTestUtils.authToken((String)"mike", (String)"123"));
        mike.mode().allowsReads();
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthorizationFlag(), (Matcher)Matchers.is((Object)true));
        mike.mode().allowsWrites();
        Assert.assertThat((String)"Test realm received a call", (Object)this.testRealm.takeAuthorizationFlag(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldInvalidateAuthorizationCacheAfterTTL() throws InvalidAuthTokenException {
        EnterpriseSecurityContext mike = this.authManager.login(SecurityTestUtils.authToken((String)"mike", (String)"123"));
        mike.mode().allowsReads();
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthorizationFlag(), (Matcher)Matchers.is((Object)true));
        this.fakeTicker.advance(99L, TimeUnit.MILLISECONDS);
        mike.mode().allowsWrites();
        Assert.assertThat((String)"Test realm received a call", (Object)this.testRealm.takeAuthorizationFlag(), (Matcher)Matchers.is((Object)false));
        this.fakeTicker.advance(2L, TimeUnit.MILLISECONDS);
        mike.mode().allowsWrites();
        Assert.assertThat((String)"Test realm did not received a call", (Object)this.testRealm.takeAuthorizationFlag(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldInvalidateAuthenticationCacheAfterTTL() throws InvalidAuthTokenException {
        Map mike = SecurityTestUtils.authToken((String)"mike", (String)"123");
        this.authManager.login(mike);
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)Matchers.is((Object)true));
        this.fakeTicker.advance(99L, TimeUnit.MILLISECONDS);
        this.authManager.login(mike);
        Assert.assertThat((String)"Test realm received a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)Matchers.is((Object)false));
        this.fakeTicker.advance(2L, TimeUnit.MILLISECONDS);
        this.authManager.login(mike);
        Assert.assertThat((String)"Test realm did not received a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldInvalidateAuthenticationCacheOnDemand() throws InvalidAuthTokenException {
        Map mike = SecurityTestUtils.authToken((String)"mike", (String)"123");
        this.authManager.login(mike);
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)Matchers.is((Object)true));
        this.fakeTicker.advance(2L, TimeUnit.MILLISECONDS);
        this.authManager.login(mike);
        Assert.assertThat((String)"Test realm received a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)Matchers.is((Object)false));
        this.authManager.clearAuthCache();
        this.authManager.login(mike);
        Assert.assertThat((String)"Test realm did not receive a call", (Object)this.testRealm.takeAuthenticationFlag(), (Matcher)Matchers.is((Object)true));
    }

    private class TestRealm
    extends LdapRealm {
        private boolean authenticationFlag;
        private boolean authorizationFlag;

        boolean takeAuthenticationFlag() {
            boolean t = this.authenticationFlag;
            this.authenticationFlag = false;
            return t;
        }

        boolean takeAuthorizationFlag() {
            boolean t = this.authorizationFlag;
            this.authorizationFlag = false;
            return t;
        }

        TestRealm(Config config, SecurityLog securityLog, SecureHasher secureHasher) {
            super(config, securityLog, secureHasher);
            this.authenticationFlag = false;
            this.authorizationFlag = false;
            this.setAuthenticationCachingEnabled(true);
            this.setAuthorizationCachingEnabled(true);
        }

        public String getName() {
            return "TestRealm wrapping " + super.getName();
        }

        public boolean supports(AuthenticationToken token) {
            return super.supports(token);
        }

        protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
            this.authenticationFlag = true;
            return new AuthenticationInfo(){

                public PrincipalCollection getPrincipals() {
                    return new SimplePrincipalCollection();
                }

                public Object getCredentials() {
                    return "123";
                }
            };
        }

        protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
            this.authorizationFlag = true;
            return new AuthorizationInfo(){

                public Collection<String> getRoles() {
                    return Collections.emptyList();
                }

                public Collection<String> getStringPermissions() {
                    return Collections.emptyList();
                }

                public Collection<Permission> getObjectPermissions() {
                    return Collections.emptyList();
                }
            };
        }
    }
}

