/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.matchers.Any;
import org.neo4j.graphdb.security.AuthProviderFailedException;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.security.enterprise.auth.LdapRealm;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.auth.ShiroAuthToken;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class LdapRealmTest {
    Config config = (Config)Mockito.mock(Config.class);
    SecurityLog securityLog = (SecurityLog)Mockito.mock(SecurityLog.class);
    SecureHasher secureHasher = new SecureHasher();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void setUp() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_user_search_base)).thenReturn((Object)"dc=example,dc=com");
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_membership_attribute_names)).thenReturn(Collections.singletonList("memberOf"));
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authentication_enabled)).thenReturn((Object)true);
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_enabled)).thenReturn((Object)true);
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authentication_cache_enabled)).thenReturn((Object)false);
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_connection_timeout)).thenReturn((Object)Duration.ofSeconds(1L));
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_read_timeout)).thenReturn((Object)Duration.ofSeconds(1L));
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_connection_pooling)).thenReturn((Object)true);
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authentication_use_samaccountname)).thenReturn((Object)false);
    }

    @Test
    public void groupToRoleMappingShouldBeAbleToBeNull() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn(null);
        new LdapRealm(this.config, this.securityLog, this.secureHasher);
    }

    @Test
    public void groupToRoleMappingShouldBeAbleToBeEmpty() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"");
        new LdapRealm(this.config, this.securityLog, this.secureHasher);
    }

    @Test
    public void groupToRoleMappingShouldBeAbleToHaveMultipleRoles() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"group=role1,role2,role3");
        LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
        Assert.assertThat(realm.getGroupToRoleMapping().get("group"), (Matcher)CoreMatchers.equalTo(Arrays.asList("role1", "role2", "role3")));
        Assert.assertThat((Object)realm.getGroupToRoleMapping().size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void groupToRoleMappingShouldBeAbleToHaveMultipleGroups() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"group1=role1;group2=role2,role3;group3=role4");
        LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
        Assert.assertThat(realm.getGroupToRoleMapping().keySet(), (Matcher)CoreMatchers.equalTo(new TreeSet<String>(Arrays.asList("group1", "group2", "group3"))));
        Assert.assertThat(realm.getGroupToRoleMapping().get("group1"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("role1")));
        Assert.assertThat(realm.getGroupToRoleMapping().get("group2"), (Matcher)CoreMatchers.equalTo(Arrays.asList("role2", "role3")));
        Assert.assertThat(realm.getGroupToRoleMapping().get("group3"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("role4")));
        Assert.assertThat((Object)realm.getGroupToRoleMapping().size(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void groupToRoleMappingShouldBeAbleToHaveQuotedKeysAndWhitespaces() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"'group1' = role1;\t \"group2\"\n=\t role2,role3 ;  gr oup3= role4\n ;'group4 '= ; g =r");
        LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
        Assert.assertThat(realm.getGroupToRoleMapping().keySet(), (Matcher)CoreMatchers.equalTo(new TreeSet<String>(Arrays.asList("group1", "group2", "gr oup3", "group4 ", "g"))));
        Assert.assertThat(realm.getGroupToRoleMapping().get("group1"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("role1")));
        Assert.assertThat(realm.getGroupToRoleMapping().get("group2"), (Matcher)CoreMatchers.equalTo(Arrays.asList("role2", "role3")));
        Assert.assertThat(realm.getGroupToRoleMapping().get("gr oup3"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("role4")));
        Assert.assertThat(realm.getGroupToRoleMapping().get("group4 "), (Matcher)CoreMatchers.equalTo(Collections.emptyList()));
        Assert.assertThat(realm.getGroupToRoleMapping().get("g"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("r")));
        Assert.assertThat((Object)realm.getGroupToRoleMapping().size(), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void groupToRoleMappingShouldBeAbleToHaveTrailingSemicolons() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"group=role;;");
        LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
        Assert.assertThat(realm.getGroupToRoleMapping().get("group"), (Matcher)CoreMatchers.equalTo(Collections.singletonList("role")));
        Assert.assertThat((Object)realm.getGroupToRoleMapping().size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void groupToRoleMappingShouldBeAbleToHaveTrailingCommas() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"group=role1,role2,role3,,,");
        LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
        Assert.assertThat(realm.getGroupToRoleMapping().keySet(), (Matcher)CoreMatchers.equalTo(Stream.of("group").collect(Collectors.toSet())));
        Assert.assertThat(realm.getGroupToRoleMapping().get("group"), (Matcher)CoreMatchers.equalTo(Arrays.asList("role1", "role2", "role3")));
        Assert.assertThat((Object)realm.getGroupToRoleMapping().size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void groupToRoleMappingShouldBeAbleToHaveNoRoles() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"group=,");
        LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
        Assert.assertThat((Object)((Collection)realm.getGroupToRoleMapping().get("group")).size(), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((Object)realm.getGroupToRoleMapping().size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void groupToRoleMappingShouldNotBeAbleToHaveInvalidFormat() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"group");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("wrong number of fields");
        new LdapRealm(this.config, this.securityLog, this.secureHasher);
    }

    @Test
    public void groupToRoleMappingShouldNotBeAbleToHaveEmptyGroupName() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"=role");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("wrong number of fields");
        new LdapRealm(this.config, this.securityLog, this.secureHasher);
    }

    @Test
    public void groupComparisonShouldBeCaseInsensitive() {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"GrouP=role1,role2,role3");
        LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
        Assert.assertThat(realm.getGroupToRoleMapping().get("group"), (Matcher)CoreMatchers.equalTo(Arrays.asList("role1", "role2", "role3")));
        Assert.assertThat((Object)realm.getGroupToRoleMapping().size(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldWarnAboutUserSearchFilterWithoutArgument() throws Exception {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_user_search_filter)).thenReturn((Object)"");
        LdapContext ldapContext = (LdapContext)Mockito.mock(LdapContext.class);
        NamingEnumeration result = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        Mockito.when(ldapContext.search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.anyObject(), (SearchControls)Matchers.anyObject())).thenReturn((Object)result);
        Mockito.when((Object)result.hasMoreElements()).thenReturn((Object)false);
        this.makeAndInit();
        ((SecurityLog)Mockito.verify((Object)this.securityLog)).warn(Matchers.contains((String)"LDAP user search filter does not contain the argument placeholder {0}"));
    }

    @Test
    public void shouldWarnAboutUserSearchBaseBeingEmpty() throws Exception {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_user_search_base)).thenReturn((Object)"");
        LdapContext ldapContext = (LdapContext)Mockito.mock(LdapContext.class);
        NamingEnumeration result = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        Mockito.when(ldapContext.search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.anyObject(), (SearchControls)Matchers.anyObject())).thenReturn((Object)result);
        Mockito.when((Object)result.hasMoreElements()).thenReturn((Object)false);
        org.neo4j.test.assertion.Assert.assertException(this::makeAndInit, IllegalArgumentException.class, (String)"Illegal LDAP user search settings, see security log for details.");
        ((SecurityLog)Mockito.verify((Object)this.securityLog)).error(Matchers.contains((String)"LDAP user search base is empty."));
    }

    @Test
    public void shouldWarnAboutGroupMembershipsBeingEmpty() throws Exception {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_membership_attribute_names)).thenReturn(Collections.emptyList());
        LdapContext ldapContext = (LdapContext)Mockito.mock(LdapContext.class);
        NamingEnumeration result = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        Mockito.when(ldapContext.search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.anyObject(), (SearchControls)Matchers.anyObject())).thenReturn((Object)result);
        Mockito.when((Object)result.hasMoreElements()).thenReturn((Object)false);
        org.neo4j.test.assertion.Assert.assertException(this::makeAndInit, IllegalArgumentException.class, (String)"Illegal LDAP user search settings, see security log for details.");
        ((SecurityLog)Mockito.verify((Object)this.securityLog)).error(Matchers.contains((String)"LDAP group membership attribute names are empty. Authorization will not be possible."));
    }

    @Test
    public void shouldWarnAboutAmbiguousUserSearch() throws NamingException {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_user_search_filter)).thenReturn((Object)"{0}");
        LdapContext ldapContext = (LdapContext)Mockito.mock(LdapContext.class);
        NamingEnumeration result = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        SearchResult searchResult = (SearchResult)Mockito.mock(SearchResult.class);
        Mockito.when(ldapContext.search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.anyObject(), (SearchControls)Matchers.anyObject())).thenReturn((Object)result);
        Mockito.when((Object)result.hasMoreElements()).thenReturn((Object)true);
        Mockito.when(result.next()).thenReturn((Object)searchResult);
        Mockito.when((Object)searchResult.toString()).thenReturn((Object)"<ldap search result>");
        LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
        realm.findRoleNamesForUser("username", ldapContext);
        ((SecurityLog)Mockito.verify((Object)this.securityLog)).warn(Matchers.contains((String)"LDAP user search for user principal 'username' is ambiguous"));
    }

    @Test
    public void shouldAllowMultipleGroupMembershipAttributes() throws NamingException {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_user_search_filter)).thenReturn((Object)"{0}");
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_membership_attribute_names)).thenReturn(Arrays.asList("attr0", "attr1", "attr2"));
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_group_to_role_mapping)).thenReturn((Object)"group1=role1;group2=role2,role3");
        LdapContext ldapContext = (LdapContext)Mockito.mock(LdapContext.class);
        NamingEnumeration result = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        SearchResult searchResult = (SearchResult)Mockito.mock(SearchResult.class);
        Attributes attributes = (Attributes)Mockito.mock(Attributes.class);
        Attribute attribute1 = (Attribute)Mockito.mock(Attribute.class);
        Attribute attribute2 = (Attribute)Mockito.mock(Attribute.class);
        Attribute attribute3 = (Attribute)Mockito.mock(Attribute.class);
        NamingEnumeration attributeEnumeration = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        NamingEnumeration groupEnumeration1 = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        NamingEnumeration groupEnumeration2 = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        NamingEnumeration groupEnumeration3 = (NamingEnumeration)Mockito.mock(NamingEnumeration.class);
        Mockito.when(ldapContext.search(Matchers.anyString(), Matchers.anyString(), (Object[])Matchers.anyObject(), (SearchControls)Matchers.anyObject())).thenReturn((Object)result);
        Mockito.when((Object)result.hasMoreElements()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when(result.next()).thenReturn((Object)searchResult);
        Mockito.when((Object)searchResult.getAttributes()).thenReturn((Object)attributes);
        Mockito.when(attributes.getAll()).thenReturn((Object)attributeEnumeration);
        Mockito.when((Object)attributeEnumeration.hasMore()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(attributeEnumeration.next()).thenReturn((Object)attribute1, new Object[]{attribute2, attribute3});
        Mockito.when((Object)attribute1.getID()).thenReturn((Object)"attr1");
        Mockito.when(attribute1.getAll()).thenReturn((Object)groupEnumeration1);
        Mockito.when((Object)groupEnumeration1.hasMore()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when(groupEnumeration1.next()).thenReturn((Object)"group1");
        Mockito.when((Object)attribute2.getID()).thenReturn((Object)"attr2");
        Mockito.when(attribute2.getAll()).thenReturn((Object)groupEnumeration2);
        Mockito.when((Object)groupEnumeration2.hasMore()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when(groupEnumeration2.next()).thenReturn((Object)"group2");
        Mockito.when((Object)attribute3.getID()).thenReturn((Object)"attr3");
        Mockito.when(attribute3.getAll()).thenReturn((Object)groupEnumeration3);
        Mockito.when((Object)groupEnumeration3.hasMore()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when(groupEnumeration3.next()).thenReturn((Object)"groupWithNoRole");
        LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
        Set roles = realm.findRoleNamesForUser("username", ldapContext);
        Assert.assertThat((Object)roles, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"role1", "role2", "role3"}));
    }

    @Test
    public void shouldLogSuccessfulAuthenticationQueries() throws NamingException {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_use_starttls)).thenReturn((Object)false);
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_authorization_use_system_account)).thenReturn((Object)true);
        TestLdapRealm realm = new TestLdapRealm(this.config, this.securityLog, false);
        JndiLdapContextFactory jndiLdapContectFactory = (JndiLdapContextFactory)Mockito.mock(JndiLdapContextFactory.class);
        Mockito.when((Object)jndiLdapContectFactory.getUrl()).thenReturn((Object)"ldap://myserver.org:12345");
        Mockito.when((Object)jndiLdapContectFactory.getLdapContext((Object)Any.ANY, (Object)Any.ANY)).thenReturn(null);
        realm.queryForAuthenticationInfo((AuthenticationToken)new ShiroAuthToken(MapUtil.map((Object[])new Object[]{"principal", "olivia", "credentials", "123"})), (LdapContextFactory)jndiLdapContectFactory);
        ((SecurityLog)Mockito.verify((Object)this.securityLog)).debug(Matchers.contains((String)"{LdapRealm}: Authenticated user 'olivia' against 'ldap://myserver.org:12345'"));
    }

    @Test
    public void shouldLogSuccessfulAuthenticationQueriesUsingStartTLS() throws NamingException {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_use_starttls)).thenReturn((Object)true);
        TestLdapRealm realm = new TestLdapRealm(this.config, this.securityLog, false);
        JndiLdapContextFactory jndiLdapContectFactory = (JndiLdapContextFactory)Mockito.mock(JndiLdapContextFactory.class);
        Mockito.when((Object)jndiLdapContectFactory.getUrl()).thenReturn((Object)"ldap://myserver.org:12345");
        realm.queryForAuthenticationInfo((AuthenticationToken)new ShiroAuthToken(MapUtil.map((Object[])new Object[]{"principal", "olivia", "credentials", "123"})), (LdapContextFactory)jndiLdapContectFactory);
        ((SecurityLog)Mockito.verify((Object)this.securityLog)).debug(Matchers.contains((String)"{LdapRealm}: Authenticated user 'olivia' against 'ldap://myserver.org:12345' using StartTLS"));
    }

    @Test
    public void shouldLogFailedAuthenticationQueries() throws Exception {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_use_starttls)).thenReturn((Object)true);
        TestLdapRealm realm = new TestLdapRealm(this.config, this.securityLog, true);
        JndiLdapContextFactory jndiLdapContectFactory = (JndiLdapContextFactory)Mockito.mock(JndiLdapContextFactory.class);
        Mockito.when((Object)jndiLdapContectFactory.getUrl()).thenReturn((Object)"ldap://myserver.org:12345");
        org.neo4j.test.assertion.Assert.assertException(() -> realm.queryForAuthenticationInfo((AuthenticationToken)new ShiroAuthToken(MapUtil.map((Object[])new Object[]{"principal", "olivia", "credentials", "123"})), (LdapContextFactory)jndiLdapContectFactory), NamingException.class);
        ((SecurityLog)Mockito.verify((Object)this.securityLog)).error(Matchers.contains((String)"{LdapRealm}: Failed to authenticate user 'olivia' against 'ldap://myserver.org:12345' using StartTLS: Simulated failure"));
    }

    @Test
    public void shouldLogSuccessfulAuthorizationQueries() throws Exception {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_use_starttls)).thenReturn((Object)true);
        TestLdapRealm realm = new TestLdapRealm(this.config, this.securityLog, false);
        JndiLdapContextFactory jndiLdapContectFactory = (JndiLdapContextFactory)Mockito.mock(JndiLdapContextFactory.class);
        Mockito.when((Object)jndiLdapContectFactory.getUrl()).thenReturn((Object)"ldap://myserver.org:12345");
        realm.doGetAuthorizationInfo((PrincipalCollection)new SimplePrincipalCollection((Object)"olivia", "LdapRealm"));
        ((SecurityLog)Mockito.verify((Object)this.securityLog)).debug(Matchers.contains((String)"{LdapRealm}: Queried for authorization info for user 'olivia'"));
    }

    @Test
    public void shouldLogFailedAuthorizationQueries() throws Exception {
        Mockito.when((Object)this.config.get(SecuritySettings.ldap_use_starttls)).thenReturn((Object)true);
        TestLdapRealm realm = new TestLdapRealm(this.config, this.securityLog, true);
        JndiLdapContextFactory jndiLdapContectFactory = (JndiLdapContextFactory)Mockito.mock(JndiLdapContextFactory.class);
        Mockito.when((Object)jndiLdapContectFactory.getUrl()).thenReturn((Object)"ldap://myserver.org:12345");
        org.neo4j.test.assertion.Assert.assertException(() -> realm.doGetAuthorizationInfo((PrincipalCollection)new SimplePrincipalCollection((Object)"olivia", "LdapRealm")), AuthProviderFailedException.class);
        ((SecurityLog)Mockito.verify((Object)this.securityLog)).error(Matchers.contains((String)"{LdapRealm}: Failed to get authorization info: 'LDAP naming error while attempting to retrieve authorization for user [olivia].' caused by 'Simulated failure'"));
    }

    private void makeAndInit() throws Exception {
        try {
            LdapRealm realm = new LdapRealm(this.config, this.securityLog, this.secureHasher);
            realm.initialize();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private class TestLdapRealm
    extends LdapRealm {
        private boolean failAuth;

        TestLdapRealm(Config config, SecurityLog securityLog, boolean failAuth) {
            super(config, securityLog, LdapRealmTest.this.secureHasher);
            this.failAuth = failAuth;
        }

        protected AuthenticationInfo queryForAuthenticationInfoUsingStartTls(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
            if (this.failAuth) {
                throw new NamingException("Simulated failure");
            }
            return new SimpleAuthenticationInfo((Object)"olivia", (Object)"123", "basic");
        }

        protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
            if (this.failAuth) {
                throw new NamingException("Simulated failure");
            }
            return new SimpleAuthorizationInfo();
        }
    }
}

