/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseAuthAndUserManager;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.InMemoryRoleRepository;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealm;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManager;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.auth.ShiroSubject;
import org.neo4j.server.security.enterprise.auth.StandardEnterpriseSecurityContext;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class MultiRealmAuthManagerRule
implements TestRule {
    private UserRepository users;
    private AuthenticationStrategy authStrategy;
    private MultiRealmAuthManager manager;
    private SecurityLog securityLog;
    private StringWriter securityLogWriter;

    public MultiRealmAuthManagerRule(UserRepository users, AuthenticationStrategy authStrategy) {
        this.users = users;
        this.authStrategy = authStrategy;
    }

    private void setupAuthManager(AuthenticationStrategy authStrategy) throws Throwable {
        FormattedLog.Builder builder = FormattedLog.withUTCTimeZone();
        this.securityLogWriter = new StringWriter();
        FormattedLog log = builder.toWriter((Writer)this.securityLogWriter);
        this.securityLog = new SecurityLog((Log)log);
        InternalFlatFileRealm internalFlatFileRealm = new InternalFlatFileRealm(this.users, (RoleRepository)new InMemoryRoleRepository(), (PasswordPolicy)new BasicPasswordPolicy(), authStrategy, (JobScheduler)Mockito.mock(JobScheduler.class), (UserRepository)new InMemoryUserRepository(), (UserRepository)new InMemoryUserRepository());
        this.manager = new MultiRealmAuthManager((EnterpriseUserManager)internalFlatFileRealm, Collections.singleton(internalFlatFileRealm), (CacheManager)new MemoryConstrainedCacheManager(), this.securityLog, true);
        this.manager.init();
    }

    public EnterpriseAuthAndUserManager getManager() {
        return this.manager;
    }

    public SecurityContext makeSecurityContext(ShiroSubject shiroSubject) {
        return new StandardEnterpriseSecurityContext(this.manager, shiroSubject);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    MultiRealmAuthManagerRule.this.setupAuthManager(MultiRealmAuthManagerRule.this.authStrategy);
                    base.evaluate();
                }
                catch (Throwable t) {
                    Assert.fail((String)("Got unexpected exception " + t));
                }
                finally {
                    try {
                        MultiRealmAuthManagerRule.this.tearDown();
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Failed to shut down MultiRealmAuthManager", t);
                    }
                }
            }
        };
    }

    @After
    public void tearDown() throws Throwable {
        this.manager.stop();
        this.manager.shutdown();
    }

    public FullSecurityLog getFullSecurityLog() {
        return new FullSecurityLog(this.securityLogWriter.getBuffer().toString().split("\n"));
    }

    public static class FullSecurityLog {
        List<String> lines;

        private FullSecurityLog(String[] logLines) {
            this.lines = Arrays.asList(logLines);
        }

        public void assertHasLine(String subject, String msg) {
            MatcherAssert.assertThat(this.lines, (Matcher)Matchers.hasItem((Matcher)Matchers.containsString((String)("[" + subject + "]: " + msg))));
        }
    }
}

