/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Collections;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.InitialUserTest;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseSecurityModule;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.InMemoryRoleRepository;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealm;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManager;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class MultiRealmAuthManagerTest
extends InitialUserTest {
    private AuthenticationStrategy authStrategy;
    private MultiRealmAuthManager manager;
    private EnterpriseUserManager userManager;
    private AssertableLogProvider logProvider;
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Before
    public void setUp() throws Throwable {
        this.config = Config.defaults();
        this.users = CommunitySecurityModule.getUserRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get());
        this.authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        this.logProvider = new AssertableLogProvider();
        this.manager = this.createAuthManager(true);
        this.userManager = this.manager.getUserManager();
    }

    private MultiRealmAuthManager createAuthManager(boolean logSuccessfulAuthentications) throws Throwable {
        Log log = this.logProvider.getLog(((Object)((Object)this)).getClass());
        InternalFlatFileRealm internalFlatFileRealm = new InternalFlatFileRealm(this.users, (RoleRepository)new InMemoryRoleRepository(), (PasswordPolicy)Mockito.mock(PasswordPolicy.class), this.authStrategy, (JobScheduler)Mockito.mock(JobScheduler.class), (UserRepository)CommunitySecurityModule.getInitialUserRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get()), EnterpriseSecurityModule.getDefaultAdminRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get()));
        this.manager = new MultiRealmAuthManager((EnterpriseUserManager)internalFlatFileRealm, Collections.singleton(internalFlatFileRealm), (CacheManager)new MemoryConstrainedCacheManager(), new SecurityLog(log), logSuccessfulAuthentications);
        this.manager.init();
        return this.manager;
    }

    @After
    public void tearDown() throws Throwable {
        this.manager.stop();
        this.manager.shutdown();
    }

    @Test
    public void shouldMakeOnlyUserAdminIfNoRolesFile() throws Throwable {
        this.users.create(this.newUser("jake", "abc123", false));
        this.manager.start();
        Assert.assertThat((Object)this.manager.getUserManager().getRoleNamesForUser("jake"), (Matcher)Matchers.contains((Object[])new String[]{"admin"}));
    }

    @Test
    public void shouldMakeNeo4jUserAdminIfNoRolesFileButManyUsers() throws Throwable {
        this.users.create(this.newUser("jake", "abc123", false));
        this.users.create(this.newUser("neo4j", "neo4j", false));
        this.manager.start();
        Assert.assertThat((Object)this.manager.getUserManager().getRoleNamesForUser("neo4j"), (Matcher)Matchers.contains((Object[])new String[]{"admin"}));
        Assert.assertThat((Object)this.manager.getUserManager().getRoleNamesForUser("jake").size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void shouldFailIfNoRolesFileButManyUsersAndNoDefaultAdminOrNeo4j() throws Throwable {
        this.users.create(this.newUser("jake", "abc123", false));
        this.users.create(this.newUser("jane", "123abc", false));
        this.expect.expect(InvalidArgumentsException.class);
        this.expect.expectMessage("No roles defined, and cannot determine which user should be admin. Please use `neo4j-admin set-default-admin` to select an admin.");
        this.manager.start();
    }

    @Test
    public void shouldFailIfNoRolesFileButManyUsersAndNonExistingDefaultAdmin() throws Throwable {
        UserRepository defaultAdminRepository = EnterpriseSecurityModule.getDefaultAdminRepository((Config)this.config, (LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)this.fsRule.get());
        defaultAdminRepository.start();
        defaultAdminRepository.create(new User.Builder("foo", Credential.INACCESSIBLE).withRequiredPasswordChange(false).build());
        defaultAdminRepository.shutdown();
        this.users.create(this.newUser("jake", "abc123", false));
        this.users.create(this.newUser("jane", "123abc", false));
        this.expect.expect(InvalidArgumentsException.class);
        this.expect.expectMessage("No roles defined, and default admin user 'foo' does not exist. Please use `neo4j-admin set-default-admin` to select a valid admin.");
        this.manager.start();
    }

    @Test
    public void shouldFindAndAuthenticateUserSuccessfully() throws Throwable {
        this.users.create(this.newUser("jake", "abc123", false));
        this.manager.start();
        this.setMockAuthenticationStrategyResult("jake", "abc123", AuthenticationResult.SUCCESS);
        AuthenticationResult result = this.manager.login(SecurityTestUtils.authToken((String)"jake", (String)"abc123")).subject().getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[jake]: logged in")});
    }

    @Test
    public void shouldNotLogAuthenticationIfFlagSaysNo() throws Throwable {
        this.manager.shutdown();
        this.manager = this.createAuthManager(false);
        this.users.create(this.newUser("jake", "abc123", false));
        this.manager.start();
        this.setMockAuthenticationStrategyResult("jake", "abc123", AuthenticationResult.SUCCESS);
        AuthenticationResult result = this.manager.login(SecurityTestUtils.authToken((String)"jake", (String)"abc123")).subject().getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
        this.logProvider.assertNone(this.info("[jake]: logged in"));
    }

    @Test
    public void shouldReturnTooManyAttemptsWhenThatIsAppropriate() throws Throwable {
        this.users.create(this.newUser("jake", "abc123", true));
        this.manager.start();
        this.setMockAuthenticationStrategyResult("jake", "wrong password", AuthenticationResult.TOO_MANY_ATTEMPTS);
        AuthSubject authSubject = this.manager.login(SecurityTestUtils.authToken((String)"jake", (String)"wrong password")).subject();
        AuthenticationResult result = authSubject.getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[%s]: failed to log in: too many failed attempts", "jake")});
    }

    @Test
    public void shouldFindAndAuthenticateUserAndReturnPasswordChangeIfRequired() throws Throwable {
        this.users.create(this.newUser("jake", "abc123", true));
        this.manager.start();
        this.setMockAuthenticationStrategyResult("jake", "abc123", AuthenticationResult.SUCCESS);
        AuthenticationResult result = this.manager.login(SecurityTestUtils.authToken((String)"jake", (String)"abc123")).subject().getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED));
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[jake]: logged in")});
    }

    @Test
    public void shouldFailWhenAuthTokenIsInvalid() throws Throwable {
        this.manager.start();
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"scheme", "supercool", "principal", "neo4j"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token: { scheme='supercool', principal='neo4j' }");
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"scheme", "none"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token, scheme='none' only allowed when auth is disabled: { scheme='none' }");
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"key", "value"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token, missing key `scheme`: { key='value' }");
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"scheme", "basic", "principal", "neo4j"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token, missing key `credentials`: { scheme='basic', principal='neo4j' }");
        org.neo4j.test.assertion.Assert.assertException(() -> this.manager.login(MapUtil.map((Object[])new Object[]{"scheme", "basic", "credentials", "very-secret"})), InvalidAuthTokenException.class, (String)"Unsupported authentication token, missing key `principal`: { scheme='basic', credentials='******' }");
    }

    @Test
    public void shouldFailAuthenticationIfUserIsNotFound() throws Throwable {
        this.manager.start();
        AuthSubject authSubject = this.manager.login(SecurityTestUtils.authToken((String)"unknown", (String)"abc123")).subject();
        AuthenticationResult result = authSubject.getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[%s]: failed to log in: invalid principal or credentials", "unknown")});
    }

    @Test
    public void shouldFailAuthenticationAndEscapeIfUserIsNotFound() throws Throwable {
        this.manager.start();
        AuthSubject authSubject = this.manager.login(SecurityTestUtils.authToken((String)"unknown\n\t\r\"haxx0r\"", (String)"abc123")).subject();
        AuthenticationResult result = authSubject.getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        this.logProvider.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[%s]: failed to log in: invalid principal or credentials", Strings.escape((String)"unknown\n\t\r\"haxx0r\""))});
    }

    @Test
    public void shouldCreateUser() throws Throwable {
        this.manager.start();
        this.userManager.newUser("foo", "bar", true);
        User user = this.users.getUserByName("foo");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.passwordChangeRequired());
        Assert.assertTrue((boolean)user.credentials().matchesPassword("bar"));
    }

    @Test
    public void shouldDeleteUser() throws Throwable {
        User user = this.newUser("jake", "abc123", true);
        User user2 = this.newUser("neo4j", "321cba", true);
        this.users.create(user);
        this.users.create(user2);
        this.manager.start();
        this.userManager.deleteUser("jake");
        Assert.assertNull((Object)this.users.getUserByName("jake"));
        Assert.assertNotNull((Object)this.users.getUserByName("neo4j"));
    }

    @Test
    public void shouldFailDeletingUnknownUser() throws Throwable {
        User user = this.newUser("jake", "abc123", true);
        this.users.create(user);
        this.manager.start();
        org.neo4j.test.assertion.Assert.assertException(() -> this.userManager.deleteUser("unknown"), InvalidArgumentsException.class, (String)"User 'unknown' does not exist");
        Assert.assertNotNull((Object)this.users.getUserByName("jake"));
    }

    @Test
    public void shouldSuspendExistingUser() throws Throwable {
        User user = this.newUser("jake", "abc123", true);
        this.users.create(user);
        this.manager.start();
        this.userManager.suspendUser("jake");
        this.setMockAuthenticationStrategyResult("jake", "abc123", AuthenticationResult.SUCCESS);
        AuthenticationResult result = this.manager.login(SecurityTestUtils.authToken((String)"jake", (String)"abc123")).subject().getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldActivateExistingUser() throws Throwable {
        this.users.create(this.newUser("jake", "abc123", false));
        this.manager.start();
        this.userManager.suspendUser("jake");
        this.userManager.activateUser("jake", false);
        this.setMockAuthenticationStrategyResult("jake", "abc123", AuthenticationResult.SUCCESS);
        AuthenticationResult result = this.manager.login(SecurityTestUtils.authToken((String)"jake", (String)"abc123")).subject().getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldSuspendSuspendedUser() throws Throwable {
        User user = this.newUser("jake", "abc123", false);
        this.users.create(user);
        this.manager.start();
        this.userManager.suspendUser("jake");
        this.userManager.suspendUser("jake");
        this.setMockAuthenticationStrategyResult("jake", "abc123", AuthenticationResult.SUCCESS);
        AuthenticationResult result = this.manager.login(SecurityTestUtils.authToken((String)"jake", (String)"abc123")).subject().getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldActivateActiveUser() throws Throwable {
        User user = this.newUser("jake", "abc123", false);
        this.users.create(user);
        this.manager.start();
        Mockito.when((Object)this.authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.SUCCESS);
        this.userManager.activateUser("jake", false);
        this.setMockAuthenticationStrategyResult("jake", "abc123", AuthenticationResult.SUCCESS);
        AuthenticationResult result = this.manager.login(SecurityTestUtils.authToken((String)"jake", (String)"abc123")).subject().getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldFailToSuspendNonExistingUser() throws Throwable {
        this.manager.start();
        try {
            this.userManager.suspendUser("jake");
            Assert.fail((String)"Should throw exception on suspending unknown user");
        }
        catch (InvalidArgumentsException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"User 'jake' does not exist"));
        }
    }

    @Test
    public void shouldFailToActivateNonExistingUser() throws Throwable {
        this.manager.start();
        try {
            this.userManager.activateUser("jake", false);
            Assert.fail((String)"Should throw exception on activating unknown user");
        }
        catch (InvalidArgumentsException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"User 'jake' does not exist"));
        }
    }

    @Test
    public void shouldSetPassword() throws Throwable {
        this.users.create(this.newUser("jake", "abc123", true));
        this.manager.start();
        this.userManager.setUserPassword("jake", "hello, world!", false);
        User user = this.userManager.getUser("jake");
        Assert.assertTrue((boolean)user.credentials().matchesPassword("hello, world!"));
        Assert.assertThat((Object)this.users.getUserByName("jake"), (Matcher)Matchers.equalTo((Object)user));
    }

    @Test
    public void shouldNotRequestPasswordChangeWithInvalidCredentials() throws Throwable {
        this.users.create(this.newUser("neo", "abc123", true));
        this.manager.start();
        this.setMockAuthenticationStrategyResult("neo", "abc123", AuthenticationResult.SUCCESS);
        this.setMockAuthenticationStrategyResult("neo", "wrong", AuthenticationResult.FAILURE);
        AuthenticationResult result = this.manager.login(SecurityTestUtils.authToken((String)"neo", (String)"wrong")).subject().getAuthenticationResult();
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldReturnNullWhenSettingPasswordForUnknownUser() throws Throwable {
        this.manager.start();
        try {
            this.userManager.setUserPassword("unknown", "hello, world!", false);
            Assert.fail((String)"exception expected");
        }
        catch (InvalidArgumentsException invalidArgumentsException) {
            // empty catch block
        }
    }

    private void createTestUsers() throws Throwable {
        this.userManager.newUser("morpheus", "abc123", false);
        this.userManager.newRole("admin", new String[]{"morpheus"});
        this.setMockAuthenticationStrategyResult("morpheus", "abc123", AuthenticationResult.SUCCESS);
        this.userManager.newUser("trinity", "abc123", false);
        this.userManager.newRole("architect", new String[]{"trinity"});
        this.setMockAuthenticationStrategyResult("trinity", "abc123", AuthenticationResult.SUCCESS);
        this.userManager.newUser("tank", "abc123", false);
        this.userManager.newRole("publisher", new String[]{"tank"});
        this.setMockAuthenticationStrategyResult("tank", "abc123", AuthenticationResult.SUCCESS);
        this.userManager.newUser("neo", "abc123", false);
        this.userManager.newRole("reader", new String[]{"neo"});
        this.setMockAuthenticationStrategyResult("neo", "abc123", AuthenticationResult.SUCCESS);
        this.userManager.newUser("smith", "abc123", false);
        this.userManager.newRole("agent", new String[]{"smith"});
        this.setMockAuthenticationStrategyResult("smith", "abc123", AuthenticationResult.SUCCESS);
    }

    @Test
    public void defaultUserShouldHaveCorrectPermissions() throws Throwable {
        this.manager.start();
        this.setMockAuthenticationStrategyResult("neo4j", "neo4j", AuthenticationResult.SUCCESS);
        EnterpriseSecurityContext securityContext = this.manager.login(SecurityTestUtils.authToken((String)"neo4j", (String)"neo4j"));
        this.userManager.setUserPassword("neo4j", "1234", false);
        securityContext.subject().logout();
        this.setMockAuthenticationStrategyResult("neo4j", "1234", AuthenticationResult.SUCCESS);
        securityContext = this.manager.login(SecurityTestUtils.authToken((String)"neo4j", (String)"1234"));
        Assert.assertTrue((boolean)securityContext.mode().allowsReads());
        Assert.assertTrue((boolean)securityContext.mode().allowsWrites());
        Assert.assertTrue((boolean)securityContext.mode().allowsSchemaWrites());
    }

    @Test
    public void userWithAdminRoleShouldHaveCorrectPermissions() throws Throwable {
        this.createTestUsers();
        this.manager.start();
        EnterpriseSecurityContext securityContext = this.manager.login(SecurityTestUtils.authToken((String)"morpheus", (String)"abc123"));
        Assert.assertTrue((boolean)securityContext.mode().allowsReads());
        Assert.assertTrue((boolean)securityContext.mode().allowsWrites());
        Assert.assertTrue((boolean)securityContext.mode().allowsSchemaWrites());
    }

    @Test
    public void userWithArchitectRoleShouldHaveCorrectPermissions() throws Throwable {
        this.createTestUsers();
        this.manager.start();
        EnterpriseSecurityContext securityContext = this.manager.login(SecurityTestUtils.authToken((String)"trinity", (String)"abc123"));
        Assert.assertTrue((boolean)securityContext.mode().allowsReads());
        Assert.assertTrue((boolean)securityContext.mode().allowsWrites());
        Assert.assertTrue((boolean)securityContext.mode().allowsSchemaWrites());
    }

    @Test
    public void userWithPublisherRoleShouldHaveCorrectPermissions() throws Throwable {
        this.createTestUsers();
        this.manager.start();
        EnterpriseSecurityContext securityContext = this.manager.login(SecurityTestUtils.authToken((String)"tank", (String)"abc123"));
        Assert.assertTrue((String)"should allow reads", (boolean)securityContext.mode().allowsReads());
        Assert.assertTrue((String)"should allow writes", (boolean)securityContext.mode().allowsWrites());
        Assert.assertFalse((String)"should _not_ allow schema writes", (boolean)securityContext.mode().allowsSchemaWrites());
    }

    @Test
    public void userWithReaderRoleShouldHaveCorrectPermissions() throws Throwable {
        this.createTestUsers();
        this.manager.start();
        EnterpriseSecurityContext securityContext = this.manager.login(SecurityTestUtils.authToken((String)"neo", (String)"abc123"));
        Assert.assertTrue((boolean)securityContext.mode().allowsReads());
        Assert.assertFalse((boolean)securityContext.mode().allowsWrites());
        Assert.assertFalse((boolean)securityContext.mode().allowsSchemaWrites());
    }

    @Test
    public void userWithNonPredefinedRoleShouldHaveNoPermissions() throws Throwable {
        this.createTestUsers();
        this.manager.start();
        EnterpriseSecurityContext securityContext = this.manager.login(SecurityTestUtils.authToken((String)"smith", (String)"abc123"));
        Assert.assertFalse((boolean)securityContext.mode().allowsReads());
        Assert.assertFalse((boolean)securityContext.mode().allowsWrites());
        Assert.assertFalse((boolean)securityContext.mode().allowsSchemaWrites());
    }

    @Test
    public void shouldHaveNoPermissionsAfterLogout() throws Throwable {
        this.createTestUsers();
        this.manager.start();
        EnterpriseSecurityContext securityContext = this.manager.login(SecurityTestUtils.authToken((String)"morpheus", (String)"abc123"));
        Assert.assertTrue((boolean)securityContext.mode().allowsReads());
        Assert.assertTrue((boolean)securityContext.mode().allowsWrites());
        Assert.assertTrue((boolean)securityContext.mode().allowsSchemaWrites());
        securityContext.subject().logout();
        Assert.assertFalse((boolean)securityContext.mode().allowsReads());
        Assert.assertFalse((boolean)securityContext.mode().allowsWrites());
        Assert.assertFalse((boolean)securityContext.mode().allowsSchemaWrites());
    }

    private AssertableLogProvider.LogMatcher info(String message) {
        return AssertableLogProvider.inLog(((Object)((Object)this)).getClass()).info(message);
    }

    private AssertableLogProvider.LogMatcher info(String message, String ... arguments) {
        return AssertableLogProvider.inLog(((Object)((Object)this)).getClass()).info(message, (Object[])arguments);
    }

    private AssertableLogProvider.LogMatcher error(String message, String ... arguments) {
        return AssertableLogProvider.inLog(((Object)((Object)this)).getClass()).error(message, (Object[])arguments);
    }

    private void setMockAuthenticationStrategyResult(String username, String password, AuthenticationResult result) {
        User user = this.users.getUserByName(username);
        Mockito.when((Object)this.authStrategy.authenticate(user, password)).thenReturn((Object)result);
    }

    protected AuthManager authManager() {
        return this.manager;
    }
}

