/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;

public interface NeoInteractionLevel<S> {
    public EnterpriseUserManager getLocalUserManager() throws Exception;

    public GraphDatabaseFacade getLocalGraph();

    public FileSystemAbstraction fileSystem();

    public InternalTransaction beginLocalTransactionAsUser(S var1, KernelTransaction.Type var2) throws Throwable;

    public String executeQuery(S var1, String var2, Map<String, Object> var3, Consumer<ResourceIterator<Map<String, Object>>> var4);

    public S login(String var1, String var2) throws Exception;

    public void logout(S var1) throws Exception;

    public void updateAuthToken(S var1, String var2, String var3);

    public String nameOf(S var1);

    public void tearDown() throws Throwable;

    public static String tempPath(String prefix, String suffix) throws IOException {
        Path path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        Files.delete(path);
        return path.toString();
    }

    public void assertAuthenticated(S var1);

    public void assertPasswordChangeRequired(S var1) throws Exception;

    public void assertInitFailed(S var1);

    public void assertSessionKilled(S var1);

    public String getConnectionProtocol();
}

