/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.time.Clock;
import java.util.Set;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.Log;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.InMemoryRoleRepository;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealm;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealmIT;
import org.neo4j.server.security.enterprise.auth.PersonalUserManager;
import org.neo4j.server.security.enterprise.auth.RoleRecord;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class PersonalUserManagerTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private PersonalUserManager userManager;
    private EvilUserManager evilUserManager;
    private Log log;

    @Test
    public void shouldHandleFailureToCreateUser() throws Exception {
        this.evilUserManager.setFailNextCall();
        this.expectedException.expect(IOException.class);
        this.expectedException.expectMessage("newUserException");
        this.userManager.newUser("hewhoshallnotbenamed", "avada kedavra", false);
        ((Log)Mockito.verify((Object)this.log)).error(this.withSubject(SecurityContext.AUTH_DISABLED.subject(), "tried to create user `%s`: %s"), new Object[]{"hewhoshallnotbenamed", "newUserException"});
    }

    @Before
    public void setup() {
        this.evilUserManager = new EvilUserManager((EnterpriseUserManager)new InternalFlatFileRealm((UserRepository)new InMemoryUserRepository(), (RoleRepository)new InMemoryRoleRepository(), (PasswordPolicy)new BasicPasswordPolicy(), (AuthenticationStrategy)new RateLimitedAuthenticationStrategy(Clock.systemUTC(), 3), (JobScheduler)new InternalFlatFileRealmIT.TestJobScheduler(), (UserRepository)new InMemoryUserRepository(), (UserRepository)new InMemoryUserRepository()));
        this.log = (Log)Mockito.spy(Log.class);
        this.userManager = new PersonalUserManager((EnterpriseUserManager)this.evilUserManager, SecurityContext.AUTH_DISABLED, new SecurityLog(this.log));
    }

    private String withSubject(AuthSubject subject, String msg) {
        return "[" + subject.username() + "] " + msg;
    }

    private class EvilUserManager
    implements EnterpriseUserManager {
        private boolean failNextCall = false;
        private EnterpriseUserManager delegate;

        EvilUserManager(EnterpriseUserManager delegate) {
            this.delegate = delegate;
        }

        void setFailNextCall() {
            this.failNextCall = true;
        }

        public User newUser(String username, String password, boolean changeRequired) throws IOException, InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new IOException("newUserException");
            }
            return this.delegate.newUser(username, password, changeRequired);
        }

        public boolean deleteUser(String username) throws IOException, InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new IOException("deleteUserException");
            }
            return this.delegate.deleteUser(username);
        }

        public User getUser(String username) throws InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new InvalidArgumentsException("getUserException");
            }
            return this.delegate.getUser(username);
        }

        public User silentlyGetUser(String username) {
            return this.delegate.silentlyGetUser(username);
        }

        public void setUserPassword(String username, String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new IOException("setUserPasswordException");
            }
            this.delegate.setUserPassword(username, password, requirePasswordChange);
        }

        public Set<String> getAllUsernames() {
            return this.delegate.getAllUsernames();
        }

        public void suspendUser(String username) throws IOException, InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new IOException("suspendUserException");
            }
            this.delegate.suspendUser(username);
        }

        public void activateUser(String username, boolean requirePasswordChange) throws IOException, InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new IOException("activateUserException");
            }
            this.delegate.activateUser(username, requirePasswordChange);
        }

        public RoleRecord newRole(String roleName, String ... usernames) throws IOException, InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new IOException("newRoleException");
            }
            return this.delegate.newRole(roleName, usernames);
        }

        public boolean deleteRole(String roleName) throws IOException, InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new IOException("deleteRoleException");
            }
            return this.delegate.deleteRole(roleName);
        }

        public RoleRecord getRole(String roleName) throws InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new InvalidArgumentsException("getRoleException");
            }
            return this.delegate.getRole(roleName);
        }

        public RoleRecord silentlyGetRole(String roleName) {
            return this.delegate.silentlyGetRole(roleName);
        }

        public void addRoleToUser(String roleName, String username) throws IOException, InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new IOException("addRoleToUserException");
            }
            this.delegate.addRoleToUser(roleName, username);
        }

        public void removeRoleFromUser(String roleName, String username) throws IOException, InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new IOException("removeRoleFromUserException");
            }
            this.delegate.removeRoleFromUser(roleName, username);
        }

        public Set<String> getAllRoleNames() {
            return this.delegate.getAllRoleNames();
        }

        public Set<String> getRoleNamesForUser(String username) throws InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new InvalidArgumentsException("getRoleNamesForUserException");
            }
            return this.delegate.getRoleNamesForUser(username);
        }

        public Set<String> silentlyGetRoleNamesForUser(String username) {
            return this.delegate.silentlyGetRoleNamesForUser(username);
        }

        public Set<String> getUsernamesForRole(String roleName) throws InvalidArgumentsException {
            if (this.failNextCall) {
                this.failNextCall = false;
                throw new InvalidArgumentsException("getUsernamesForRoleException");
            }
            return this.delegate.getUsernamesForRole(roleName);
        }

        public Set<String> silentlyGetUsernamesForRole(String roleName) {
            return this.delegate.silentlyGetUsernamesForRole(roleName);
        }
    }
}

