/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.bolt.ManagedBoltStateMachine;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.enterprise.builtinprocs.EnterpriseBuiltInDbmsProcedures;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;
import org.neo4j.procedure.UserFunction;
import org.neo4j.server.security.enterprise.auth.AuthProceduresBase;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.NeoInteractionLevel;
import org.neo4j.server.security.enterprise.auth.ThreadedTransaction;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.rule.concurrent.ThreadingRule;

public abstract class ProcedureInteractionTestBase<S> {
    protected boolean PWD_CHANGE_CHECK_FIRST = false;
    protected String CHANGE_PWD_ERR_MSG = "Permission denied.";
    private static final String BOLT_PWD_ERR_MSG = "The credentials you provided were valid, but must be changed before you can use this instance.";
    String READ_OPS_NOT_ALLOWED = "Read operations are not allowed";
    String WRITE_OPS_NOT_ALLOWED = "Write operations are not allowed";
    String TOKEN_CREATE_OPS_NOT_ALLOWED = "Token create operations are not allowed";
    String SCHEMA_OPS_NOT_ALLOWED = "Schema operations are not allowed";
    protected boolean IS_EMBEDDED = true;
    boolean IS_BOLT = false;
    private final String EMPTY_ROLE = "empty";
    S adminSubject;
    S schemaSubject;
    S writeSubject;
    S editorSubject;
    S readSubject;
    S pwdSubject;
    S noneSubject;
    String[] initialUsers = new String[]{"adminSubject", "readSubject", "schemaSubject", "writeSubject", "editorSubject", "pwdSubject", "noneSubject", "neo4j"};
    String[] initialRoles = new String[]{"admin", "architect", "publisher", "editor", "reader", "empty"};
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    EnterpriseUserManager userManager;
    protected NeoInteractionLevel<S> neo;
    File securityLog;

    String pwdReqErrMsg(String errMsg) {
        return this.PWD_CHANGE_CHECK_FIRST ? this.CHANGE_PWD_ERR_MSG : (this.IS_EMBEDDED ? errMsg : BOLT_PWD_ERR_MSG);
    }

    private ThreadingRule threading() {
        return this.threading;
    }

    Map<String, String> defaultConfiguration() throws IOException {
        Path homeDir = Files.createTempDirectory("logs", new FileAttribute[0]);
        this.securityLog = new File(homeDir.toFile(), "security.log");
        return MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.logs_directory.name(), homeDir.toAbsolutePath().toString(), SecuritySettings.procedure_roles.name(), "test.allowed*Procedure:role1;test.nestedAllowedFunction:role1;test.allowedFunc*:role1;test.*estedAllowedProcedure:role1"});
    }

    @Before
    public void setUp() throws Throwable {
        this.configuredSetup(this.defaultConfiguration());
    }

    void configuredSetup(Map<String, String> config) throws Throwable {
        this.neo = this.setUpNeoServer(config);
        Procedures procedures = (Procedures)this.neo.getLocalGraph().getDependencyResolver().resolveDependency(Procedures.class);
        procedures.registerProcedure(ClassWithProcedures.class);
        procedures.registerFunction(ClassWithFunctions.class);
        this.userManager = this.neo.getLocalUserManager();
        this.userManager.newUser("noneSubject", "abc", false);
        this.userManager.newUser("pwdSubject", "abc", true);
        this.userManager.newUser("adminSubject", "abc", false);
        this.userManager.newUser("schemaSubject", "abc", false);
        this.userManager.newUser("writeSubject", "abc", false);
        this.userManager.newUser("editorSubject", "abc", false);
        this.userManager.newUser("readSubject", "123", false);
        this.userManager.addRoleToUser("admin", "adminSubject");
        this.userManager.addRoleToUser("architect", "schemaSubject");
        this.userManager.addRoleToUser("publisher", "writeSubject");
        this.userManager.addRoleToUser("editor", "editorSubject");
        this.userManager.addRoleToUser("reader", "readSubject");
        this.userManager.newRole("empty", new String[0]);
        this.noneSubject = this.neo.login("noneSubject", "abc");
        this.pwdSubject = this.neo.login("pwdSubject", "abc");
        this.readSubject = this.neo.login("readSubject", "123");
        this.editorSubject = this.neo.login("editorSubject", "abc");
        this.writeSubject = this.neo.login("writeSubject", "abc");
        this.schemaSubject = this.neo.login("schemaSubject", "abc");
        this.adminSubject = this.neo.login("adminSubject", "abc");
        this.assertEmpty(this.schemaSubject, "CREATE (n) SET n:A:Test:NEWNODE:VeryUniqueLabel:Node SET n.id = '2', n.square = '4', n.name = 'me', n.prop = 'a', n.number = '1' DELETE n");
        this.assertEmpty(this.writeSubject, "UNWIND range(0,2) AS number CREATE (:Node {number:number, name:'node'+number})");
    }

    protected abstract NeoInteractionLevel<S> setUpNeoServer(Map<String, String> var1) throws Throwable;

    @After
    public void tearDown() throws Throwable {
        if (this.neo != null) {
            this.neo.tearDown();
        }
    }

    protected String[] with(String[] strs, String ... moreStr) {
        return (String[])Stream.concat(Arrays.stream(strs), Arrays.stream(moreStr)).toArray(String[]::new);
    }

    List<String> listOf(String ... values) {
        return Stream.of(values).collect(Collectors.toList());
    }

    void testSuccessfulRead(S subject, int count) {
        this.assertSuccess(subject, "MATCH (n) RETURN count(n) as count", r -> {
            List result = r.stream().map(s -> s.get("count")).collect(Collectors.toList());
            MatcherAssert.assertThat((Object)result.size(), (Matcher)Matchers.equalTo((Object)1));
            MatcherAssert.assertThat((Object)String.valueOf(result.get(0)), (Matcher)Matchers.equalTo((Object)String.valueOf(count)));
        });
    }

    void testFailRead(S subject, int count) {
        this.testFailRead(subject, count, this.READ_OPS_NOT_ALLOWED);
    }

    void testFailRead(S subject, int count, String errMsg) {
        this.assertFail(subject, "MATCH (n) RETURN count(n)", errMsg);
    }

    void testSuccessfulWrite(S subject) {
        this.assertEmpty(subject, "CREATE (:Node)");
    }

    void testFailWrite(S subject) {
        this.testFailWrite(subject, this.WRITE_OPS_NOT_ALLOWED);
    }

    void testFailWrite(S subject, String errMsg) {
        this.assertFail(subject, "CREATE (:Node)", errMsg);
    }

    void testSuccessfulTokenWrite(S subject) {
        this.assertEmpty(subject, "CALL db.createLabel('NewNodeName')");
    }

    void testFailTokenWrite(S subject) {
        this.testFailTokenWrite(subject, this.TOKEN_CREATE_OPS_NOT_ALLOWED);
    }

    void testFailTokenWrite(S subject, String errMsg) {
        this.assertFail(subject, "CALL db.createLabel('NewNodeName')", errMsg);
    }

    void testSuccessfulSchema(S subject) {
        this.assertEmpty(subject, "CREATE INDEX ON :Node(number)");
    }

    void testFailSchema(S subject) {
        this.testFailSchema(subject, this.SCHEMA_OPS_NOT_ALLOWED);
    }

    void testFailSchema(S subject, String errMsg) {
        this.assertFail(subject, "CREATE INDEX ON :Node(number)", errMsg);
    }

    void testFailCreateUser(S subject, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.createUser('Craig', 'foo', false)", errMsg);
        this.assertFail(subject, "CALL dbms.security.createUser('Craig', '', false)", errMsg);
        this.assertFail(subject, "CALL dbms.security.createUser('', 'foo', false)", errMsg);
    }

    void testFailCreateRole(S subject, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.createRole('RealAdmins')", errMsg);
        this.assertFail(subject, "CALL dbms.security.createRole('RealAdmins')", errMsg);
        this.assertFail(subject, "CALL dbms.security.createRole('RealAdmins')", errMsg);
    }

    void testFailAddRoleToUser(S subject, String role, String username, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.addRoleToUser('" + role + "', '" + username + "')", errMsg);
    }

    void testFailRemoveRoleFromUser(S subject, String role, String username, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.removeRoleFromUser('" + role + "', '" + username + "')", errMsg);
    }

    void testFailDeleteUser(S subject, String username, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.deleteUser('" + username + "')", errMsg);
    }

    void testFailDeleteRole(S subject, String roleName, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.deleteRole('" + roleName + "')", errMsg);
    }

    void testSuccessfulListUsers(S subject, String[] users) {
        this.assertSuccess(subject, "CALL dbms.security.listUsers() YIELD username", r -> this.assertKeyIsArray((ResourceIterator<Map<String, Object>>)r, "username", users));
    }

    void testFailListUsers(S subject, int count, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.listUsers() YIELD username", errMsg);
    }

    void testSuccessfulListRoles(S subject, String[] roles) {
        this.assertSuccess(subject, "CALL dbms.security.listRoles() YIELD role", r -> this.assertKeyIsArray((ResourceIterator<Map<String, Object>>)r, "role", roles));
    }

    void testFailListRoles(S subject, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.listRoles() YIELD role", errMsg);
    }

    void testFailListUserRoles(S subject, String username, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.listRolesForUser('" + username + "') YIELD value AS roles RETURN count(roles)", errMsg);
    }

    void testFailListRoleUsers(S subject, String roleName, String errMsg) {
        this.assertFail(subject, "CALL dbms.security.listUsersForRole('" + roleName + "') YIELD value AS users RETURN count(users)", errMsg);
    }

    void testFailTestProcs(S subject) {
        this.assertFail(subject, "CALL test.allowedReadProcedure()", this.READ_OPS_NOT_ALLOWED);
        this.assertFail(subject, "CALL test.allowedWriteProcedure()", this.WRITE_OPS_NOT_ALLOWED);
        this.assertFail(subject, "CALL test.allowedSchemaProcedure()", this.SCHEMA_OPS_NOT_ALLOWED);
    }

    void testSuccessfulTestProcs(S subject) {
        this.assertSuccess(subject, "CALL test.allowedReadProcedure()", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "value", "foo"));
        this.assertSuccess(subject, "CALL test.allowedWriteProcedure()", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "value", "a", "a"));
        this.assertSuccess(subject, "CALL test.allowedSchemaProcedure()", r -> this.assertKeyIs((ResourceIterator<Map<String, Object>>)r, "value", "OK"));
    }

    void assertPasswordChangeWhenPasswordChangeRequired(S subject, String newPassword) {
        S subjectToUse;
        StringBuilder builder = new StringBuilder(128);
        if (this.IS_EMBEDDED) {
            subjectToUse = subject;
            builder.append("CALL dbms.security.changePassword('");
            builder.append(newPassword);
            builder.append("')");
        } else {
            subjectToUse = this.adminSubject;
            builder.append("CALL dbms.security.changeUserPassword('");
            builder.append(this.neo.nameOf(subject));
            builder.append("', '");
            builder.append(newPassword);
            builder.append("', false)");
        }
        this.assertEmpty(subjectToUse, builder.toString());
    }

    void assertFail(S subject, String call, String partOfErrorMsg) {
        String err = this.assertCallEmpty(subject, call);
        if (StringUtils.isEmpty((String)partOfErrorMsg)) {
            MatcherAssert.assertThat((Object)err, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)"")));
        } else {
            MatcherAssert.assertThat((Object)err, (Matcher)CoreMatchers.containsString((String)partOfErrorMsg));
        }
    }

    void assertEmpty(S subject, String call) {
        String err = this.assertCallEmpty(subject, call);
        MatcherAssert.assertThat((Object)err, (Matcher)Matchers.equalTo((Object)""));
    }

    void assertSuccess(S subject, String call, Consumer<ResourceIterator<Map<String, Object>>> resultConsumer) {
        String err = this.neo.executeQuery(subject, call, null, resultConsumer);
        MatcherAssert.assertThat((Object)err, (Matcher)Matchers.equalTo((Object)""));
    }

    List<Map<String, Object>> collectSuccessResult(S subject, String call) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        this.assertSuccess(subject, call, r -> r.stream().forEach(result::add));
        return result;
    }

    private String assertCallEmpty(S subject, String call) {
        return this.neo.executeQuery(subject, call, null, result -> Assert.assertTrue((String)"Expected no results", (boolean)result.stream().collect(Collectors.toList()).isEmpty()));
    }

    private void executeQuery(S subject, String call) {
        this.neo.executeQuery(subject, call, null, r -> {});
    }

    boolean userHasRole(String user, String role) throws InvalidArgumentsException {
        return this.userManager.getRoleNamesForUser(user).contains(role);
    }

    List<Object> getObjectsAsList(ResourceIterator<Map<String, Object>> r, String key) {
        return r.stream().map(s -> s.get(key)).collect(Collectors.toList());
    }

    void assertKeyIs(ResourceIterator<Map<String, Object>> r, String key, String ... items) {
        this.assertKeyIsArray(r, key, items);
    }

    private void assertKeyIsArray(ResourceIterator<Map<String, Object>> r, String key, String[] items) {
        List<Object> results = this.getObjectsAsList(r, key);
        Assert.assertEquals((long)Arrays.asList(items).size(), (long)results.size());
        Assert.assertThat(results, (Matcher)Matchers.containsInAnyOrder((Object[])items));
    }

    static void assertKeyIsMap(ResourceIterator<Map<String, Object>> r, String keyKey, String valueKey, Map<String, Object> expected) {
        List result = r.stream().collect(Collectors.toList());
        Assert.assertEquals((String)("Results for should have size " + expected.size() + " but was " + result.size()), (long)expected.size(), (long)result.size());
        for (Map row : result) {
            Object value;
            String key = (String)row.get(keyKey);
            MatcherAssert.assertThat(expected, (Matcher)Matchers.hasKey((Object)key));
            MatcherAssert.assertThat((Object)row, (Matcher)Matchers.hasKey((Object)valueKey));
            Object objectValue = row.get(valueKey);
            if (objectValue instanceof List) {
                value = (List)objectValue;
                List expectedValues = (List)expected.get(key);
                Assert.assertEquals((String)"sizes", (long)value.size(), (long)expectedValues.size());
                MatcherAssert.assertThat((Object)value, (Matcher)Matchers.containsInAnyOrder((Object[])expectedValues.toArray()));
                continue;
            }
            value = objectValue.toString();
            String expectedValue = expected.get(key).toString();
            MatcherAssert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)expectedValue));
        }
    }

    void shouldTerminateTransactionsForUser(S subject, String procedure) throws Throwable {
        DoubleLatch latch = new DoubleLatch(2);
        ThreadedTransaction<S> userThread = new ThreadedTransaction<S>(this.neo, latch);
        userThread.executeCreateNode(this.threading(), subject);
        latch.startAndWaitForAllToStart();
        this.assertEmpty(this.adminSubject, "CALL " + String.format(procedure, this.neo.nameOf(subject)));
        Map<String, Long> transactionsByUser = this.countTransactionsByUsername();
        MatcherAssert.assertThat((Object)transactionsByUser.get(this.neo.nameOf(subject)), (Matcher)Matchers.equalTo(null));
        latch.finishAndWaitForAllToFinish();
        userThread.closeAndAssertExplicitTermination();
        this.assertEmpty(this.adminSubject, "MATCH (n:Test) RETURN n.name AS name");
    }

    private Map<String, Long> countTransactionsByUsername() {
        return EnterpriseBuiltInDbmsProcedures.countTransactionByUsername(EnterpriseBuiltInDbmsProcedures.getActiveTransactions((DependencyResolver)this.neo.getLocalGraph().getDependencyResolver()).stream().filter(tx -> !tx.terminationReason().isPresent()).map(tx -> tx.securityContext().subject().username())).collect(Collectors.toMap(r -> r.username, r -> r.activeTransactions));
    }

    Map<String, Long> countBoltConnectionsByUsername() {
        BoltConnectionTracker boltConnectionTracker = EnterpriseBuiltInDbmsProcedures.getBoltConnectionTracker((DependencyResolver)this.neo.getLocalGraph().getDependencyResolver());
        return EnterpriseBuiltInDbmsProcedures.countConnectionsByUsername(boltConnectionTracker.getActiveConnections().stream().filter(session -> !session.willTerminate()).map(ManagedBoltStateMachine::owner)).collect(Collectors.toMap(r -> r.username, r -> r.connectionCount));
    }

    TransportConnection startBoltSession(String username, String password) throws Exception {
        SocketConnection connection = new SocketConnection();
        HostnamePort address = new HostnamePort("localhost:7687");
        Map authToken = MapUtil.map((Object[])new Object[]{"principal", username, "credentials", password, "scheme", "basic"});
        connection.connect(address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)authToken)}));
        MatcherAssert.assertThat((Object)connection, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)connection, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess()}));
        return connection;
    }

    public static class ClassWithFunctions {
        @Context
        public GraphDatabaseService db;

        @UserFunction(name="test.nonAllowedFunc")
        public String nonAllowedFunc() {
            return "success";
        }

        @UserFunction(name="test.allowedFunc")
        public String allowedFunc() {
            return "success for role1";
        }

        @UserFunction(name="test.allowedFunction1")
        public String allowedFunction1() {
            Result result = this.db.execute("MATCH (:Foo) WITH count(*) AS c RETURN 'foo' AS foo");
            return result.next().get("foo").toString();
        }

        @UserFunction(name="test.allowedFunction2")
        public String allowedFunction2() {
            Result result = this.db.execute("MATCH (:Foo) WITH count(*) AS c RETURN 'foo' AS foo");
            return result.next().get("foo").toString();
        }

        @UserFunction(name="test.nestedAllowedFunction")
        public String nestedAllowedFunction(@Name(value="nestedFunction") String nestedFunction) {
            Result result = this.db.execute("RETURN " + nestedFunction + " AS value");
            return result.next().get("value").toString();
        }
    }

    public static class ClassWithProcedures {
        @Context
        public GraphDatabaseService db;
        @Context
        public Log log;
        private static final AtomicReference<LatchedRunnables> testLatch = new AtomicReference();
        static DoubleLatch doubleLatch = null;
        public static volatile DoubleLatch volatileLatch = null;
        public static List<Exception> exceptionsInProcedure = Collections.synchronizedList(new ArrayList());
        @Context
        public TerminationGuard guard;

        @Procedure(name="test.loop")
        public void loop() {
            DoubleLatch latch = volatileLatch;
            if (latch != null) {
                latch.startAndWaitForAllToStart();
            }
            try {
                while (true) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    this.guard.check();
                }
            }
            catch (Throwable throwable) {
                if (latch != null) {
                    latch.finish();
                }
                throw throwable;
            }
        }

        @Procedure(name="test.neverEnding")
        public void neverEndingWithLock() {
            doubleLatch.start();
            doubleLatch.finishAndWaitForAllToFinish();
        }

        @Procedure(name="test.numNodes")
        public Stream<CountResult> numNodes() {
            Long nNodes = this.db.getAllNodes().stream().count();
            return Stream.of(new CountResult(nNodes));
        }

        @Procedure(name="test.staticReadProcedure", mode=Mode.READ)
        public Stream<AuthProceduresBase.StringResult> staticReadProcedure() {
            return Stream.of(new AuthProceduresBase.StringResult("static"));
        }

        @Procedure(name="test.staticWriteProcedure", mode=Mode.WRITE)
        public Stream<AuthProceduresBase.StringResult> staticWriteProcedure() {
            return Stream.of(new AuthProceduresBase.StringResult("static"));
        }

        @Procedure(name="test.staticSchemaProcedure", mode=Mode.SCHEMA)
        public Stream<AuthProceduresBase.StringResult> staticSchemaProcedure() {
            return Stream.of(new AuthProceduresBase.StringResult("static"));
        }

        @Procedure(name="test.allowedReadProcedure", mode=Mode.READ)
        public Stream<AuthProceduresBase.StringResult> allowedProcedure1() {
            Result result = this.db.execute("MATCH (:Foo) WITH count(*) AS c RETURN 'foo' AS foo");
            return result.stream().map(r -> new AuthProceduresBase.StringResult(r.get("foo").toString()));
        }

        @Procedure(name="test.otherAllowedReadProcedure", mode=Mode.READ)
        public Stream<AuthProceduresBase.StringResult> otherAllowedProcedure() {
            Result result = this.db.execute("MATCH (:Foo) WITH count(*) AS c RETURN 'foo' AS foo");
            return result.stream().map(r -> new AuthProceduresBase.StringResult(r.get("foo").toString()));
        }

        @Procedure(name="test.allowedWriteProcedure", mode=Mode.WRITE)
        public Stream<AuthProceduresBase.StringResult> allowedProcedure2() {
            this.db.execute("UNWIND [1, 2] AS i CREATE (:VeryUniqueLabel {prop: 'a'})");
            Result result = this.db.execute("MATCH (n:VeryUniqueLabel) RETURN n.prop AS a LIMIT 2");
            return result.stream().map(r -> new AuthProceduresBase.StringResult(r.get("a").toString()));
        }

        @Procedure(name="test.allowedSchemaProcedure", mode=Mode.SCHEMA)
        public Stream<AuthProceduresBase.StringResult> allowedProcedure3() {
            this.db.execute("CREATE INDEX ON :VeryUniqueLabel(prop)");
            return Stream.of(new AuthProceduresBase.StringResult("OK"));
        }

        @Procedure(name="test.nestedAllowedProcedure", mode=Mode.READ)
        public Stream<AuthProceduresBase.StringResult> nestedAllowedProcedure(@Name(value="nestedProcedure") String nestedProcedure) {
            Result result = this.db.execute("CALL " + nestedProcedure);
            return result.stream().map(r -> new AuthProceduresBase.StringResult(r.get("value").toString()));
        }

        @Procedure(name="test.doubleNestedAllowedProcedure", mode=Mode.READ)
        public Stream<AuthProceduresBase.StringResult> doubleNestedAllowedProcedure() {
            Result result = this.db.execute("CALL test.nestedAllowedProcedure('test.allowedReadProcedure') YIELD value");
            return result.stream().map(r -> new AuthProceduresBase.StringResult(r.get("value").toString()));
        }

        @Procedure(name="test.failingNestedAllowedWriteProcedure", mode=Mode.WRITE)
        public Stream<AuthProceduresBase.StringResult> failingNestedAllowedWriteProcedure() {
            Result result = this.db.execute("CALL test.nestedReadProcedure('test.allowedWriteProcedure') YIELD value");
            return result.stream().map(r -> new AuthProceduresBase.StringResult(r.get("value").toString()));
        }

        @Procedure(name="test.nestedReadProcedure", mode=Mode.READ)
        public Stream<AuthProceduresBase.StringResult> nestedReadProcedure(@Name(value="nestedProcedure") String nestedProcedure) {
            Result result = this.db.execute("CALL " + nestedProcedure);
            return result.stream().map(r -> new AuthProceduresBase.StringResult(r.get("value").toString()));
        }

        @Procedure(name="test.createNode", mode=Mode.WRITE)
        public void createNode() {
            this.db.createNode();
        }

        @Procedure(name="test.waitForLatch", mode=Mode.READ)
        public void waitForLatch() {
            try {
                ClassWithProcedures.testLatch.get().runBefore.run();
            }
            finally {
                ClassWithProcedures.testLatch.get().doubleLatch.startAndWaitForAllToStart();
            }
            try {
                ClassWithProcedures.testLatch.get().runAfter.run();
            }
            finally {
                ClassWithProcedures.testLatch.get().doubleLatch.finishAndWaitForAllToFinish();
            }
        }

        @Procedure(name="test.threadTransaction", mode=Mode.WRITE)
        public void newThreadTransaction() {
            this.startWriteThread();
        }

        @Procedure(name="test.threadReadDoingWriteTransaction")
        public void threadReadDoingWriteTransaction() {
            this.startWriteThread();
        }

        private void startWriteThread() {
            new Thread(() -> {
                doubleLatch.start();
                try (Transaction tx = this.db.beginTx();){
                    this.db.createNode(new Label[]{Label.label((String)"VeryUniqueLabel")});
                    tx.success();
                }
                catch (Exception e) {
                    exceptionsInProcedure.add(e);
                }
                finally {
                    doubleLatch.finish();
                }
            }).start();
        }

        static void setTestLatch(LatchedRunnables testLatch) {
            ClassWithProcedures.testLatch.set(testLatch);
        }

        protected static class LatchedRunnables
        implements AutoCloseable {
            DoubleLatch doubleLatch;
            Runnable runBefore;
            Runnable runAfter;

            LatchedRunnables(DoubleLatch doubleLatch, Runnable runBefore, Runnable runAfter) {
                this.doubleLatch = doubleLatch;
                this.runBefore = runBefore;
                this.runAfter = runAfter;
            }

            @Override
            public void close() throws Exception {
                testLatch.set(null);
            }
        }
    }

    public static class CountResult {
        public final String count;

        CountResult(Long count) {
            this.count = "" + count;
        }
    }
}

