/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.security.enterprise.auth.RoleRecord;
import org.neo4j.server.security.enterprise.auth.RoleSerialization;
import org.neo4j.string.UTF8;

public class RoleSerializationTest {
    private SortedSet<String> steveBob;
    private SortedSet<String> kellyMarie;

    @Before
    public void setUp() {
        this.steveBob = new TreeSet<String>();
        this.steveBob.add("Steve");
        this.steveBob.add("Bob");
        this.kellyMarie = new TreeSet<String>();
        this.kellyMarie.add("Kelly");
        this.kellyMarie.add("Marie");
    }

    @Test
    public void shouldSerializeAndDeserialize() throws Exception {
        RoleSerialization serialization = new RoleSerialization();
        List<RoleRecord> roles = Arrays.asList(new RoleRecord("admin", this.steveBob), new RoleRecord("publisher", this.kellyMarie));
        byte[] serialized = serialization.serialize(roles);
        MatcherAssert.assertThat((Object)serialization.deserializeRecords(serialized), (Matcher)Matchers.equalTo(roles));
    }

    @Test
    public void shouldReadV1SerializationFormat() throws Exception {
        RoleSerialization serialization = new RoleSerialization();
        List deserialized = serialization.deserializeRecords(UTF8.encode((String)"admin:Bob,Steve\npublisher:Kelly,Marie\n"));
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.equalTo(Arrays.asList(new RoleRecord("admin", this.steveBob), new RoleRecord("publisher", this.kellyMarie))));
    }
}

