/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.server.security.enterprise.auth.AuthProceduresBase;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.SecurityProcedures;

public class SecurityProceduresTest {
    private SecurityProcedures procedures;

    @Before
    public void setup() {
        AuthSubject subject = (AuthSubject)Mockito.mock(AuthSubject.class);
        Mockito.when((Object)subject.username()).thenReturn((Object)"pearl");
        EnterpriseSecurityContext ctx = (EnterpriseSecurityContext)Mockito.mock(EnterpriseSecurityContext.class);
        Mockito.when((Object)ctx.subject()).thenReturn((Object)subject);
        Mockito.when((Object)ctx.roles()).thenReturn(Collections.singleton("jammer"));
        this.procedures = new SecurityProcedures();
        this.procedures.securityContext = ctx;
        this.procedures.userManager = (EnterpriseUserManager)Mockito.mock(EnterpriseUserManager.class);
    }

    @Test
    public void shouldReturnSecurityContextRoles() throws IOException, InvalidArgumentsException {
        List infoList = this.procedures.showCurrentUser().collect(Collectors.toList());
        MatcherAssert.assertThat((Object)infoList.size(), (Matcher)Matchers.equalTo((Object)1));
        AuthProceduresBase.UserResult row = (AuthProceduresBase.UserResult)infoList.get(0);
        MatcherAssert.assertThat((Object)row.username, (Matcher)Matchers.equalTo((Object)"pearl"));
        MatcherAssert.assertThat((Object)row.roles, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"jammer"}));
        MatcherAssert.assertThat((Object)row.flags, (Matcher)Matchers.empty());
    }
}

