/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.server.security.enterprise.auth.ShiroAuthToken;

public class ShiroAuthTokenTest {
    private final String USERNAME = "myuser";
    private final String PASSWORD = "mypw123";

    @Test
    public void shouldSupportBasicAuthToken() throws Exception {
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newBasicAuthToken((String)"myuser", (String)"mypw123"));
        this.testBasicAuthToken(token, "myuser", "mypw123", "basic");
        MatcherAssert.assertThat((String)"Token map should have only expected values", (Object)token.getAuthTokenMap(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"principal", "myuser", "credentials", "mypw123", "scheme", "basic"})));
        this.testTokenSupportsRealm(token, true, "unknown", "native", "ldap");
    }

    @Test
    public void shouldSupportBasicAuthTokenWithWildcardRealm() throws Exception {
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newBasicAuthToken((String)"myuser", (String)"mypw123", (String)"*"));
        this.testBasicAuthToken(token, "myuser", "mypw123", "basic");
        MatcherAssert.assertThat((String)"Token map should have only expected values", (Object)token.getAuthTokenMap(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"principal", "myuser", "credentials", "mypw123", "scheme", "basic", "realm", "*"})));
        this.testTokenSupportsRealm(token, true, "unknown", "native", "ldap");
    }

    @Test
    public void shouldSupportBasicAuthTokenWithSpecificRealm() throws Exception {
        String realm = "ldap";
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newBasicAuthToken((String)"myuser", (String)"mypw123", (String)realm));
        this.testBasicAuthToken(token, "myuser", "mypw123", "basic");
        MatcherAssert.assertThat((String)"Token map should have only expected values", (Object)token.getAuthTokenMap(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"principal", "myuser", "credentials", "mypw123", "scheme", "basic", "realm", "ldap"})));
        this.testTokenSupportsRealm(token, true, realm);
        this.testTokenSupportsRealm(token, false, "unknown", "native");
    }

    @Test
    public void shouldSupportCustomAuthTokenWithSpecificRealm() throws Exception {
        String realm = "ldap";
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newCustomAuthToken((String)"myuser", (String)"mypw123", (String)realm, (String)"basic"));
        this.testBasicAuthToken(token, "myuser", "mypw123", "basic");
        MatcherAssert.assertThat((String)"Token map should have only expected values", (Object)token.getAuthTokenMap(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"principal", "myuser", "credentials", "mypw123", "scheme", "basic", "realm", "ldap"})));
        this.testTokenSupportsRealm(token, true, realm);
        this.testTokenSupportsRealm(token, false, "unknown", "native");
    }

    @Test
    public void shouldSupportCustomAuthTokenWithSpecificRealmAndParameters() throws Exception {
        String realm = "ldap";
        Map params = MapUtil.map((Object[])new Object[]{"a", "A", "b", "B"});
        ShiroAuthToken token = new ShiroAuthToken(AuthToken.newCustomAuthToken((String)"myuser", (String)"mypw123", (String)realm, (String)"basic", (Map)params));
        this.testBasicAuthToken(token, "myuser", "mypw123", "basic");
        MatcherAssert.assertThat((String)"Token map should have only expected values", (Object)token.getAuthTokenMap(), (Matcher)Matchers.equalTo((Object)MapUtil.map((Object[])new Object[]{"principal", "myuser", "credentials", "mypw123", "scheme", "basic", "realm", "ldap", "parameters", params})));
        this.testTokenSupportsRealm(token, true, realm);
        this.testTokenSupportsRealm(token, false, "unknown", "native");
    }

    private void testTokenSupportsRealm(ShiroAuthToken token, boolean supports, String ... realms) {
        for (String realm : realms) {
            MatcherAssert.assertThat((String)("Token should support '" + realm + "' realm"), (Object)token.supportsRealm(realm), (Matcher)Matchers.equalTo((Object)supports));
        }
    }

    private void testBasicAuthToken(ShiroAuthToken token, String username, String password, String scheme) throws InvalidAuthTokenException {
        MatcherAssert.assertThat((String)"Token should have basic scheme", (Object)token.getScheme(), (Matcher)Matchers.equalTo((Object)scheme));
        MatcherAssert.assertThat((String)"Token have correct principal", (Object)token.getPrincipal(), (Matcher)Matchers.equalTo((Object)username));
        MatcherAssert.assertThat((String)"Token have correct credentials", (Object)token.getCredentials(), (Matcher)Matchers.equalTo((Object)password));
    }
}

