/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import org.apache.shiro.authc.AuthenticationInfo;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.server.security.enterprise.auth.ShiroAuthenticationInfo;

public class ShiroAuthenticationInfoTest {
    private ShiroAuthenticationInfo successInfo = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.SUCCESS);
    private ShiroAuthenticationInfo failureInfo = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
    private ShiroAuthenticationInfo tooManyAttemptsInfo = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.TOO_MANY_ATTEMPTS);
    private ShiroAuthenticationInfo pwChangeRequiredInfo = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.PASSWORD_CHANGE_REQUIRED);

    @Test
    public void shouldChangeMergeMatrixIfAuthenticationResultEnumChanges() {
        Assert.assertEquals((long)AuthenticationResult.SUCCESS.ordinal(), (long)0L);
        Assert.assertEquals((long)AuthenticationResult.FAILURE.ordinal(), (long)1L);
        Assert.assertEquals((long)AuthenticationResult.TOO_MANY_ATTEMPTS.ordinal(), (long)2L);
        Assert.assertEquals((long)AuthenticationResult.PASSWORD_CHANGE_REQUIRED.ordinal(), (long)3L);
        Assert.assertEquals((long)AuthenticationResult.values().length, (long)4L);
    }

    @Test
    public void shouldMergeTwoSuccessToSameValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.SUCCESS);
        info.merge((AuthenticationInfo)this.successInfo);
        Assert.assertEquals((Object)info.getAuthenticationResult(), (Object)AuthenticationResult.SUCCESS);
    }

    @Test
    public void shouldMergeTwoFailureToSameValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.failureInfo);
        Assert.assertEquals((Object)info.getAuthenticationResult(), (Object)AuthenticationResult.FAILURE);
    }

    @Test
    public void shouldMergeTwoTooManyAttemptsToSameValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.TOO_MANY_ATTEMPTS);
        info.merge((AuthenticationInfo)this.tooManyAttemptsInfo);
        Assert.assertEquals((Object)info.getAuthenticationResult(), (Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
    }

    @Test
    public void shouldMergeTwoPasswordChangeRequiredToSameValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
        info.merge((AuthenticationInfo)this.pwChangeRequiredInfo);
        Assert.assertEquals((Object)info.getAuthenticationResult(), (Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
    }

    @Test
    public void shouldMergeFailureWithSuccessToNewValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.successInfo);
        Assert.assertEquals((Object)info.getAuthenticationResult(), (Object)AuthenticationResult.SUCCESS);
    }

    @Test
    public void shouldMergeFailureWithTooManyAttemptsToNewValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.tooManyAttemptsInfo);
        Assert.assertEquals((Object)info.getAuthenticationResult(), (Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
    }

    @Test
    public void shouldMergeFailureWithPasswordChangeRequiredToNewValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.pwChangeRequiredInfo);
        Assert.assertEquals((Object)info.getAuthenticationResult(), (Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
    }

    @Test
    public void shouldMergeToNewValue() {
        ShiroAuthenticationInfo info = new ShiroAuthenticationInfo((Object)"user", "realm", AuthenticationResult.FAILURE);
        info.merge((AuthenticationInfo)this.pwChangeRequiredInfo);
        Assert.assertEquals((Object)info.getAuthenticationResult(), (Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
    }
}

