/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import com.google.common.testing.FakeTicker;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.server.security.enterprise.auth.ShiroCaffeineCache;

public class ShiroCaffeineCacheTest {
    private ShiroCaffeineCache<Integer, String> cache;
    private FakeTicker fakeTicker;
    private long TTL = 100L;

    @Before
    public void setUp() {
        this.fakeTicker = new FakeTicker();
        this.cache = new ShiroCaffeineCache(() -> ((FakeTicker)this.fakeTicker).read(), Runnable::run, this.TTL, 5);
    }

    @Test
    public void shouldFailToCreateAuthCacheForTTLZero() {
        try {
            new ShiroCaffeineCache(() -> ((FakeTicker)this.fakeTicker).read(), Runnable::run, 0L, 5);
            Assert.fail((String)"Expected IllegalArgumentException for a TTL of 0");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"TTL must be larger than zero."));
        }
        catch (Throwable t) {
            Assert.fail((String)"Expected IllegalArgumentException for a TTL of 0");
        }
    }

    @Test
    public void shouldNotGetNonExistentValue() {
        Assert.assertThat((Object)this.cache.get((Object)1), (Matcher)Matchers.equalTo(null));
    }

    @Test
    public void shouldPutAndGet() {
        this.cache.put((Object)1, (Object)"1");
        Assert.assertThat((Object)this.cache.get((Object)1), (Matcher)Matchers.equalTo((Object)"1"));
    }

    @Test
    public void shouldNotReturnExpiredValueThroughPut() {
        Assert.assertNull((Object)this.cache.put((Object)1, (Object)"first"));
        Assert.assertThat((Object)this.cache.put((Object)1, (Object)"second"), (Matcher)Matchers.equalTo((Object)"first"));
        this.fakeTicker.advance(this.TTL + 1L, TimeUnit.MILLISECONDS);
        Assert.assertNull((Object)this.cache.put((Object)1, (Object)"third"));
    }

    @Test
    public void shouldRemove() {
        Assert.assertNull((Object)this.cache.remove((Object)1));
        this.cache.put((Object)1, (Object)"1");
        Assert.assertThat((Object)this.cache.remove((Object)1), (Matcher)Matchers.equalTo((Object)"1"));
    }

    @Test
    public void shouldClear() {
        this.cache.put((Object)1, (Object)"1");
        this.cache.put((Object)2, (Object)"2");
        Assert.assertThat((Object)this.cache.size(), (Matcher)Matchers.equalTo((Object)2));
        this.cache.clear();
        Assert.assertThat((Object)this.cache.size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void shouldGetKeys() {
        this.cache.put((Object)1, (Object)"1");
        this.cache.put((Object)2, (Object)"1");
        this.cache.put((Object)3, (Object)"1");
        Assert.assertThat((Object)this.cache.keys(), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void shouldGetValues() {
        this.cache.put((Object)1, (Object)"1");
        this.cache.put((Object)2, (Object)"1");
        this.cache.put((Object)3, (Object)"1");
        Assert.assertThat((Object)this.cache.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"1", "1", "1"}));
    }

    @Test
    public void shouldNotListExpiredValues() {
        this.cache.put((Object)1, (Object)"1");
        this.fakeTicker.advance(this.TTL + 1L, TimeUnit.MILLISECONDS);
        this.cache.put((Object)2, (Object)"foo");
        Assert.assertThat((Object)this.cache.values(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo"}));
    }

    @Test
    public void shouldNotGetExpiredValues() {
        this.cache.put((Object)1, (Object)"1");
        this.fakeTicker.advance(this.TTL + 1L, TimeUnit.MILLISECONDS);
        this.cache.put((Object)2, (Object)"foo");
        Assert.assertThat((Object)this.cache.get((Object)1), (Matcher)Matchers.equalTo(null));
        Assert.assertThat((Object)this.cache.get((Object)2), (Matcher)Matchers.equalTo((Object)"foo"));
    }

    @Test
    public void shouldNotGetKeysForExpiredValues() {
        this.cache.put((Object)1, (Object)"1");
        this.fakeTicker.advance(this.TTL + 1L, TimeUnit.MILLISECONDS);
        this.cache.put((Object)2, (Object)"foo");
        Assert.assertThat((Object)this.cache.keys(), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{2}));
    }

    @Test
    public void shouldRemoveIfExceededCapacity() {
        this.cache.put((Object)1, (Object)"one");
        this.cache.put((Object)2, (Object)"two");
        this.cache.put((Object)3, (Object)"three");
        this.cache.put((Object)4, (Object)"four");
        this.cache.put((Object)5, (Object)"five");
        this.cache.put((Object)6, (Object)"six");
        Assert.assertThat((Object)this.cache.size(), (Matcher)Matchers.equalTo((Object)5));
    }

    @Test
    public void shouldGetValueAfterTimePassed() {
        this.cache.put((Object)1, (Object)"foo");
        this.fakeTicker.advance(this.TTL - 1L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)this.cache.get((Object)1), (Matcher)Matchers.equalTo((Object)"foo"));
    }
}

